/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.yum.internal.metadata;

import com.google.common.io.CountingOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.common.hash.MultiHashingOutputStream;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.storage.StorageFacet;
import org.sonatype.nexus.repository.storage.TempBlob;
import org.sonatype.nexus.repository.yum.internal.metadata.CompressedTempBlob;
import org.sonatype.nexus.repository.yum.internal.utils.YumFacetUtils;
import org.sonatype.nexus.repository.yum.internal.utils.YumMetadataUtils;

@Named
@Singleton
public class YumAbsoluteUrlRemover
extends ComponentSupport {
    private static final String BASE_ATTRIBUTE = "base";
    private static final String LOCATION = "location";

    public CompressedTempBlob removeAbsoluteUrls(TempBlob primary, String fileName, Repository repository) {
        CompressedTempBlob compressedTempBlob;
        Path tempFile;
        block27: {
            tempFile = Files.createTempFile("yum-primary-" + UUID.randomUUID().toString(), "xml", new FileAttribute[0]);
            Throwable throwable = null;
            Object var6_8 = null;
            InputStream xmlIn = YumMetadataUtils.xmlInputStream(fileName, primary.get());
            try {
                Map hashes;
                long count;
                MutableBoolean modified = new MutableBoolean(false);
                Throwable throwable2 = null;
                Object var13_14 = null;
                try (OutputStream xmlOut = YumMetadataUtils.xmlOutputStream(fileName, tempFile);){
                    CountingOutputStream countOut = new CountingOutputStream(xmlOut);
                    MultiHashingOutputStream hashOut = new MultiHashingOutputStream(YumFacetUtils.HASH_ALGORITHMS, (OutputStream)countOut);
                    XMLInputFactory inputFactory = XMLInputFactory.newFactory();
                    XMLOutputFactory outputFactory = XMLOutputFactory.newFactory();
                    XMLEventReader reader = inputFactory.createXMLEventReader(xmlIn, "UTF-8");
                    XMLEventWriter writer = outputFactory.createXMLEventWriter((OutputStream)hashOut, "UTF-8");
                    this.streamXmlToWriterAndRemoveAbsoluteUrls(reader, writer, modified);
                    count = countOut.getCount();
                    hashes = hashOut.hashes();
                }
                catch (Throwable throwable3) {
                    if (throwable2 == null) {
                        throwable2 = throwable3;
                    } else if (throwable2 != throwable3) {
                        throwable2.addSuppressed(throwable3);
                    }
                    throw throwable2;
                }
                compressedTempBlob = new CompressedTempBlob(this.convertFileToTempBlob(tempFile, repository), count, hashes, modified.booleanValue());
                if (xmlIn == null) break block27;
            }
            catch (Throwable throwable4) {
                try {
                    if (xmlIn != null) {
                        xmlIn.close();
                    }
                    throw throwable4;
                }
                catch (Throwable throwable5) {
                    try {
                        if (throwable == null) {
                            throwable = throwable5;
                        } else if (throwable != throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                        throw throwable;
                    }
                    catch (Throwable throwable6) {
                        try {
                            Files.delete(tempFile);
                            throw throwable6;
                        }
                        catch (IOException | XMLStreamException ex) {
                            this.log.error("Failed to fix absolute urls for file {} and blob {} with reason: {} ", new Object[]{fileName, primary.getBlob().getId(), ex});
                            return new CompressedTempBlob(primary, 0L, primary.getHashes(), false);
                        }
                    }
                }
            }
            xmlIn.close();
        }
        Files.delete(tempFile);
        return compressedTempBlob;
    }

    private void streamXmlToWriterAndRemoveAbsoluteUrls(XMLEventReader reader, XMLEventWriter writer, MutableBoolean modified) throws XMLStreamException {
        XMLEventFactory eventFactory = XMLEventFactory.newInstance();
        while (reader.hasNext()) {
            StartElement startElement;
            XMLEvent event = reader.nextEvent();
            if (event.getEventType() == 1 && (startElement = event.asStartElement()).getName().getLocalPart().equals(LOCATION)) {
                event = this.removeAttributeAndRebuildEvent(eventFactory, event.asStartElement(), modified);
            }
            writer.add(event);
        }
    }

    private StartElement removeAttributeAndRebuildEvent(XMLEventFactory eventFactory, StartElement startElement, MutableBoolean modified) {
        Iterator fixedAttributes = this.removeAbsoluteUrlFromAttributes(startElement.getAttributes(), modified);
        return eventFactory.createStartElement(startElement.getName().getPrefix(), startElement.getName().getNamespaceURI(), startElement.getName().getLocalPart(), fixedAttributes, null);
    }

    private Iterator removeAbsoluteUrlFromAttributes(Iterator<Attribute> attributes, MutableBoolean modified) {
        ArrayList<Attribute> processedAttributes = new ArrayList<Attribute>();
        while (attributes.hasNext()) {
            Attribute attribute = attributes.next();
            if (attribute.getName().getLocalPart().equals(BASE_ATTRIBUTE)) {
                modified.setTrue();
                continue;
            }
            processedAttributes.add(attribute);
        }
        return processedAttributes.iterator();
    }

    private TempBlob convertFileToTempBlob(Path tempFile, Repository repository) throws IOException {
        StorageFacet storageFacet = (StorageFacet)repository.facet(StorageFacet.class);
        Throwable throwable = null;
        Object var5_6 = null;
        try (InputStream tempFileInputStream = Files.newInputStream(tempFile, new OpenOption[0]);){
            return storageFacet.createTempBlob(tempFileInputStream, YumFacetUtils.HASH_ALGORITHMS);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

