/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.yum.internal.proxy;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.base.Throwables;
import java.io.IOException;
import java.io.InputStream;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import org.sonatype.nexus.common.collect.AttributesMap;
import org.sonatype.nexus.common.hash.HashAlgorithm;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.cache.CacheController;
import org.sonatype.nexus.repository.cache.CacheInfo;
import org.sonatype.nexus.repository.config.Configuration;
import org.sonatype.nexus.repository.proxy.ProxyFacetSupport;
import org.sonatype.nexus.repository.storage.Asset;
import org.sonatype.nexus.repository.storage.Bucket;
import org.sonatype.nexus.repository.storage.StorageFacet;
import org.sonatype.nexus.repository.storage.StorageTx;
import org.sonatype.nexus.repository.storage.TempBlob;
import org.sonatype.nexus.repository.transaction.TransactionalDeleteBlob;
import org.sonatype.nexus.repository.transaction.TransactionalTouchMetadata;
import org.sonatype.nexus.repository.view.Content;
import org.sonatype.nexus.repository.view.Context;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.Request;
import org.sonatype.nexus.repository.view.Response;
import org.sonatype.nexus.repository.view.ViewFacet;
import org.sonatype.nexus.repository.view.matchers.token.TokenMatcher;
import org.sonatype.nexus.repository.yum.AssetKind;
import org.sonatype.nexus.repository.yum.YumFacet;
import org.sonatype.nexus.repository.yum.internal.database.YumQueryComponent;
import org.sonatype.nexus.repository.yum.internal.metadata.CompressedTempBlob;
import org.sonatype.nexus.repository.yum.internal.metadata.RepomdProcessor;
import org.sonatype.nexus.repository.yum.internal.metadata.YumAbsoluteUrlRemover;
import org.sonatype.nexus.repository.yum.internal.utils.TempBlobDocumentConverter;
import org.sonatype.nexus.repository.yum.internal.utils.YumFacetUtils;
import org.sonatype.nexus.repository.yum.utils.YumPathUtils;
import org.sonatype.nexus.transaction.UnitOfWork;
import org.w3c.dom.Document;

@Named
public class YumProxyFacetImpl
extends ProxyFacetSupport {
    private static final String REPODATA_PATH = "repodata/";
    private final RepomdProcessor repomdProcessor;
    private final TempBlobDocumentConverter tempBlobConverter;
    private final YumAbsoluteUrlRemover yumAbsoluteUrlRemover;
    private final YumQueryComponent yumQueryComponent;
    private YumFacet yumFacet;

    @Inject
    public YumProxyFacetImpl(RepomdProcessor repomdProcessor, TempBlobDocumentConverter tempBlobConverter, YumAbsoluteUrlRemover yumAbsoluteUrlRemover, YumQueryComponent yumQueryComponent) {
        this.repomdProcessor = (RepomdProcessor)((Object)Preconditions.checkNotNull((Object)((Object)repomdProcessor)));
        this.tempBlobConverter = (TempBlobDocumentConverter)Preconditions.checkNotNull((Object)tempBlobConverter);
        this.yumAbsoluteUrlRemover = (YumAbsoluteUrlRemover)((Object)Preconditions.checkNotNull((Object)((Object)yumAbsoluteUrlRemover)));
        this.yumQueryComponent = (YumQueryComponent)((Object)Preconditions.checkNotNull((Object)((Object)yumQueryComponent)));
    }

    protected void doInit(Configuration configuration) throws Exception {
        super.doInit(configuration);
        this.yumFacet = (YumFacet)this.facet(YumFacet.class);
    }

    protected void doValidate(Configuration configuration) throws Exception {
        super.doValidate(configuration);
    }

    @Nullable
    protected Content getCachedContent(Context context) throws IOException {
        return this.yumFacet.getAssetAsContent(YumPathUtils.buildAssetPath(YumPathUtils.matcherState(context)));
    }

    protected Content store(Context context, Content content) throws IOException {
        AssetKind assetKind = (AssetKind)((Object)context.getAttributes().require(AssetKind.class));
        TokenMatcher.State matcherState = (TokenMatcher.State)context.getAttributes().require(TokenMatcher.State.class);
        String assetPath = YumPathUtils.buildAssetPath(matcherState);
        if (assetKind == AssetKind.RPM) {
            return this.putRPM(assetPath, content);
        }
        return this.putMetadata(assetPath, content, assetKind, context);
    }

    private Content putMetadata(String assetPath, Content content, AssetKind assetKind, Context context) throws IOException {
        this.clearRepodataIfRepomdAssetKind(assetKind, assetPath);
        StorageFacet storageFacet = (StorageFacet)this.facet(StorageFacet.class);
        Throwable throwable = null;
        Object var7_8 = null;
        try (TempBlob tempBlob = storageFacet.createTempBlob(content.openInputStream(), YumFacetUtils.HASH_ALGORITHMS);){
            return this.processAndSaveMetadata(assetPath, tempBlob, (Payload)content, assetKind, context);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private Content putRPM(String assetPath, Content content) throws IOException {
        StorageFacet storageFacet = (StorageFacet)this.facet(StorageFacet.class);
        Throwable throwable = null;
        Object var5_6 = null;
        try (TempBlob tempBlob = storageFacet.createTempBlob(content.openInputStream(), YumFacetUtils.HASH_ALGORITHMS);){
            return this.yumFacet.storeRpm(assetPath, (Supplier<InputStream>)tempBlob, (Payload)content);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private Content processAndSaveMetadata(String assetPath, TempBlob metadataContent, Payload payload, AssetKind assetKind, Context context) throws IOException {
        if (assetKind.equals((Object)AssetKind.REPOMD)) {
            return this.processRepomd(assetPath, metadataContent, payload, assetKind, context);
        }
        if (YumFacetUtils.isPrimary(assetPath, assetKind)) {
            return this.processPrimary(assetPath, metadataContent, payload, assetKind);
        }
        return this.yumFacet.storeMetadata(assetPath, metadataContent, payload, assetKind);
    }

    private Content processRepomd(String assetPath, TempBlob metadataContent, Payload payload, AssetKind assetKind, Context context) {
        try {
            Document repomdXml = this.tempBlobConverter.toDocument(metadataContent);
            this.repomdProcessor.process(repomdXml, path -> this.fetchMetadata(path, this.getRepository(), context));
            Throwable throwable = null;
            Object var8_10 = null;
            try (TempBlob newMetadataContent = this.tempBlobConverter.toTempBlob(this.getRepository(), repomdXml);){
                return this.yumFacet.storeMetadata(assetPath, newMetadataContent, payload, assetKind);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @VisibleForTesting
    protected Content processPrimary(String assetPath, TempBlob metadataContent, Payload payload, AssetKind assetKind) throws IOException {
        Throwable throwable = null;
        Object var6_7 = null;
        try {
            Content content;
            CompressedTempBlob tempBlob = this.yumAbsoluteUrlRemover.removeAbsoluteUrls(metadataContent, assetPath, this.getRepository());
            try {
                AttributesMap attributes = new AttributesMap();
                if (tempBlob.isModified()) {
                    attributes.set("modified", (Object)true);
                    attributes.set("open-sha1", (Object)tempBlob.getDecompressedHashes().get(HashAlgorithm.SHA1).toString());
                    attributes.set("open-sha256", (Object)tempBlob.getDecompressedHashes().get(HashAlgorithm.SHA256).toString());
                    attributes.set("open-sha512", (Object)tempBlob.getDecompressedHashes().get(HashAlgorithm.SHA512).toString());
                    attributes.set("open-md5", (Object)tempBlob.getDecompressedHashes().get(HashAlgorithm.MD5).toString());
                    attributes.set("open-size", (Object)tempBlob.getDecompressedSize());
                    content = this.yumFacet.storeMetadata(assetPath, tempBlob.getTempBlob(), payload, assetKind, attributes);
                    return content;
                }
                return this.yumFacet.storeMetadata(assetPath, metadataContent, payload, assetKind, attributes);
            }
            catch (Throwable throwable2) {
                throw throwable2;
            }
            finally {
                if (tempBlob == null) return content;
                tempBlob.close();
            }
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            }
            if (throwable == throwable3) throw throwable;
            throwable.addSuppressed(throwable3);
            throw throwable;
        }
    }

    @Nullable
    private Content fetchMetadata(String path, Repository repository, Context context) {
        Request mappingRequest = new Request.Builder().action("GET").path("/" + path).build();
        try {
            Response response = ((ViewFacet)repository.facet(ViewFacet.class)).dispatch(mappingRequest, context);
            int status = response.getStatus().getCode();
            if (status != 200) {
                this.log.warn("Failed to fetch metadata file for path {} and repository {}. Received status code {}", new Object[]{path, repository.getName(), status});
            }
            return (Content)response.getPayload();
        }
        catch (Exception e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    @TransactionalDeleteBlob
    protected void clearRepodataIfRepomdAssetKind(AssetKind assetKind, String assetPath) {
        if (assetKind == AssetKind.REPOMD) {
            StorageTx tx = (StorageTx)UnitOfWork.currentTx();
            Iterable<Asset> metadataAssets = this.yumQueryComponent.findRepodataAssets(tx, this.getRepository());
            for (Asset metadataAsset : metadataAssets) {
                if (!this.isAssetInSameFolderAsRepomd(assetPath, metadataAsset.name())) continue;
                tx.deleteAsset(metadataAsset);
            }
        }
    }

    private boolean isAssetInSameFolderAsRepomd(String repomdPath, String assetName) {
        String prefix = repomdPath.substring(0, repomdPath.indexOf(REPODATA_PATH) + REPODATA_PATH.length());
        String metadataName = assetName;
        return metadataName.startsWith(prefix);
    }

    protected void indicateVerified(Context context, Content content, CacheInfo cacheInfo) throws IOException {
        this.setCacheInfo(content, cacheInfo);
    }

    @TransactionalTouchMetadata
    public void setCacheInfo(Content content, CacheInfo cacheInfo) throws IOException {
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        Asset asset = Content.findAsset((StorageTx)tx, (Bucket)tx.findBucket(this.getRepository()), (Content)content);
        if (asset == null) {
            this.log.debug("Attempting to set cache info for non-existent Yum asset {}", content.getAttributes().require(Asset.class));
            return;
        }
        this.log.debug("Updating cacheInfo of {} to {}", (Object)asset, (Object)cacheInfo);
        CacheInfo.applyToAsset((Asset)asset, (CacheInfo)cacheInfo);
        tx.saveAsset(asset);
    }

    protected CacheController getCacheController(Context context) {
        AssetKind assetKind = (AssetKind)((Object)context.getAttributes().require(AssetKind.class));
        return (CacheController)Preconditions.checkNotNull((Object)this.cacheControllerHolder.get(assetKind.getCacheType()));
    }

    protected String getUrl(Context context) {
        return context.getRequest().getPath().substring(1);
    }
}

