/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.yum.internal.rpm;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.io.BaseEncoding;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.ReadableByteChannel;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang.StringUtils;
import org.joda.time.DateTime;
import org.redline_rpm.ChannelWrapper;
import org.redline_rpm.ReadableChannelWrapper;
import org.redline_rpm.header.AbstractHeader;
import org.redline_rpm.header.Format;
import org.redline_rpm.header.Header;
import org.redline_rpm.header.Signature;
import org.redline_rpm.payload.Directive;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.repository.yum.internal.rpm.RedlineHeader;
import org.sonatype.nexus.repository.yum.internal.rpm.YumRpm;
import org.sonatype.nexus.repository.yum.internal.rpm.YumRpmChangeLog;
import org.sonatype.nexus.repository.yum.internal.rpm.YumRpmEntry;
import org.sonatype.nexus.repository.yum.internal.rpm.YumRpmFile;

@Named
@Singleton
public class YumRpmParser
extends ComponentSupport {
    private static final int LESS_THAN_OR_EQUAL = 10;
    private static final int GREATER_THAN_OR_EQUAL = 12;

    public YumRpm parse(InputStream rpm, String location) {
        return this.parse(rpm, location, DateTime.now().getMillis());
    }

    /*
     * Exception decompiling
     */
    @VisibleForTesting
    public YumRpm parse(InputStream rpm, String location, long lastModified) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [6[TRYBLOCK]], but top level block is 7[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private YumRpm convertRedlineHeaderToYumPackage(String location, long lastModified, Format format) {
        RedlineHeader header = new RedlineHeader((AbstractHeader)format.getHeader());
        RedlineHeader signature = new RedlineHeader((AbstractHeader)format.getSignature());
        YumRpm yumRpm = new YumRpm();
        return yumRpm.setLocation(location).setChecksumType("sha256").setName(header.asString((AbstractHeader.Tag)Header.HeaderTag.NAME)).setArch(header.asString((AbstractHeader.Tag)Header.HeaderTag.ARCH)).setVersion(header.asString((AbstractHeader.Tag)Header.HeaderTag.VERSION)).setEpoch(header.asString((AbstractHeader.Tag)Header.HeaderTag.EPOCH)).setRelease(header.asString((AbstractHeader.Tag)Header.HeaderTag.RELEASE)).setSummary(header.asString((AbstractHeader.Tag)Header.HeaderTag.SUMMARY)).setDescription(header.asString((AbstractHeader.Tag)Header.HeaderTag.DESCRIPTION)).setUrl(header.asString((AbstractHeader.Tag)Header.HeaderTag.URL)).setTimeFile(lastModified).setTimeBuild(header.asInt((AbstractHeader.Tag)Header.HeaderTag.BUILDTIME)).setLicense(header.asString((AbstractHeader.Tag)Header.HeaderTag.LICENSE)).setVendor(header.asString((AbstractHeader.Tag)Header.HeaderTag.VENDOR)).setGroup(header.asString((AbstractHeader.Tag)Header.HeaderTag.GROUP)).setBuildHost(header.asString((AbstractHeader.Tag)Header.HeaderTag.BUILDHOST)).setSourceRpm(header.asString((AbstractHeader.Tag)Header.HeaderTag.SOURCERPM)).setHeaderStart(format.getSignature().getEndPos() + format.getHeader().getStartPos()).setHeaderEnd(format.getHeader().getEndPos()).setPackager(header.asString((AbstractHeader.Tag)Header.HeaderTag.PACKAGER)).setSizeInstalled(header.asInt((AbstractHeader.Tag)Header.HeaderTag.SIZE)).setSizeArchive(signature.asInt((AbstractHeader.Tag)Signature.SignatureTag.PAYLOADSIZE)).setProvides(this.extractPackageEntries(header, Header.HeaderTag.PROVIDENAME, Header.HeaderTag.PROVIDEVERSION, Header.HeaderTag.PROVIDEFLAGS)).setRequires(this.extractPackageEntries(header, Header.HeaderTag.REQUIRENAME, Header.HeaderTag.REQUIREVERSION, Header.HeaderTag.REQUIREFLAGS)).setConflicts(this.extractPackageEntries(header, Header.HeaderTag.CONFLICTNAME, Header.HeaderTag.CONFLICTVERSION, Header.HeaderTag.CONFLICTFLAGS)).setObsoletes(this.extractPackageEntries(header, Header.HeaderTag.OBSOLETENAME, Header.HeaderTag.OBSOLETEVERSION, Header.HeaderTag.OBSOLETEFLAGS)).setFiles(this.extractFiles(header)).setChanges(this.extractChangeLogs(header));
    }

    private void fixRequires(YumRpm yumRpm) {
        Map<String, YumRpmEntry> provides = yumRpm.getProvides().stream().collect(Collectors.toMap(it -> it.getName(), it -> it, (it1, it2) -> it1));
        List fileNames = yumRpm.getFiles().stream().map(it -> it.getName()).collect(Collectors.toList());
        List<YumRpmEntry> requiresToKeep = yumRpm.getRequires().stream().filter(require -> this.shouldKeepRequire((YumRpmEntry)require, provides, fileNames)).collect(Collectors.toList());
        yumRpm.setRequires(requiresToKeep);
    }

    private void updateChecksumAndId(YumRpm yumRpm, byte[] digest) {
        String checksum = BaseEncoding.base16().lowerCase().encode(digest);
        yumRpm.setChecksum(checksum).setPkgId(checksum);
    }

    private boolean shouldKeepRequire(YumRpmEntry item, Map<String, YumRpmEntry> provides, List<String> fileNames) {
        if (item.getName().startsWith("rpmlib(")) {
            return false;
        }
        if (this.requiresFileIncludedInRpm(item, fileNames)) {
            return false;
        }
        return !this.isRequireTheRpmProvides(item, provides);
    }

    private boolean requiresFileIncludedInRpm(YumRpmEntry item, List<String> fileNames) {
        return item.getName().startsWith("/") && fileNames.contains(item.getName()) && StringUtils.isBlank((String)item.getFlags());
    }

    private boolean isRequireTheRpmProvides(YumRpmEntry item, Map<String, YumRpmEntry> provides) {
        if (provides.containsKey(item.getName())) {
            if (item.getFlags() != null && !item.getFlags().isEmpty()) {
                return true;
            }
            YumRpmEntry provide = provides.get(item.getName());
            if (Objects.equals(item.getEpoch(), provide.getEpoch()) && Objects.equals(item.getVersion(), provide.getVersion()) && Objects.equals(item.getRelease(), provide.getRelease())) {
                return true;
            }
        }
        return false;
    }

    private List<YumRpmChangeLog> extractChangeLogs(RedlineHeader header) {
        List<String> names = header.getStringList((AbstractHeader.Tag)Header.HeaderTag.CHANGELOGNAME);
        List<Integer> dates = header.getIntegerList((AbstractHeader.Tag)Header.HeaderTag.CHANGELOGTIME);
        List<String> texts = header.getStringList((AbstractHeader.Tag)Header.HeaderTag.CHANGELOGTEXT);
        return IntStream.range(0, names.size()).mapToObj(i -> this.toChangeLog((String)names.get(i), (Integer)dates.get(i), (String)texts.get(i))).sorted(Comparator.comparing(YumRpmChangeLog::getDate)).collect(Collectors.toList());
    }

    private YumRpmChangeLog toChangeLog(String name, Integer date, String text) {
        return new YumRpmChangeLog().setAuthor(name).setDate(date).setText(text);
    }

    private List<YumRpmFile> extractFiles(RedlineHeader header) {
        List<String> names = header.getStringList((AbstractHeader.Tag)Header.HeaderTag.BASENAMES);
        List<String> directoryNames = header.getStringList((AbstractHeader.Tag)Header.HeaderTag.DIRNAMES);
        List<Integer> directoryIndexes = header.getIntegerList((AbstractHeader.Tag)Header.HeaderTag.DIRINDEXES);
        List<Integer> fileFlags = header.getIntegerList((AbstractHeader.Tag)Header.HeaderTag.FILEFLAGS);
        List<Short> fileModes = header.getShortList((AbstractHeader.Tag)Header.HeaderTag.FILEMODES);
        return IntStream.range(0, names.size()).mapToObj(i -> this.toPackageFile((String)names.get(i), (String)directoryNames.get((Integer)directoryIndexes.get(i)), this.fileType((Integer)fileFlags.get(i), (Short)fileModes.get(i)))).sorted(Comparator.comparing(YumRpmFile::getName)).collect(Collectors.toList());
    }

    private YumRpmFile toPackageFile(String name, String directoryName, YumRpm.FileType type) {
        String path = String.valueOf(directoryName) + name;
        return new YumRpmFile().setName(path).setType(type.name().toLowerCase()).setPrimary(this.isPrimary(type, path));
    }

    private boolean isPrimary(YumRpm.FileType type, String path) {
        return type != YumRpm.FileType.GHOST && (path.contains("bin/") || path.startsWith("/etc/") || type == YumRpm.FileType.FILE && Objects.equals(path, "/usr/lib/sendmail"));
    }

    private YumRpm.FileType fileType(Integer flag, Short mode) {
        int unsignedMode = mode + 65536;
        if ((unsignedMode & 0x4000) == 16384) {
            return YumRpm.FileType.DIR;
        }
        if ((flag & Directive.GHOST.flag()) == Directive.GHOST.flag()) {
            return YumRpm.FileType.GHOST;
        }
        return YumRpm.FileType.FILE;
    }

    private List<YumRpmEntry> extractPackageEntries(RedlineHeader header, Header.HeaderTag namesTag, Header.HeaderTag versionTag, Header.HeaderTag flagsTag) {
        List<String> names = header.getStringList((AbstractHeader.Tag)namesTag);
        List<String> versions = header.getStringList((AbstractHeader.Tag)versionTag);
        List<Integer> flags = header.getIntegerList((AbstractHeader.Tag)flagsTag);
        return IntStream.range(0, names.size()).mapToObj(i -> this.toPackageEntry((String)names.get(i), this.parseVersion((String)versions.get(i)), (Integer)flags.get(i))).sorted(new NamePreComparator()).collect(Collectors.toList());
    }

    private YumRpmEntry toPackageEntry(String name, Version version, int flag) {
        return new YumRpmEntry().setName(name).setEpoch(version.epoch).setVersion(version.version).setRelease(version.release).setFlags(this.convertFlag(flag)).setPre(this.isPre(flag));
    }

    private boolean isPre(int flag) {
        if ((flag & 0x40) == 64) {
            return true;
        }
        if ((flag & 0x200) == 512) {
            return true;
        }
        return (flag & 0x400) == 1024;
    }

    private Version parseVersion(String fullVersion) {
        String epoch = null;
        String release = null;
        String version = null;
        if (fullVersion != null) {
            int j;
            int i = fullVersion.indexOf(58);
            if (i != -1) {
                try {
                    epoch = String.valueOf(fullVersion.substring(0, i));
                }
                catch (NumberFormatException numberFormatException) {
                    epoch = "0";
                }
            }
            if ((j = fullVersion.indexOf(45)) > i) {
                release = fullVersion.substring(j + 1);
                version = fullVersion.substring(Math.max(i + 1, 0), j);
            } else {
                version = fullVersion.substring(Math.max(i + 1, 0));
            }
        }
        if (StringUtils.isBlank(version)) {
            version = null;
        }
        return new Version(epoch, release, version);
    }

    @Nullable
    private String convertFlag(int flag) {
        switch (flag & 0xF) {
            case 2: {
                return "LT";
            }
            case 4: {
                return "GT";
            }
            case 8: {
                return "EQ";
            }
            case 10: {
                return "LE";
            }
            case 12: {
                return "GE";
            }
        }
        return null;
    }

    private Format readRpmAndUpdateHeaderPosition(ReadableChannelWrapper content) throws IOException {
        Format format = new Format();
        ChannelWrapper.Key headerStartKey = content.start();
        ChannelWrapper.Key leadStartKey = content.start();
        format.getLead().read((ReadableByteChannel)content);
        content.finish(leadStartKey);
        ChannelWrapper.Key signatureStartKey = content.start();
        format.getSignature().read((ReadableByteChannel)content);
        content.finish(signatureStartKey);
        Integer headerStartPos = (Integer)content.finish(headerStartKey);
        ChannelWrapper.Key headerKey = content.start();
        format.getHeader().read((ReadableByteChannel)content);
        Integer headerLength = (Integer)content.finish(headerKey);
        format.getHeader().setStartPos(headerStartPos.intValue());
        format.getHeader().setEndPos(headerStartPos + headerLength);
        return format;
    }

    private static class NamePreComparator
    implements Comparator<YumRpmEntry> {
        private NamePreComparator() {
        }

        @Override
        public int compare(YumRpmEntry o1, YumRpmEntry o2) {
            String name2;
            String name1 = o1.getName();
            if (name1.equals(name2 = o2.getName())) {
                if (o1.isPre() && !o2.isPre()) {
                    return 1;
                }
                if (o2.isPre()) {
                    return -1;
                }
            }
            return name1.compareTo(name2);
        }
    }

    private static class Version {
        String epoch;
        String release;
        String version;

        Version(String epoch, String release, String version) {
            this.epoch = epoch;
            this.release = release;
            this.version = version;
        }
    }
}

