/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.yum.internal.utils;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sonatype.nexus.blobstore.api.Blob;
import org.sonatype.nexus.common.collect.AttributesMap;
import org.sonatype.nexus.common.hash.HashAlgorithm;
import org.sonatype.nexus.repository.storage.Asset;
import org.sonatype.nexus.repository.view.Content;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.payloads.BlobPayload;
import org.sonatype.nexus.repository.yum.AssetKind;

public class YumFacetUtils {
    public static final List<HashAlgorithm> HASH_ALGORITHMS = ImmutableList.of((Object)HashAlgorithm.SHA256, (Object)HashAlgorithm.SHA1, (Object)HashAlgorithm.SHA512, (Object)HashAlgorithm.MD5);

    private YumFacetUtils() {
    }

    public static Content toContent(Asset asset, Blob blob) {
        Content content = new Content((Payload)new BlobPayload(blob, asset.requireContentType()));
        Content.extractFromAsset((Asset)asset, HASH_ALGORITHMS, (AttributesMap)content.getAttributes());
        return content;
    }

    public static HashAlgorithm hashAlgorithmByName(String name) {
        if ("sha".equals(name)) {
            return HashAlgorithm.SHA1;
        }
        for (HashAlgorithm hashAlgorithm : HASH_ALGORITHMS) {
            if (!hashAlgorithm.name().equals(name)) continue;
            return hashAlgorithm;
        }
        throw new IllegalArgumentException("Unsupported hash " + name);
    }

    public static boolean isPrimary(String assetPath, AssetKind assetKind) {
        return assetKind.equals((Object)AssetKind.REPODATA) && assetPath.substring(assetPath.indexOf(47) + 1).toLowerCase().contains("primary");
    }
}

