/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.yum.internal.utils;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorInputStream;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorOutputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorOutputStream;
import org.apache.commons.compress.compressors.xz.XZCompressorInputStream;
import org.apache.commons.compress.compressors.xz.XZCompressorOutputStream;
import org.sonatype.nexus.repository.yum.internal.createrepo.YumMetadataFile;
import org.sonatype.nexus.repository.yum.internal.metadata.YumMetadata;

public class YumMetadataUtils {
    private static final String GZ = ".gz";
    private static final String XZ = ".xz";
    private static final String BZIP = ".bz2";

    private YumMetadataUtils() {
    }

    public static YumMetadata readCompressedMetadata(YumMetadataFile metadataFile) throws IOException {
        return YumMetadataUtils.readCompressedMetadata(metadataFile, Files.newInputStream(metadataFile.getPath(), new OpenOption[0]));
    }

    /*
     * Exception decompiling
     */
    public static YumMetadata readCompressedMetadata(YumMetadataFile metadataFile, InputStream metadata) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[TRYBLOCK]], but top level block is 4[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static String getFileName(YumMetadataFile metadataFile) {
        if (metadataFile != null && metadataFile.getPath() != null && metadataFile.getPath().getFileName() != null) {
            return metadataFile.getPath().getFileName().toString();
        }
        throw new RuntimeException("Unable to retrieve filename");
    }

    public static OutputStream xmlOutputStream(String fileName, Path tempFile) throws IOException {
        OutputStream result = Files.newOutputStream(tempFile, new OpenOption[0]);
        try {
            if (YumMetadataUtils.isCompressedWithFormat(fileName, GZ)) {
                result = new GzipCompressorOutputStream(result);
            } else if (YumMetadataUtils.isCompressedWithFormat(fileName, XZ)) {
                result = new XZCompressorOutputStream(result);
            } else if (YumMetadataUtils.isCompressedWithFormat(fileName, BZIP)) {
                result = new BZip2CompressorOutputStream(result);
            }
        }
        catch (IOException ex) {
            result.close();
            throw ex;
        }
        return new BufferedOutputStream(result);
    }

    public static InputStream xmlInputStream(String fileName, InputStream primaryInputStream) throws IOException {
        InputStream result = primaryInputStream;
        if (YumMetadataUtils.isCompressedWithFormat(fileName, GZ)) {
            result = new GzipCompressorInputStream(primaryInputStream);
        } else if (YumMetadataUtils.isCompressedWithFormat(fileName, XZ)) {
            result = new XZCompressorInputStream(primaryInputStream);
        } else if (YumMetadataUtils.isCompressedWithFormat(fileName, BZIP)) {
            result = new BZip2CompressorInputStream(primaryInputStream);
        }
        return new BufferedInputStream(result);
    }

    private static boolean isCompressedWithFormat(String fileName, String format) {
        return fileName.endsWith(format);
    }
}

