/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.yum.internal.xmltools;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.Iterator;
import javax.annotation.Nullable;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.sonatype.nexus.repository.yum.internal.xmltools.XmlValueExtractor;

public class AttributeXmlValueExtractor
implements XmlValueExtractor {
    private final String element;
    private final String attribute;

    public AttributeXmlValueExtractor(String element, String attribute) {
        this.element = (String)Preconditions.checkNotNull((Object)element);
        this.attribute = (String)Preconditions.checkNotNull((Object)attribute);
    }

    @Override
    @Nullable
    public String extract(Collection<XMLEvent> block) {
        for (XMLEvent event : block) {
            StartElement startElement;
            if (!event.isStartElement() || !(startElement = event.asStartElement()).getName().getLocalPart().equals(this.element)) continue;
            Iterator<Attribute> attributes = startElement.getAttributes();
            while (attributes.hasNext()) {
                Attribute xmlAttribute = attributes.next();
                if (!xmlAttribute.getName().getLocalPart().equals(this.attribute)) continue;
                return xmlAttribute.getValue();
            }
        }
        return null;
    }
}

