/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.yum.upgrade;

import com.google.common.base.Preconditions;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.query.OQuery;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.query.OSQLSynchQuery;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.apache.commons.lang.StringUtils;
import org.sonatype.nexus.common.upgrade.DependsOn;
import org.sonatype.nexus.common.upgrade.Upgrades;
import org.sonatype.nexus.orient.DatabaseInstance;
import org.sonatype.nexus.orient.DatabaseUpgradeSupport;
import org.sonatype.nexus.orient.OIndexNameBuilder;

@Named
@Singleton
@Upgrades(model="component", from="1.9", to="1.10")
@DependsOn(model="config", version="1.5")
public class ComponentDatabaseUpgrade_1_10
extends DatabaseUpgradeSupport {
    private static final int BATCH_SIZE = 500;
    private static final String SELECT_YUM_PROXY_REPOSITORIES = "select from repository where recipe_name = 'yum-proxy'";
    private static final String SELECT_COMPONENT_BATCH_SQL = String.format("select from component where bucket = ? and @RID > ? order by @RID asc limit %d", 500);
    private static final String SELECT_COMPONENT_ASSETS_SQL = "select from asset where component = %s";
    private static final String FIND_COMPONENT = "select from component where name = ? and version = ? and bucket = ? limit 1";
    private static final String I_REPOSITORY_NAME = new OIndexNameBuilder().type("bucket").property("repository_name").build();
    private final Provider<DatabaseInstance> configDatabaseInstance;
    private final Provider<DatabaseInstance> componentDatabaseInstance;

    @Inject
    public ComponentDatabaseUpgrade_1_10(@Named(value="config") Provider<DatabaseInstance> configDatabaseInstance, @Named(value="component") Provider<DatabaseInstance> componentDatabaseInstance) {
        this.configDatabaseInstance = (Provider)Preconditions.checkNotNull(configDatabaseInstance);
        this.componentDatabaseInstance = (Provider)Preconditions.checkNotNull(componentDatabaseInstance);
    }

    public void apply() {
        if (ComponentDatabaseUpgrade_1_10.hasSchemaClass(this.configDatabaseInstance, (String)"repository") && ComponentDatabaseUpgrade_1_10.hasSchemaClass(this.componentDatabaseInstance, (String)"bucket") && ComponentDatabaseUpgrade_1_10.hasSchemaClass(this.componentDatabaseInstance, (String)"component") && ComponentDatabaseUpgrade_1_10.hasSchemaClass(this.componentDatabaseInstance, (String)"asset")) {
            List repositories;
            Throwable throwable = null;
            Iterator iterator = null;
            try (ODatabaseDocumentTx configDb = ((DatabaseInstance)this.configDatabaseInstance.get()).connect();){
                repositories = configDb.query((OQuery)new OSQLSynchQuery(SELECT_YUM_PROXY_REPOSITORIES), new Object[0]).stream().map(d -> (String)d.field("repository_name")).collect(Collectors.toList());
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            this.log.info("Updating name and version for yum-proxy components, this could be a long-running operation");
            for (String repository : repositories) {
                Throwable throwable3 = null;
                Object var5_8 = null;
                try (ODatabaseDocumentTx componentDb = ((DatabaseInstance)this.componentDatabaseInstance.get()).connect();){
                    this.log.debug("Repairing component coordinates yum repository {}", (Object)repository);
                    OIndex bucketIdx = componentDb.getMetadata().getIndexManager().getIndex(I_REPOSITORY_NAME);
                    OIdentifiable bucket = (OIdentifiable)bucketIdx.get((Object)repository);
                    if (bucket == null) {
                        this.log.warn("Unable to find bucket for {}", (Object)repository);
                        continue;
                    }
                    this.fixComponentBatch(componentDb, bucket);
                }
                catch (Throwable throwable4) {
                    if (throwable3 == null) {
                        throwable3 = throwable4;
                    } else if (throwable3 != throwable4) {
                        throwable3.addSuppressed(throwable4);
                    }
                    throw throwable3;
                }
            }
        }
    }

    private void fixComponentBatch(ODatabaseDocumentTx db, OIdentifiable bucket) {
        this.log.debug("Processing batch of {} yum component records...", (Object)500);
        OSQLSynchQuery query = new OSQLSynchQuery(SELECT_COMPONENT_BATCH_SQL);
        List components = db.query((OQuery)query, new Object[]{bucket, new ORecordId()});
        while (!components.isEmpty()) {
            ORID last = ((ODocument)components.get(components.size() - 1)).getIdentity();
            for (ODocument component : components) {
                this.fixComponent(db, component, bucket);
            }
            components = db.query((OQuery)query, new Object[]{bucket, last});
        }
    }

    private void fixComponent(ODatabaseDocumentTx db, ODocument component, OIdentifiable bucket) {
        String selectComponentAssetsSql = String.format(SELECT_COMPONENT_ASSETS_SQL, component.getIdentity());
        List componentsAssets = db.query((OQuery)new OSQLSynchQuery(selectComponentAssetsSql), new Object[0]);
        if (!componentsAssets.isEmpty()) {
            Map<String, String> formatAttributes = this.extractFormatAttributes(componentsAssets);
            if (formatAttributes != null && !formatAttributes.isEmpty()) {
                String fullVersion;
                String name = formatAttributes.get("name");
                String version = formatAttributes.get("version");
                String release = formatAttributes.get("release");
                String string = fullVersion = StringUtils.isNotBlank((String)release) ? String.valueOf(version) + "-" + release : version;
                if (component.field("name").equals(name) && component.field("version").equals(fullVersion)) {
                    return;
                }
                ODocument existingComponent = this.findComponent(db, name, fullVersion, bucket);
                if (existingComponent != null) {
                    this.moveAssetsToComponent(componentsAssets, existingComponent);
                    component.delete();
                } else {
                    component.field("name", (Object)name);
                    component.field("version", (Object)fullVersion);
                    component.save();
                }
            } else {
                this.log.warn("Unable to process Yum component because formatAttributes was null or empty. {}", (Object)component);
            }
        }
    }

    private Map<String, String> extractFormatAttributes(List<ODocument> componentsAssets) {
        ODocument firstAsset = componentsAssets.get(0);
        Map attributes = (Map)firstAsset.field("attributes", OType.EMBEDDEDMAP);
        return (Map)attributes.get("yum");
    }

    private void moveAssetsToComponent(List<ODocument> componentsAssets, ODocument existingComponent) {
        for (ODocument componentsAsset : componentsAssets) {
            componentsAsset.field("component", (Object)existingComponent.getIdentity());
            componentsAsset.save();
        }
    }

    private ODocument findComponent(ODatabaseDocumentTx db, String name, String version, OIdentifiable bucket) {
        List components = db.query((OQuery)new OSQLSynchQuery(FIND_COMPONENT), new Object[]{name, version, bucket});
        if (!components.isEmpty()) {
            return (ODocument)components.get(0);
        }
        return null;
    }
}

