/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.yum.utils;

import com.google.common.base.Preconditions;
import java.util.Optional;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.sonatype.nexus.repository.view.Context;
import org.sonatype.nexus.repository.view.matchers.token.TokenMatcher;
import org.sonatype.nexus.repository.yum.internal.createrepo.YumDirectory;

public final class YumPathUtils {
    public static final String REPODATA_FOLDER = "/repodata";
    public static final String ASC_REGEX = ".*[xX][mM][lL]\\.[aA][sS][cC]";
    public static final String REPODATA_FOR_CMA_REGEX = ".*repodata\\/.*";
    public static final String REPODATA_REGEX = ".*\\/repodata\\/.*";
    public static final String RPM_EXTENSION_REGEX = ".*[dD]?[rR][pP][mM]";
    public static final String XML_REGEX = ".*[xX][mM][lL]";
    public static final String XML_GZ_REGEX = ".*[xX][mM][lL]\\.?[gG]?[zZ]?";
    public static final Pattern REPODATA_MATCHER = Pattern.compile(".*repodata\\/.*");
    public static final Pattern REPODATA_PATTERN = Pattern.compile(".*\\/repodata\\/.*");
    public static final Pattern REPOMD_ASC_MATCHER = Pattern.compile(".*repodata\\/.*repomd.*[xX][mM][lL]\\.[aA][sS][cC]");
    public static final Pattern REPOMD_MATCHER = Pattern.compile(".*repodata\\/.*repomd.*[xX][mM][lL]");
    public static final Pattern COMPS_MATCHER = Pattern.compile(".*repodata\\/.*comps.*[xX][mM][lL]\\.?[gG]?[zZ]?");
    public static final Pattern RPM_MATCHER = Pattern.compile(".*[dD]?[rR][pP][mM]");

    public static TokenMatcher.State matcherState(Context context) {
        return (TokenMatcher.State)context.getAttributes().require(TokenMatcher.State.class);
    }

    public static String path(TokenMatcher.State state) {
        return YumPathUtils.match(state, "path").replaceAll("^/", "");
    }

    public static String name(TokenMatcher.State matcherState) {
        return YumPathUtils.match(matcherState, "name");
    }

    public static String extension(TokenMatcher.State state) {
        return YumPathUtils.match(state, "extension");
    }

    private static String match(TokenMatcher.State state, String name) {
        Preconditions.checkNotNull((Object)state);
        String result = (String)state.getTokens().get(name);
        Preconditions.checkNotNull((Object)result);
        return result;
    }

    public static String buildAssetPath(TokenMatcher.State matcherState) {
        String path = YumPathUtils.path(matcherState);
        String name = YumPathUtils.name(matcherState);
        String extension = YumPathUtils.extension(matcherState);
        String pathName = path.isEmpty() ? name : String.valueOf(path) + "/" + name;
        return String.valueOf(pathName) + "." + extension;
    }

    public static String buildMetadataFilePath(String checksum, String type) {
        return String.format("repodata/%s-%s.xml.gz", checksum, type);
    }

    public static String repodataPath(YumDirectory directory) {
        return YumPathUtils.repodataPath(directory == null ? null : directory.getName());
    }

    public static String repodataPath(String directory) {
        return org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)directory) ? String.valueOf(directory) + REPODATA_FOLDER : "repodata";
    }

    public static String extractDirectoryFromMetadataPath(String path) {
        if (!path.contains(REPODATA_FOLDER)) {
            return "";
        }
        return path.substring(0, path.indexOf(REPODATA_FOLDER));
    }

    public static Optional<String> extractDirectoryAtDepth(String name, Integer repodataDepth) {
        int index = StringUtils.ordinalIndexOf((String)name, (String)"/", (int)repodataDepth);
        if (index >= 0) {
            return Optional.of(name.substring(0, index));
        }
        return Optional.empty();
    }

    public static String appendPath(@Nullable String basePath, @Nullable String suffix) {
        if (basePath == null && suffix == null) {
            return "";
        }
        if (suffix == null) {
            return basePath;
        }
        if (basePath == null) {
            return suffix;
        }
        if (basePath.isEmpty() || basePath.endsWith("/")) {
            return String.valueOf(basePath) + suffix;
        }
        return String.valueOf(basePath) + "/" + suffix;
    }

    private YumPathUtils() {
    }
}

