/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.shell.impl.action.command;

import java.io.File;
import java.lang.reflect.Field;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.karaf.shell.api.action.Action;
import org.apache.karaf.shell.api.action.Argument;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Completion;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.console.CommandLine;
import org.apache.karaf.shell.api.console.Completer;
import org.apache.karaf.shell.api.console.Session;
import org.apache.karaf.shell.impl.action.command.ActionCommand;
import org.apache.karaf.shell.impl.action.command.HelpOption;
import org.apache.karaf.shell.support.completers.ArgumentCommandLine;
import org.apache.karaf.shell.support.completers.FileCompleter;
import org.apache.karaf.shell.support.completers.NullCompleter;
import org.apache.karaf.shell.support.completers.StringsCompleter;
import org.apache.karaf.shell.support.completers.UriCompleter;
import org.apache.karaf.shell.support.converter.GenericType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArgumentCompleter
implements Completer {
    private static final Logger LOGGER = LoggerFactory.getLogger(ArgumentCompleter.class);
    final ActionCommand command;
    final Completer commandCompleter;
    final Completer optionsCompleter;
    final List<Completer> argsCompleters;
    final Map<String, Completer> optionalCompleters;
    final Map<Option, Field> fields = new HashMap<Option, Field>();
    final Map<String, Option> options = new HashMap<String, Option>();
    final Map<Integer, Field> arguments = new HashMap<Integer, Field>();

    public ArgumentCompleter(ActionCommand command, boolean scoped) {
        Completion ann;
        String[] stringArray;
        this.command = command;
        Class<? extends Action> actionClass = command.getActionClass();
        Command cmd = actionClass.getAnnotation(Command.class);
        if (scoped || "*".equals(cmd.scope())) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = cmd.name();
        } else {
            String[] stringArray3 = new String[2];
            stringArray3[0] = cmd.name();
            stringArray = stringArray3;
            stringArray3[1] = cmd.scope() + ":" + cmd.name();
        }
        String[] names = stringArray;
        this.commandCompleter = new StringsCompleter(names);
        for (Class<? extends Action> type = actionClass; type != null; type = type.getSuperclass()) {
            for (Field field : type.getDeclaredFields()) {
                Argument argument;
                Option option = field.getAnnotation(Option.class);
                if (option != null) {
                    this.fields.put(option, field);
                    this.options.put(option.name(), option);
                    String[] aliases = option.aliases();
                    if (aliases != null) {
                        for (String alias : aliases) {
                            this.options.put(alias, option);
                        }
                    }
                }
                if ((argument = field.getAnnotation(Argument.class)) == null) continue;
                Integer key = argument.index();
                if (this.arguments.containsKey(key)) {
                    LOGGER.warn("Duplicate @Argument annotations on class " + type.getName() + " for index: " + key + " see: " + field);
                    continue;
                }
                this.arguments.put(key, field);
            }
        }
        this.options.put(HelpOption.HELP.name(), HelpOption.HELP);
        this.argsCompleters = new ArrayList<Completer>();
        this.optionsCompleter = new StringsCompleter(this.options.keySet());
        boolean multi = false;
        for (int key = 0; key < this.arguments.size(); ++key) {
            Object completer = null;
            Field field = this.arguments.get(key);
            if (field != null) {
                Argument argument = field.getAnnotation(Argument.class);
                multi = argument != null && argument.multiValued();
                ann = field.getAnnotation(Completion.class);
                if (ann != null) {
                    Class clazz = ann.value();
                    String[] value = ann.values();
                    if (clazz != null) {
                        completer = value.length > 0 && clazz == StringsCompleter.class ? new StringsCompleter(value, ann.caseSensitive()) : command.getCompleter(clazz);
                    }
                } else {
                    completer = this.getDefaultCompleter(field, multi);
                }
            }
            if (completer == null) {
                completer = NullCompleter.INSTANCE;
            }
            this.argsCompleters.add((Completer)completer);
        }
        if (this.argsCompleters.isEmpty() || !multi) {
            this.argsCompleters.add((Completer)NullCompleter.INSTANCE);
        }
        this.optionalCompleters = new HashMap<String, Completer>();
        for (Option option : this.fields.keySet()) {
            NullCompleter completer;
            block24: {
                Field field;
                completer = null;
                field = this.fields.get(option);
                if (field != null) {
                    ann = field.getAnnotation(Completion.class);
                    if (ann != null) {
                        try {
                            Class clazz = ann.value();
                            String[] value = ann.values();
                            if (clazz == null) break block24;
                            if (clazz == StringsCompleter.class) {
                                completer = new StringsCompleter(value, ann.caseSensitive());
                                break block24;
                            }
                            completer = command.getCompleter(clazz);
                        }
                        catch (Throwable throwable) {}
                    } else {
                        completer = this.getDefaultCompleter(field, option.multiValued());
                    }
                }
            }
            if (completer == null) {
                completer = NullCompleter.INSTANCE;
            }
            this.optionalCompleters.put(option.name(), (Completer)completer);
            if (option.aliases() == null) continue;
            for (String alias : option.aliases()) {
                this.optionalCompleters.put(alias, (Completer)completer);
            }
        }
    }

    private Completer getDefaultCompleter(Field field, boolean multi) {
        UriCompleter completer = null;
        Class type = field.getType();
        GenericType genericType = new GenericType(field.getGenericType());
        if (Collection.class.isAssignableFrom(genericType.getRawClass()) && multi) {
            type = genericType.getActualTypeArgument(0).getRawClass();
        }
        if (type.isAssignableFrom(URI.class)) {
            completer = new UriCompleter();
        } else if (type.isAssignableFrom(File.class)) {
            completer = new FileCompleter();
        } else if (type.isAssignableFrom(Boolean.class) || type.isAssignableFrom(Boolean.TYPE)) {
            completer = new StringsCompleter(new String[]{"false", "true"}, false);
        } else if (Enum.class.isAssignableFrom(type)) {
            HashSet<String> values = new HashSet<String>();
            for (Object o : EnumSet.allOf(type)) {
                values.add(o.toString());
            }
            completer = new StringsCompleter(values, false);
        }
        return completer;
    }

    public int complete(Session session, CommandLine list, List<String> candidates) {
        int pos;
        Option option;
        Field lastField;
        Option lastOption;
        int lastAgurmentIndex;
        int argIndex = list.getCursorArgumentIndex();
        Completer comp = null;
        String[] args = list.getArguments();
        int index = 0;
        if (index < argIndex) {
            if (!"*".equals(this.command.getScope()) && !session.resolveCommand(args[index]).equals(this.command.getScope() + ":" + this.command.getName())) {
                return -1;
            }
            if (!this.verifyCompleter(session, this.commandCompleter, args[index])) {
                return -1;
            }
            ++index;
        } else {
            comp = this.commandCompleter;
        }
        if (comp == null) {
            while (index < argIndex && args[index].startsWith("-")) {
                if (!this.verifyCompleter(session, this.optionsCompleter, args[index])) {
                    return -1;
                }
                Option option2 = this.options.get(args[index]);
                if (option2 == null) {
                    return -1;
                }
                Field field = this.fields.get(option2);
                if (field != null && field.getType() != Boolean.TYPE && field.getType() != Boolean.class && ++index == argIndex) {
                    comp = NullCompleter.INSTANCE;
                }
                ++index;
            }
            if (comp == null && index >= argIndex && index < args.length && args[index].startsWith("-")) {
                comp = this.optionsCompleter;
            }
        }
        if ((lastAgurmentIndex = argIndex - 1) >= 1 && (lastOption = this.options.get(args[lastAgurmentIndex])) != null && (lastField = this.fields.get(lastOption)) != null && lastField.getType() != Boolean.TYPE && lastField.getType() != Boolean.class && (option = lastField.getAnnotation(Option.class)) != null) {
            String[] aliases;
            Completer optionValueCompleter = null;
            String name = option.name();
            if (name != null && (optionValueCompleter = this.optionalCompleters.get(name)) == null && (aliases = option.aliases()).length > 0) {
                for (int i = 0; i < aliases.length && optionValueCompleter == null; ++i) {
                    optionValueCompleter = this.optionalCompleters.get(option.aliases()[i]);
                }
            }
            if (optionValueCompleter != null) {
                comp = optionValueCompleter;
            }
        }
        if (comp == null) {
            int indexArg = 0;
            while (index < argIndex) {
                Completer sub = this.argsCompleters.get(indexArg >= this.argsCompleters.size() ? this.argsCompleters.size() - 1 : indexArg);
                if (!this.verifyCompleter(session, sub, args[index])) {
                    return -1;
                }
                ++index;
                ++indexArg;
            }
            comp = this.argsCompleters.get(indexArg >= this.argsCompleters.size() ? this.argsCompleters.size() - 1 : indexArg);
        }
        if ((pos = comp.complete(session, list, candidates)) == -1) {
            return -1;
        }
        String buffer = list.getBuffer();
        int cursor = list.getBufferPosition();
        if (buffer != null && cursor != buffer.length() && this.isDelimiter(buffer, cursor)) {
            for (int i = 0; i < candidates.size(); ++i) {
                String val = candidates.get(i);
                while (val.length() > 0 && this.isDelimiter(val, val.length() - 1)) {
                    val = val.substring(0, val.length() - 1);
                }
                candidates.set(i, val);
            }
        }
        return pos;
    }

    protected boolean verifyCompleter(Session session, Completer completer, String argument) {
        ArrayList candidates = new ArrayList();
        return completer.complete(session, (CommandLine)new ArgumentCommandLine(argument, argument.length()), candidates) != -1 && !candidates.isEmpty();
    }

    public boolean isDelimiter(String buffer, int pos) {
        return !this.isEscaped(buffer, pos) && this.isDelimiterChar(buffer, pos);
    }

    public boolean isEscaped(String buffer, int pos) {
        return pos > 0 && buffer.charAt(pos) == '\\' && !this.isEscaped(buffer, pos - 1);
    }

    public boolean isDelimiterChar(String buffer, int pos) {
        return Character.isWhitespace(buffer.charAt(pos));
    }
}

