/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.shell.impl.action.command;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.karaf.shell.api.action.Action;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.lifecycle.Destroy;
import org.apache.karaf.shell.api.action.lifecycle.Init;
import org.apache.karaf.shell.api.action.lifecycle.Manager;
import org.apache.karaf.shell.api.action.lifecycle.Reference;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.apache.karaf.shell.api.console.Completer;
import org.apache.karaf.shell.api.console.Parser;
import org.apache.karaf.shell.api.console.Registry;
import org.apache.karaf.shell.impl.action.command.ActionCommand;
import org.apache.karaf.shell.support.converter.GenericType;

public class ManagerImpl
implements Manager {
    private final Registry dependencies;
    private final Registry registrations;
    private final Map<Class<?>, Object> instances = new HashMap();
    private final boolean allowCustomServices;

    public ManagerImpl(Registry dependencies, Registry registrations) {
        this(dependencies, registrations, false);
    }

    public ManagerImpl(Registry dependencies, Registry registrations, boolean allowCustomServices) {
        this.dependencies = dependencies;
        this.registrations = registrations;
        this.allowCustomServices = allowCustomServices;
    }

    public <T> T instantiate(Class<? extends T> clazz) throws Exception {
        return this.instantiate(clazz, this.dependencies);
    }

    public <T> T instantiate(Class<? extends T> clazz, Registry registry) throws Exception {
        Service reg;
        if (!this.allowCustomServices && (reg = clazz.getAnnotation(Service.class)) == null) {
            throw new IllegalArgumentException("Class " + clazz.getName() + " is not annotated with @Service");
        }
        T instance = clazz.newInstance();
        for (Class<T> cl = clazz; cl != Object.class; cl = cl.getSuperclass()) {
            Field[] fieldArray = cl.getDeclaredFields();
            int n = fieldArray.length;
            for (int i = 0; i < n; ++i) {
                ArrayList value;
                Field field = fieldArray[i];
                Reference ref = field.getAnnotation(Reference.class);
                if (ref == null) continue;
                GenericType type = new GenericType(field.getGenericType());
                if (type.getRawClass() == List.class) {
                    HashSet set = new HashSet();
                    set.addAll(registry.getServices(type.getActualTypeArgument(0).getRawClass()));
                    if (registry != this.dependencies) {
                        set.addAll(this.dependencies.getServices(type.getActualTypeArgument(0).getRawClass()));
                    }
                    value = new ArrayList(set);
                } else {
                    value = registry.getService(type.getRawClass());
                    if (value == null && registry != this.dependencies) {
                        value = this.dependencies.getService(type.getRawClass());
                    }
                }
                if (!this.allowCustomServices && value == null && !ref.optional()) {
                    throw new IllegalStateException("No service matching " + field.getType().getName());
                }
                field.setAccessible(true);
                field.set(instance, value);
            }
        }
        for (Method method : clazz.getDeclaredMethods()) {
            Init ann = method.getAnnotation(Init.class);
            if (ann == null || method.getParameterTypes().length != 0 || method.getReturnType() != Void.TYPE) continue;
            method.setAccessible(true);
            method.invoke(instance, new Object[0]);
        }
        return instance;
    }

    public void release(Object instance) throws Exception {
        Service reg;
        Class<?> clazz = instance.getClass();
        if (!this.allowCustomServices && (reg = clazz.getAnnotation(Service.class)) == null) {
            throw new IllegalArgumentException("Class " + clazz.getName() + " is not annotated with @Service");
        }
        for (Method method : clazz.getDeclaredMethods()) {
            Destroy ann = method.getAnnotation(Destroy.class);
            if (ann == null || method.getParameterTypes().length != 0 || method.getReturnType() != Void.TYPE) continue;
            method.setAccessible(true);
            method.invoke(instance, new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(Class<?> clazz) {
        Service reg;
        if (!this.allowCustomServices && (reg = clazz.getAnnotation(Service.class)) == null) {
            throw new IllegalArgumentException("Class " + clazz.getName() + " is not annotated with @Service");
        }
        if (Action.class.isAssignableFrom(clazz)) {
            Command cmd = clazz.getAnnotation(Command.class);
            if (cmd == null) {
                throw new IllegalArgumentException("Command " + clazz.getName() + " is not annotated with @Command");
            }
            ActionCommand command = new ActionCommand(this, clazz);
            Map<Class<?>, Object> map = this.instances;
            synchronized (map) {
                this.instances.put(clazz, command);
            }
            this.registrations.register((Object)command);
        }
        if (this.allowCustomServices || Completer.class.isAssignableFrom(clazz) || Parser.class.isAssignableFrom(clazz)) {
            try {
                Object completer = this.instantiate(clazz);
                Map<Class<?>, Object> map = this.instances;
                synchronized (map) {
                    this.instances.put(clazz, completer);
                }
                this.registrations.register(completer);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregister(Class<?> clazz) {
        Object object;
        Map<Class<?>, Object> map = this.instances;
        synchronized (map) {
            object = this.instances.remove(clazz);
        }
        if (object != null) {
            this.registrations.unregister(object);
            if (object instanceof Completer) {
                try {
                    this.release(object);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }
}

