/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.webresources;

import com.google.common.base.Preconditions;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.sonatype.nexus.webresources.WebResource;

public class FileWebResource
implements WebResource {
    private final String path;
    private final String contentType;
    private final File file;
    private final boolean cachable;

    public FileWebResource(File file, String path, String contentType, boolean cachable) {
        this.file = (File)Preconditions.checkNotNull((Object)file);
        this.path = (String)Preconditions.checkNotNull((Object)path);
        this.contentType = (String)Preconditions.checkNotNull((Object)contentType);
        this.cachable = cachable;
    }

    @Override
    public boolean isCacheable() {
        return this.cachable;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public String getContentType() {
        return this.contentType;
    }

    @Override
    public long getSize() {
        return this.file.length();
    }

    @Override
    public long getLastModified() {
        return this.file.lastModified();
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return new BufferedInputStream(new FileInputStream(this.file));
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + "{" + "path='" + this.path + '\'' + ", contentType='" + this.contentType + '\'' + ", file=" + this.file + ", cachable=" + this.cachable + '}';
    }
}

