/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.webresources;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import org.sonatype.nexus.webresources.WebResource;

public class UrlWebResource
implements WebResource {
    private final URL url;
    private final String path;
    private final boolean cacheable;
    private final String contentType;
    private final long size;
    private final long lastModified;

    public UrlWebResource(URL url, String path, String contentType) {
        this(url, path, contentType, true);
    }

    public UrlWebResource(URL url, String path, String contentType, boolean cacheable) {
        this.url = (URL)Preconditions.checkNotNull((Object)url);
        this.path = (String)Preconditions.checkNotNull((Object)path);
        this.cacheable = cacheable;
        try {
            URLConnection connection = this.url.openConnection();
            Throwable throwable = null;
            Object var7_9 = null;
            try (InputStream ignore = connection.getInputStream();){
                this.contentType = Strings.isNullOrEmpty((String)contentType) ? connection.getContentType() : contentType;
                long detectedSize = connection.getContentLengthLong();
                if (detectedSize == -1L) {
                    detectedSize = connection.getContentLength();
                }
                this.size = detectedSize;
                this.lastModified = connection.getLastModified();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Resource inaccessible: " + url, e);
        }
    }

    @Override
    public String getPath() {
        if (this.path != null) {
            return this.path;
        }
        return this.url.getPath();
    }

    @Override
    public long getSize() {
        return this.size;
    }

    @Override
    public String getContentType() {
        return this.contentType;
    }

    @Override
    public long getLastModified() {
        return this.lastModified;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this.url.openStream();
    }

    @Override
    public boolean isCacheable() {
        return this.cacheable;
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + "{" + "url=" + this.url + ", path='" + this.path + '\'' + ", cacheable=" + this.cacheable + ", contentType='" + this.contentType + '\'' + ", size=" + this.size + ", lastModified=" + this.lastModified + '}';
    }
}

