/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.query;

import com.hazelcast.map.impl.MapDataSerializerHook;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.util.Preconditions;
import java.io.IOException;

public class Target
implements IdentifiedDataSerializable {
    public static final Target ALL_NODES = Target.of().allNodes().build();
    public static final Target LOCAL_NODE = Target.of().localNode().build();
    private TargetFlag target;
    private Integer partitionId;

    public Target() {
    }

    private Target(TargetFlag targetFlag, Integer partitionId) {
        this.target = Preconditions.checkNotNull(targetFlag);
        this.partitionId = partitionId;
        if (targetFlag.equals((Object)TargetFlag.PARTITION_OWNER) && partitionId == null) {
            throw new IllegalArgumentException("It's forbidden to use null partitionId with PARTITION_OWNER target");
        }
    }

    public Integer getPartitionId() {
        return this.partitionId;
    }

    public boolean isTargetLocalNode() {
        return this.target.equals((Object)TargetFlag.LOCAL_NODE);
    }

    public boolean isTargetAllNodes() {
        return this.target.equals((Object)TargetFlag.ALL_NODES);
    }

    public boolean isTargetPartitionOwner() {
        return this.target.equals((Object)TargetFlag.PARTITION_OWNER);
    }

    @Override
    public int getFactoryId() {
        return MapDataSerializerHook.F_ID;
    }

    @Override
    public int getId() {
        return 117;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeInt(this.partitionId);
        out.writeUTF(this.target.name());
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.partitionId = in.readInt();
        this.target = TargetFlag.valueOf(in.readUTF());
    }

    public static TargetBuilder of() {
        return new TargetBuilder();
    }

    public static final class TargetBuilder {
        private TargetFlag target;
        private Integer partitionId;

        private TargetBuilder() {
        }

        public TargetBuilder allNodes() {
            this.target = TargetFlag.ALL_NODES;
            return this;
        }

        public TargetBuilder localNode() {
            this.target = TargetFlag.LOCAL_NODE;
            return this;
        }

        public TargetBuilder partitionOwner(int partitionId) {
            this.target = TargetFlag.PARTITION_OWNER;
            this.partitionId = partitionId;
            return this;
        }

        public Target build() {
            return new Target(this.target, this.partitionId);
        }
    }

    static enum TargetFlag {
        LOCAL_NODE,
        ALL_NODES,
        PARTITION_OWNER;

    }
}

