/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.insight.scan.model.io;

import com.sonatype.insight.scan.model.io.ScanWriter;
import com.sonatype.insight.scan.model.io.ScanWriterFactory;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import javax.inject.Inject;
import javax.inject.Named;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
public class DefaultScanWriterFactory
implements ScanWriterFactory {
    private final Logger log;

    @Inject
    public DefaultScanWriterFactory() {
        this(LoggerFactory.getLogger(DefaultScanWriterFactory.class));
    }

    public DefaultScanWriterFactory(Logger log) {
        this.log = log;
    }

    @Override
    public ScanWriter newWriter(File scanFile) throws IOException {
        return new ScanWriter(scanFile, this.log);
    }

    @Override
    public ScanWriter newWriter(Writer writer) throws IOException {
        return new ScanWriter(writer, this.log);
    }
}

