/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.insight.scan.model.io;

import com.sonatype.insight.scan.model.Application;
import com.sonatype.insight.scan.model.DirectoryScanItem;
import com.sonatype.insight.scan.model.ExpandedCoverage;
import com.sonatype.insight.scan.model.ProjectScanItem;
import com.sonatype.insight.scan.model.Repository;
import com.sonatype.insight.scan.model.Scan;
import com.sonatype.insight.scan.model.ScanConfiguration;
import com.sonatype.insight.scan.model.ScanItem;
import com.sonatype.insight.scan.model.ScanSummary;
import com.sonatype.insight.scan.model.io.XStreamFactory;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.XStreamException;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import java.util.Stack;
import java.util.zip.GZIPOutputStream;
import org.slf4j.Logger;

public class ScanWriter
implements Closeable {
    public static final String PROPERTY_MASKED = Boolean.TRUE.toString();
    private static final Set<String> maskedConfigProperties = new HashSet<String>();
    private final Writer writer;
    private final XStream xstream = XStreamFactory.newInstance();
    private Stack<File> dirStack = new Stack();
    private boolean scanOpen = false;
    private final Logger logger;

    ScanWriter(File scanFile, Logger logger) throws IOException {
        this.logger = logger;
        scanFile.getAbsoluteFile().getParentFile().mkdirs();
        this.writer = new OutputStreamWriter((OutputStream)new GZIPOutputStream(new BufferedOutputStream(new FileOutputStream(scanFile), 32768)), "UTF-8");
        this.initializeXStream(this.xstream);
    }

    ScanWriter(Writer writer, Logger logger) {
        this.logger = logger;
        this.writer = writer;
        this.initializeXStream(this.xstream);
    }

    protected void initializeXStream(XStream xstream) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeWholeScan(Scan scan) throws IOException {
        this.logger.debug("Writing whole scan to stream and closing when complete");
        try {
            this.openScan(scan);
            this.writeApplication(scan.getApplication());
            this.writeConfiguration(scan.getConfiguration());
            for (ScanItem scanItem : scan.getItems()) {
                this.writeScanItem(scanItem);
            }
            this.writeRepository(scan.getRepository());
            this.writeExpandedCoverage(scan.getExpandedCoverage());
            this.writeSummary(scan.getSummary());
            this.closeScan();
        }
        finally {
            this.close();
        }
    }

    private String getOpenScanTag(String xml) {
        int index = xml.indexOf("\">");
        if (index > -1) {
            return xml.substring(0, index + "\">".length()) + "\n";
        }
        index = xml.indexOf("/>");
        if (index > -1) {
            return xml.substring(0, index) + ">" + "\n";
        }
        return null;
    }

    private String getOpenDirectoryItemTag(String xml) {
        int index = xml.lastIndexOf("</");
        if (index > -1) {
            return xml.substring(0, index) + "\n";
        }
        index = xml.lastIndexOf("/>");
        if (index > -1) {
            return xml.substring(0, index) + ">\n";
        }
        return null;
    }

    public void openScan(Scan scan) throws IOException {
        this.logger.debug("Opening scan tag");
        if (this.scanOpen) {
            throw new IOException("Scan already open, cannot open a new one");
        }
        this.scanOpen = true;
        String xml = this.xstream.toXML((Object)scan);
        String openTag = this.getOpenScanTag(xml);
        if (openTag == null || openTag.isEmpty()) {
            throw new IOException("XML Parse Error: Unable to retrieve open tag for scan.\n" + xml + "\n");
        }
        this.writer.write(openTag);
    }

    public void closeScan() throws IOException {
        this.logger.debug("Closing scan tag");
        if (!this.scanOpen) {
            throw new IOException("Scan not open, cannot close it");
        }
        this.writer.write("</scan>\n");
        this.scanOpen = false;
    }

    public void openDirectoryScanItem(DirectoryScanItem item, File file) throws IOException {
        this.logger.debug("Opening directory " + file);
        String xml = this.xstream.toXML((Object)item);
        String openTag = this.getOpenDirectoryItemTag(xml);
        if (openTag == null || openTag.isEmpty()) {
            throw new IOException("XML Parse Error: Unable to retrieve open tag for directory.\n" + xml + "\n");
        }
        this.indent();
        this.writer.write(openTag);
        this.dirStack.push(file);
    }

    public void closeDirectoryScanItem(File file) throws IOException {
        this.logger.debug("Closing directory " + file);
        if (this.dirStack.isEmpty()) {
            throw new IOException("Tried to close a directory item when none were open");
        }
        if (!ScanWriter.eq(this.dirStack.peek(), file)) {
            throw new IOException("Tried to close a directory that isn't on top of stack, " + file);
        }
        this.dirStack.pop();
        this.indent();
        this.writer.write("</dir>\n");
    }

    public void openProjectScanItem(ProjectScanItem item, File file) throws IOException {
        this.logger.debug("Opening project " + file);
        String xml = this.xstream.toXML((Object)item);
        String openTag = this.getOpenDirectoryItemTag(xml);
        if (openTag == null || openTag.isEmpty()) {
            throw new IOException("XML Parse Error: Unable to retrieve open tag for project.\n" + xml + "\n");
        }
        this.indent();
        this.writer.write(openTag);
        this.dirStack.push(file);
    }

    public void closeProjectScanItem(File file) throws IOException {
        this.logger.debug("Closing project " + file);
        if (this.dirStack.isEmpty()) {
            throw new IOException("Tried to close a project item when none were open");
        }
        if (!ScanWriter.eq(this.dirStack.peek(), file)) {
            throw new IOException("Tried to close a project that isn't on top of stack, " + file);
        }
        this.dirStack.pop();
        this.indent();
        this.writer.write("</project>\n");
    }

    private static <T> boolean eq(T o1, T o2) {
        return o1 != null ? o1.equals(o2) : o2 == null;
    }

    public void writeScanItem(ScanItem item) throws IOException {
        this.indent();
        this.writeObject(item);
    }

    public void writeSummary(ScanSummary summary) throws IOException {
        this.logger.debug("Writing scan summary");
        this.writeObject(summary);
    }

    public void writeConfiguration(ScanConfiguration config) throws IOException {
        this.logger.debug("Writing scan configuration");
        this.writeObject(this.copyConfigWithMaskedProperties(config));
    }

    public void writeApplication(Application app) throws IOException {
        this.logger.debug("Writing scan application");
        this.writeObject(app);
    }

    public void writeRepository(Repository repo) throws IOException {
        this.logger.debug("Writing scan repository");
        this.writeObject(repo);
    }

    public void writeExpandedCoverage(ExpandedCoverage expandedCoverage) throws IOException {
        this.logger.debug("Writing scan expanded coverage");
        this.writeObject(expandedCoverage);
    }

    @Override
    public void close() throws IOException {
        this.logger.debug("Closing writer");
        this.writer.close();
    }

    private void writeObject(Object obj) throws IOException {
        if (obj != null) {
            try {
                this.xstream.toXML(obj, this.writer);
                this.writer.write("\n");
            }
            catch (XStreamException e) {
                throw new IOException(e.getMessage(), e);
            }
        }
    }

    private void indent() throws IOException {
        this.indent(this.dirStack.size());
    }

    private void indent(int depth) throws IOException {
        for (int i = 0; i < depth; ++i) {
            this.writer.write("  ");
        }
    }

    private ScanConfiguration copyConfigWithMaskedProperties(ScanConfiguration config) {
        Properties originalProperties = config.getProperties();
        Properties newProperties = new Properties();
        for (String name : originalProperties.stringPropertyNames()) {
            String value = originalProperties.getProperty(name);
            if (maskedConfigProperties.contains(name) && !value.isEmpty()) {
                newProperties.setProperty(name, PROPERTY_MASKED);
                continue;
            }
            newProperties.setProperty(name, value);
        }
        return new ScanConfiguration(newProperties);
    }

    static {
        maskedConfigProperties.add("proprietaryPackages");
        maskedConfigProperties.add("proprietaryRegexes");
    }
}

