/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.insight.scan.model.io;

import com.sonatype.insight.scan.model.Application;
import com.sonatype.insight.scan.model.ArtifactId;
import com.sonatype.insight.scan.model.Dependency;
import com.sonatype.insight.scan.model.DirectoryScanItem;
import com.sonatype.insight.scan.model.ExpandedCoverage;
import com.sonatype.insight.scan.model.ProjectScanItem;
import com.sonatype.insight.scan.model.Repository;
import com.sonatype.insight.scan.model.ReverseLookupTable;
import com.sonatype.insight.scan.model.Scan;
import com.sonatype.insight.scan.model.ScanConfiguration;
import com.sonatype.insight.scan.model.ScanItem;
import com.sonatype.insight.scan.model.ScanSummary;
import com.sonatype.insight.scan.model.io.HashArrayConverter;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.SingleValueConverter;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.Xpp3Driver;
import com.thoughtworks.xstream.security.NoTypePermission;
import java.lang.reflect.Field;

class XStreamFactory {
    XStreamFactory() {
    }

    static XStream newInstance() {
        XStream xstream = new XStream((HierarchicalStreamDriver)new Xpp3Driver());
        xstream.addPermission(NoTypePermission.NONE);
        xstream.allowTypeHierarchy(ScanItem.class);
        xstream.allowTypeHierarchy(Scan.class);
        xstream.allowTypeHierarchy(ScanSummary.class);
        xstream.allowTypeHierarchy(ScanConfiguration.class);
        xstream.allowTypeHierarchy(Dependency.class);
        xstream.allowTypeHierarchy(ArtifactId.class);
        xstream.allowTypeHierarchy(Application.class);
        xstream.allowTypeHierarchy(Repository.class);
        xstream.allowTypeHierarchy(ExpandedCoverage.class);
        xstream.setClassLoader(XStreamFactory.class.getClassLoader());
        xstream.alias("scan", Scan.class);
        xstream.alias("summary", ScanSummary.class);
        xstream.alias("configuration", ScanConfiguration.class);
        xstream.alias("item", ScanItem.class);
        xstream.alias("dir", DirectoryScanItem.class);
        xstream.alias("project", ProjectScanItem.class);
        xstream.alias("dep", Dependency.class);
        xstream.alias("id", ArtifactId.class);
        xstream.alias("application", Application.class);
        xstream.alias("repository", Repository.class);
        xstream.alias("reverse-lookup-table", ReverseLookupTable.class);
        xstream.alias("expandedCoverage", ExpandedCoverage.class);
        xstream.addImplicitCollection(Scan.class, "items");
        xstream.addImplicitCollection(DirectoryScanItem.class, "items");
        xstream.addImplicitCollection(Dependency.class, "dependencies");
        xstream.addImplicitCollection(ScanSummary.class, "ipAddresses", "ipAddress", String.class);
        HashArrayConverter hashArrayConverter = new HashArrayConverter();
        xstream.useAttributeFor(Scan.class, "version");
        xstream.useAttributeFor(ScanItem.class, "path");
        xstream.useAttributeFor(ScanItem.class, "noPathReason");
        xstream.useAttributeFor(ScanItem.class, "proprietary");
        xstream.useAttributeFor(ScanItem.class, "size");
        xstream.useAttributeFor(ScanItem.class, "lastModified");
        for (Field field : ScanItem.class.getDeclaredFields()) {
            if (!field.getName().startsWith("sha1")) continue;
            xstream.useAttributeFor(ScanItem.class, field.getName());
            if (!field.getType().isArray()) continue;
            xstream.registerLocalConverter(ScanItem.class, field.getName(), (SingleValueConverter)hashArrayConverter);
        }
        xstream.useAttributeFor(ScanItem.class, "nameSha1");
        xstream.useAttributeFor(ScanItem.class, "lastAccess");
        xstream.useAttributeFor(ScanItem.class, "kind");
        xstream.useAttributeFor(ScanItem.class, "id");
        xstream.useAttributeFor(ScanItem.class, "hasError");
        xstream.useAttributeFor(ScanItem.class, "dependency");
        xstream.useAttributeFor(ScanItem.class, "dailyDownloadCounts");
        xstream.useAttributeFor(ScanItem.class, "monthlyDownloadCounts");
        xstream.useAttributeFor(Application.class, "id");
        xstream.useAttributeFor(Application.class, "version");
        xstream.useAttributeFor(Repository.class, "manager");
        xstream.useAttributeFor(Repository.class, "id");
        xstream.useAttributeFor(Repository.class, "name");
        xstream.useAttributeFor(Repository.class, "format");
        xstream.useAttributeFor(Repository.class, "proxyUrl");
        xstream.useAttributeFor(ArtifactId.class, "kind");
        xstream.useAttributeFor(ArtifactId.class, "id");
        xstream.useAttributeFor(Dependency.class, "id");
        xstream.useAttributeFor(Dependency.class, "direct");
        xstream.useAttributeFor(ExpandedCoverage.class, "version");
        return xstream;
    }
}

