/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.goodies.lifecycle;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.concurrent.CopyOnWriteArrayList;
import org.sonatype.goodies.common.MultipleFailures;
import org.sonatype.goodies.lifecycle.Lifecycle;
import org.sonatype.goodies.lifecycle.LifecycleAware;
import org.sonatype.goodies.lifecycle.LifecycleSupport;

public class LifecycleManager
extends LifecycleSupport {
    private final CopyOnWriteArrayList<Lifecycle> components = new CopyOnWriteArrayList();

    public void add(Lifecycle component) {
        Preconditions.checkNotNull((Object)component);
        boolean added = this.components.addIfAbsent(component);
        if (added) {
            this.log.trace("Added: {}", (Object)component);
        }
    }

    public void add(Lifecycle ... components) {
        Preconditions.checkNotNull((Object)components);
        for (Lifecycle component : components) {
            this.add(component);
        }
    }

    public void add(LifecycleAware ... components) {
        Preconditions.checkNotNull((Object)components);
        for (LifecycleAware component : components) {
            this.add(component.getLifecycle());
        }
    }

    public void remove(Lifecycle component) {
        Preconditions.checkNotNull((Object)component);
        boolean removed = this.components.remove(component);
        if (removed) {
            this.log.trace("Removed: {}", (Object)component);
        }
    }

    public void remove(Lifecycle ... components) {
        Preconditions.checkNotNull((Object)components);
        for (Lifecycle component : components) {
            this.remove(component);
        }
    }

    public void remove(LifecycleAware ... components) {
        Preconditions.checkNotNull((Object)components);
        for (LifecycleAware component : components) {
            this.remove(component.getLifecycle());
        }
    }

    public int size() {
        return this.components.size();
    }

    public void clear() {
        this.components.clear();
        this.log.trace("Cleared");
    }

    @Override
    protected void doStart() throws Exception {
        int count = this.components.size();
        this.log.debug("Starting {} components", (Object)count);
        MultipleFailures failures = new MultipleFailures(count);
        for (Lifecycle component : this.components) {
            try {
                component.start();
            }
            catch (Throwable failure) {
                this.logTransitionFailure("Failed to start component: " + component, failure);
                failures.add(failure);
            }
        }
        failures.maybePropagate("Failed to start " + failures.size() + " components");
    }

    @Override
    protected void doStop() throws Exception {
        int count = this.components.size();
        this.log.debug("Stopping {} components", (Object)count);
        MultipleFailures failures = new MultipleFailures(count);
        for (Lifecycle component : Lists.reverse(this.components)) {
            try {
                component.stop();
            }
            catch (Throwable failure) {
                this.logTransitionFailure("Failed to stop component: " + component, failure);
                failures.add(failure);
            }
        }
        failures.maybePropagate("Failed to stop " + failures.size() + " components");
    }
}

