/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.goodies.lifecycle;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import java.util.Arrays;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.goodies.common.Locks;
import org.sonatype.goodies.lifecycle.Lifecycle;

public class LifecycleSupport
extends ComponentSupport
implements Lifecycle {
    private final ReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    private State current = State.NEW;

    protected void logTransition(String message) {
        this.log.debug(message);
    }

    protected void logTransitionFailure(String message, Throwable cause) {
        this.log.error(message, cause);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    boolean is(State state) {
        Lock lock = Locks.read((ReadWriteLock)this.readWriteLock);
        try {
            boolean bl = this.current == state;
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    private void ensure(State ... allowed) {
        for (State allow : allowed) {
            if (this.current != allow) continue;
            return;
        }
        throw new IllegalStateException("Invalid state: " + (Object)((Object)this.current) + "; allowed: " + Arrays.toString((Object[])allowed));
    }

    @Override
    public final void start() throws Exception {
        Lock lock = Locks.write((ReadWriteLock)this.readWriteLock);
        this.ensure(State.NEW, State.STOPPED);
        try {
            this.logTransition("Starting");
            this.doStart();
            this.current = State.STARTED;
            this.logTransition("Started");
        }
        catch (Throwable failure) {
            this.doFailed("start", failure);
        }
        finally {
            lock.unlock();
        }
    }

    protected void doStart() throws Exception {
    }

    protected boolean isStarted() {
        return this.is(State.STARTED);
    }

    protected void ensureStarted() {
        Preconditions.checkState((boolean)this.isStarted(), (Object)"Not started");
    }

    @Override
    public final void stop() throws Exception {
        Lock lock = Locks.write((ReadWriteLock)this.readWriteLock);
        this.ensure(State.STARTED);
        try {
            this.logTransition("Stopping");
            this.doStop();
            this.current = State.STOPPED;
            this.logTransition("Stopped");
        }
        catch (Throwable failure) {
            this.doFailed("stop", failure);
        }
        finally {
            lock.unlock();
        }
    }

    protected void doStop() throws Exception {
    }

    protected boolean isStopped() {
        return this.is(State.STOPPED);
    }

    protected void ensureStopped() {
        Preconditions.checkState((boolean)this.isStopped(), (Object)"Not stopped");
    }

    protected void doFailed(String operation, Throwable cause) throws Exception {
        this.logTransitionFailure("Lifecycle operation " + operation + " failed", cause);
        this.current = State.FAILED;
        Throwables.propagateIfPossible((Throwable)cause, Exception.class);
        throw Throwables.propagate((Throwable)cause);
    }

    protected boolean isFailed() {
        return this.is(State.FAILED);
    }

    @VisibleForTesting
    static enum State {
        NEW,
        STARTED,
        STOPPED,
        FAILED;

    }
}

