/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.client.remote;

import com.orientechnologies.orient.client.remote.OStorageRemoteNodeSession;
import com.orientechnologies.orient.core.db.ODatabaseSessionMetadata;
import com.orientechnologies.orient.enterprise.channel.binary.OChannelBinary;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;

public class OStorageRemoteSession
implements ODatabaseSessionMetadata {
    boolean commandExecuting = false;
    int serverURLIndex = -1;
    String connectionUserName = null;
    String connectionUserPassword = null;
    Map<String, OStorageRemoteNodeSession> sessions = new HashMap<String, OStorageRemoteNodeSession>();
    private Set<OChannelBinary> connections = Collections.newSetFromMap(new WeakHashMap());
    private final int uniqueClientSessionId;
    private boolean closed = true;

    public OStorageRemoteSession(int sessionId) {
        this.uniqueClientSessionId = sessionId;
    }

    public boolean hasConnection(OChannelBinary connection) {
        return this.connections.contains(connection);
    }

    public OStorageRemoteNodeSession getServerSession(String serverURL) {
        return this.sessions.get(serverURL);
    }

    public synchronized OStorageRemoteNodeSession getOrCreateServerSession(String serverURL) {
        OStorageRemoteNodeSession session = this.sessions.get(serverURL);
        if (session == null) {
            session = new OStorageRemoteNodeSession(serverURL, this.uniqueClientSessionId);
            this.sessions.put(serverURL, session);
            this.closed = false;
        }
        return session;
    }

    public void addConnection(OChannelBinary connection) {
        this.connections.add(connection);
    }

    public void close() {
        this.commandExecuting = false;
        this.serverURLIndex = -1;
        this.connections = new HashSet<OChannelBinary>();
        this.sessions = new HashMap<String, OStorageRemoteNodeSession>();
        this.closed = true;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public Integer getSessionId() {
        if (this.sessions.isEmpty()) {
            return -1;
        }
        OStorageRemoteNodeSession curSession = this.sessions.values().iterator().next();
        return curSession.getSessionId();
    }

    public String getServerUrl() {
        if (this.sessions.isEmpty()) {
            return null;
        }
        OStorageRemoteNodeSession curSession = this.sessions.values().iterator().next();
        return curSession.getServerURL();
    }

    public synchronized void removeServerSession(String serverURL) {
        this.sessions.remove(serverURL);
    }

    public synchronized Collection<OStorageRemoteNodeSession> getAllServerSessions() {
        return this.sessions.values();
    }
}

