/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.nuget;

import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import java.util.Locale;
import org.sonatype.nexus.common.collect.NestedAttributesMap;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.storage.Asset;
import org.sonatype.nexus.repository.storage.Component;
import org.sonatype.nexus.repository.storage.Query;
import org.sonatype.nexus.repository.storage.StorageTx;

public class NugetComponentHelper {
    private NugetComponentHelper() {
    }

    public static void updateDerivedTextFields(Asset asset) {
        NestedAttributesMap nugetAttribs = asset.formatAttributes();
        Joiner joiner = Joiner.on((String)" ").skipNulls();
        String keywords = joiner.join(nugetAttribs.get("id", String.class), nugetAttribs.get("title", String.class), new Object[]{nugetAttribs.get("description", String.class), nugetAttribs.get("tags", String.class), nugetAttribs.get("authors", String.class)});
        nugetAttribs.set("keywords", (Object)keywords.toLowerCase());
        String value = String.valueOf(Strings.nullToEmpty((String)((String)nugetAttribs.get("title", String.class)))) + Strings.nullToEmpty((String)((String)nugetAttribs.get("id", String.class)));
        nugetAttribs.set("name_order", (Object)value.toLowerCase(Locale.ENGLISH));
    }

    public static Component findComponent(StorageTx tx, String name, Object version, Iterable<Repository> repositories) {
        return (Component)Iterables.getFirst((Iterable)tx.findComponents(Query.builder().where("ci_name").eq((Object)name.toLowerCase(Locale.ENGLISH)).and("version").eq(version).build(), repositories), null);
    }

    public static Component createComponent(StorageTx tx, Repository repository, String packageId, String version) {
        return ((Component)tx.createComponent(tx.findBucket(repository), repository.getFormat()).name(packageId)).version(version);
    }

    public static String blobName(Component component) {
        return String.valueOf(component.name()) + "-" + component.requireVersion() + ".nupkg";
    }
}

