/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.nuget;

import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.sonatype.nexus.repository.nuget.NugetGalleryFacet;
import com.sonatype.nexus.repository.nuget.NugetPackageCoords;
import com.sonatype.nexus.repository.nuget.NugetPackageException;
import com.sonatype.nexus.repository.nuget.odata.NugetPackageUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.rest.UploadDefinitionExtension;
import org.sonatype.nexus.repository.security.ContentPermissionChecker;
import org.sonatype.nexus.repository.security.VariableResolverAdapter;
import org.sonatype.nexus.repository.storage.Component;
import org.sonatype.nexus.repository.storage.StorageFacet;
import org.sonatype.nexus.repository.storage.TempBlob;
import org.sonatype.nexus.repository.upload.AssetUpload;
import org.sonatype.nexus.repository.upload.ComponentUpload;
import org.sonatype.nexus.repository.upload.UploadDefinition;
import org.sonatype.nexus.repository.upload.UploadHandlerSupport;
import org.sonatype.nexus.repository.upload.UploadResponse;
import org.sonatype.nexus.repository.view.PartPayload;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.transaction.UnitOfWork;

@Named(value="nuget")
@Singleton
public class NugetUploadHandler
extends UploadHandlerSupport {
    private UploadDefinition definition;
    private final ContentPermissionChecker contentPermissionChecker;
    private final VariableResolverAdapter variableResolverAdapter;

    @Inject
    public NugetUploadHandler(ContentPermissionChecker contentPermissionCheckerr, @Named(value="simple") VariableResolverAdapter variableResolverAdapter, Set<UploadDefinitionExtension> uploadDefinitionExtensions) {
        super(uploadDefinitionExtensions);
        this.contentPermissionChecker = contentPermissionCheckerr;
        this.variableResolverAdapter = variableResolverAdapter;
    }

    public UploadResponse handle(Repository repository, ComponentUpload upload) throws IOException {
        Preconditions.checkNotNull((Object)repository);
        Preconditions.checkNotNull((Object)upload);
        return this.doUpload(repository, upload);
    }

    private UploadResponse doUpload(Repository repository, ComponentUpload component) throws IOException {
        NugetGalleryFacet galleryFacet = (NugetGalleryFacet)repository.facet(NugetGalleryFacet.class);
        StorageFacet storageFacet = (StorageFacet)repository.facet(StorageFacet.class);
        PartPayload payload = ((AssetUpload)component.getAssetUploads().get(0)).getPayload();
        try {
            Throwable throwable = null;
            Object var7_9 = null;
            try (TempBlob tempBlob = storageFacet.createTempBlob((Payload)payload, NugetPackageUtils.HASH_ALGORITHMS);){
                Component resultantComponent;
                Map<String, String> metadata;
                Throwable throwable2 = null;
                Object var12_14 = null;
                try (InputStream in = tempBlob.get();){
                    metadata = NugetPackageUtils.packageMetadata(in);
                }
                catch (Throwable throwable3) {
                    if (throwable2 == null) {
                        throwable2 = throwable3;
                    } else if (throwable2 != throwable3) {
                        throwable2.addSuppressed(throwable3);
                    }
                    throw throwable2;
                }
                NugetPackageCoords nugetPackageCoords = new NugetPackageCoords(metadata.get("ID"), metadata.get("VERSION"));
                String path = String.valueOf(nugetPackageCoords.getId()) + "/" + nugetPackageCoords.getVersion();
                this.ensurePermitted(repository.getName(), "nuget", path, this.toMap(nugetPackageCoords));
                UnitOfWork.begin((Supplier)storageFacet.txSupplier());
                try {
                    resultantComponent = galleryFacet.put(metadata, tempBlob);
                }
                finally {
                    UnitOfWork.end();
                }
                this.log.debug("Added nuget component {}", (Object)nugetPackageCoords);
                return new UploadResponse(resultantComponent.getEntityMetadata().getId(), Collections.singletonList(nugetPackageCoords.toString()));
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
        catch (NugetPackageException e) {
            throw new IOException("Unable to get valid component from supplied file", e);
        }
    }

    private Map<String, String> toMap(NugetPackageCoords coords) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("id", coords.getId());
        map.put("version", coords.getVersion());
        return map;
    }

    public UploadDefinition getDefinition() {
        if (this.definition == null) {
            this.definition = this.getDefinition("nuget", false);
        }
        return this.definition;
    }

    public VariableResolverAdapter getVariableResolverAdapter() {
        return this.variableResolverAdapter;
    }

    public ContentPermissionChecker contentPermissionChecker() {
        return this.contentPermissionChecker;
    }
}

