/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.nuget.internal;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.common.text.Strings2;
import org.sonatype.nexus.repository.browse.ComponentPathBrowseNodeGenerator;
import org.sonatype.nexus.repository.storage.Asset;
import org.sonatype.nexus.repository.storage.Component;

@Singleton
@Named(value="nuget")
public class NugetBrowseNodeGenerator
extends ComponentPathBrowseNodeGenerator {
    public List<String> computeAssetPath(Asset asset, @Nullable Component component) {
        Preconditions.checkNotNull((Object)asset);
        if (component != null) {
            List<String> path = this.computeComponentPath(asset, component);
            path.add(this.packageName(component.name(), component.version()));
            return path;
        }
        List path = super.computeAssetPath(asset, null);
        if (path.size() == 2 && Character.isDigit(((String)path.get(1)).charAt(0))) {
            path.add(this.packageName((String)path.get(0), (String)path.get(1)));
        }
        return path;
    }

    public List<String> computeComponentPath(Asset asset, Component component) {
        ArrayList<String> path = new ArrayList<String>();
        path.add(component.name());
        if (!Strings2.isBlank((String)component.version())) {
            path.add(component.version());
        }
        return path;
    }

    private String packageName(String id, @Nullable String version) {
        if (!Strings2.isBlank((String)version)) {
            return String.format("%s-%s.nupkg", id, version);
        }
        return String.format("%s.nupkg", id);
    }
}

