/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.nuget.internal;

import com.google.common.base.Preconditions;
import com.google.common.io.CharStreams;
import com.sonatype.nexus.repository.nuget.odata.FeedSplicer;
import com.sonatype.nexus.repository.nuget.odata.ODataConsumer;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.annotation.Nullable;
import javax.inject.Named;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.HttpClientUtils;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.httpclient.HttpClientFacet;
import org.sonatype.nexus.repository.proxy.ProxyFacet;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.payloads.HttpEntityPayload;

@Named
public class NugetFeedFetcher
extends ComponentSupport {
    @Nullable
    public Integer cachePackageFeed(Repository proxy, URI nugetQuery, boolean followNextPageLinks, ODataConsumer odataConsumer) throws IOException {
        Preconditions.checkNotNull((Object)proxy);
        Preconditions.checkNotNull((Object)nugetQuery);
        Preconditions.checkNotNull((Object)odataConsumer);
        FeedSplicer splicer = new FeedSplicer(odataConsumer);
        LinkedHashSet<String> visited = new LinkedHashSet<String>();
        URI remoteUrl = this.absoluteURI(proxy, nugetQuery);
        do {
            Payload payload;
            if ((payload = this.getPayload(proxy, remoteUrl)) == null) {
                return splicer.getCount();
            }
            Throwable throwable = null;
            Object var10_11 = null;
            try (InputStream is = payload.openInputStream();){
                remoteUrl = this.parseFeed(is, splicer, visited, followNextPageLinks);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        } while (remoteUrl != null);
        return splicer.getCount();
    }

    private URI parseFeed(InputStream is, FeedSplicer splicer, Set<String> visited, boolean followNextPageLinks) throws IOException {
        try {
            String nextPageUrl = splicer.consumePage(is);
            if (followNextPageLinks && nextPageUrl != null) {
                if (visited.add(nextPageUrl)) {
                    return new URI(nextPageUrl);
                }
                this.log.warn("Page cycle detected: {} -> {}", visited, (Object)nextPageUrl);
            }
            return null;
        }
        catch (XmlPullParserException e) {
            throw new IOException("Invalid nuget feed XML received", e);
        }
        catch (URISyntaxException e) {
            throw new IOException("Invalid 'next page' URI in nuget XML feed", e);
        }
    }

    @Nullable
    public Integer getCount(Repository proxy, URI nugetQuery) throws IOException {
        Payload item = this.getPayload(proxy, this.absoluteURI(proxy, nugetQuery));
        if (item == null) {
            return 0;
        }
        Throwable throwable = null;
        Object var5_6 = null;
        try (InputStream is = item.openInputStream();){
            String s = CharStreams.toString((Readable)new InputStreamReader(is, StandardCharsets.UTF_8)).trim();
            return Integer.parseInt(s);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public Payload getRemotePayload(Repository proxy, URI uri) throws IOException {
        return this.getPayload(proxy, this.absoluteURI(proxy, uri));
    }

    private URI absoluteURI(Repository proxy, URI nugetQuery) {
        URI repoBaseUrl = ((ProxyFacet)proxy.facet(ProxyFacet.class)).getRemoteUrl();
        return repoBaseUrl.resolve(nugetQuery);
    }

    private Payload getPayload(Repository proxy, URI uri) throws IOException {
        HttpClient client = ((HttpClientFacet)proxy.facet(HttpClientFacet.class)).getHttpClient();
        HttpGet request = new HttpGet(uri);
        this.log.debug("Fetching: {}", (Object)request);
        HttpResponse response = client.execute((HttpUriRequest)request);
        this.log.debug("Response: {}", (Object)response);
        StatusLine status = response.getStatusLine();
        this.log.debug("Status: {}", (Object)status);
        if (status.getStatusCode() == 200) {
            HttpEntity entity = response.getEntity();
            Preconditions.checkState((entity != null ? 1 : 0) != 0, (Object)"No http entity received from remote nuget query");
            this.log.debug("Entity: {}", (Object)entity);
            return new HttpEntityPayload(response, entity);
        }
        this.log.warn("Status code {} contacting {}", (Object)status.getStatusCode(), (Object)uri);
        HttpClientUtils.closeQuietly((HttpResponse)response);
        return null;
    }
}

