/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.nuget.internal;

import com.google.common.collect.Maps;
import com.sonatype.nexus.repository.nuget.NugetGalleryFacet;
import com.sonatype.nexus.repository.nuget.internal.AbstractNugetHandler;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import org.sonatype.nexus.repository.http.HttpResponses;
import org.sonatype.nexus.repository.view.Context;
import org.sonatype.nexus.repository.view.Parameters;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.Response;
import org.sonatype.nexus.repository.view.matchers.token.TokenMatcher;
import org.sonatype.nexus.repository.view.payloads.StringPayload;

public class NugetFeedHandler
extends AbstractNugetHandler {
    public static final String FEED_PATTERN = "/{operation:[^/()]+}{parens:\\\\Q()\\\\E|}";
    public static final String FEED_COUNT_PATTERN = "/{operation:[^/()]+}{parens:\\\\Q()\\\\E|}/$count";
    public static final String PACKAGE_ENTRY_PATTERN = "/Packages(Id='{id}',Version='{version}')";
    public static final String PACKAGE_VERSIONS_PATTERN = "/package-versions/{id}";

    @Override
    protected Response doHandle(Context context) throws Exception {
        TokenMatcher.State state = (TokenMatcher.State)context.getAttributes().get(TokenMatcher.State.class);
        Map tokens = state.getTokens();
        NugetGalleryFacet facet = (NugetGalleryFacet)context.getRepository().facet(NugetGalleryFacet.class);
        Parameters queryParameters = context.getRequest().getParameters();
        switch (state.pattern()) {
            case "/{operation:[^/()]+}{parens:\\\\Q()\\\\E|}": {
                return this.feed(context, tokens, facet, queryParameters);
            }
            case "/{operation:[^/()]+}{parens:\\\\Q()\\\\E|}/$count": {
                return this.feedCount(context, facet, queryParameters);
            }
            case "/Packages(Id='{id}',Version='{version}')": {
                return this.packageEntry(context, tokens, facet);
            }
            case "/package-versions/{id}": {
                return this.packageVersions(context, tokens, facet, queryParameters);
            }
        }
        throw new IllegalStateException("Unexpected path pattern passed to " + ((Object)((Object)this)).getClass().getSimpleName());
    }

    private Response feed(@Nonnull Context context, Map<String, String> tokens, NugetGalleryFacet facet, Parameters queryParameters) {
        String feed = facet.feed(this.getRepositoryBase(context), tokens.get("operation"), NugetFeedHandler.asMap(queryParameters));
        return this.xmlPayload(200, feed);
    }

    private Response feedCount(@Nonnull Context context, NugetGalleryFacet facet, Parameters queryParameters) {
        String operation = context.getRequest().getPath().substring(1);
        int count = facet.count(operation, NugetFeedHandler.asMap(queryParameters));
        return HttpResponses.ok((Payload)new StringPayload(Integer.toString(count), "text/plain"));
    }

    private Response packageEntry(@Nonnull Context context, Map<String, String> tokens, NugetGalleryFacet facet) {
        String entry = facet.entry(this.getRepositoryBase(context), tokens.get("id"), tokens.get("version"));
        if (entry == null) {
            return HttpResponses.notFound();
        }
        return this.xmlPayload(200, entry);
    }

    private Response packageVersions(@Nonnull Context context, Map<String, String> tokens, NugetGalleryFacet facet, Parameters queryParameters) {
        String versions = facet.packageVersions(this.getRepositoryBase(context), tokens.get("id"), NugetFeedHandler.asMap(queryParameters));
        return HttpResponses.ok((Payload)new StringPayload(versions, "application/json"));
    }

    public static Map<String, String> asMap(Parameters parameters) {
        HashMap query = Maps.newHashMap();
        for (String param : parameters.names()) {
            query.put(param, parameters.get(param));
        }
        return query;
    }
}

