/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.nuget.internal;

import com.google.common.base.Preconditions;
import com.sonatype.nexus.repository.nuget.NugetGalleryFacet;
import com.sonatype.nexus.repository.nuget.NugetPackageException;
import com.sonatype.nexus.repository.nuget.internal.AbstractNugetHandler;
import com.sonatype.nexus.repository.nuget.odata.NugetPackageUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import javax.annotation.Nonnull;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.http.HttpResponses;
import org.sonatype.nexus.repository.security.SecurityFacet;
import org.sonatype.nexus.repository.storage.DatabaseThreadUtils;
import org.sonatype.nexus.repository.storage.StorageFacet;
import org.sonatype.nexus.repository.storage.TempBlob;
import org.sonatype.nexus.repository.view.Context;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.Request;
import org.sonatype.nexus.repository.view.Response;
import org.sonatype.nexus.repository.view.payloads.StringPayload;

public class NugetPushHandler
extends AbstractNugetHandler {
    private static final String EMPTY_HTMLDOC = "<html><body></body></html>";

    @Override
    protected Response doHandle(Context context) throws Exception {
        String action;
        Request request = context.getRequest();
        switch (action = request.getAction()) {
            case "PUT": {
                return this.push(context, request);
            }
        }
        return HttpResponses.methodNotAllowed((String)action, (String[])new String[]{"PUT"});
    }

    private Response push(@Nonnull Context context, Request request) throws IOException, NugetPackageException {
        Preconditions.checkArgument((boolean)request.isMultipart(), (Object)"Multipart request required");
        boolean created = false;
        Iterable multiparts = request.getMultiparts();
        for (Payload payload : multiparts) {
            this.storePayload(context, payload);
            created = true;
        }
        Preconditions.checkArgument((boolean)created, (Object)"No content was provided");
        return HttpResponses.created((Payload)new StringPayload(EMPTY_HTMLDOC, "text/html"));
    }

    private void storePayload(Context context, Payload payload) throws IOException, NugetPackageException {
        Repository repository = context.getRepository();
        NugetGalleryFacet galleryFacet = (NugetGalleryFacet)repository.facet(NugetGalleryFacet.class);
        StorageFacet storageFacet = (StorageFacet)repository.facet(StorageFacet.class);
        Throwable throwable = null;
        Object var7_8 = null;
        try (TempBlob tempBlob = storageFacet.createTempBlob(payload, NugetPackageUtils.HASH_ALGORITHMS);){
            Map<String, String> metadata;
            Throwable throwable2 = null;
            Object var11_13 = null;
            try (InputStream in = tempBlob.get();){
                metadata = NugetPackageUtils.packageMetadata(in);
            }
            catch (Throwable throwable3) {
                if (throwable2 == null) {
                    throwable2 = throwable3;
                } else if (throwable2 != throwable3) {
                    throwable2.addSuppressed(throwable3);
                }
                throw throwable2;
            }
            this.ensurePermissions(context, metadata);
            galleryFacet.put(metadata, tempBlob);
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
    }

    private void ensurePermissions(Context context, Map<String, String> metadata) {
        String id = (String)Preconditions.checkNotNull((Object)metadata.get("ID"));
        String version = (String)Preconditions.checkNotNull((Object)metadata.get("VERSION"));
        String path = String.format("/%s/%s", id, version);
        Request contextRequest = context.getRequest();
        Request changedRequest = new Request.Builder().copy(contextRequest).path(path).build();
        SecurityFacet facet = (SecurityFacet)context.getRepository().facet(SecurityFacet.class);
        DatabaseThreadUtils.withOtherDatabase(() -> {
            facet.ensurePermitted(changedRequest);
            return null;
        });
    }
}

