/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.nuget.internal;

import com.google.common.base.Preconditions;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.sonatype.nexus.repository.nuget.NugetPackageCoords;
import com.sonatype.nexus.repository.nuget.NugetPackagePathParser;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import org.elasticsearch.search.lookup.SourceLookup;
import org.sonatype.nexus.repository.security.VariableResolverAdapter;
import org.sonatype.nexus.repository.security.VariableResolverAdapterSupport;
import org.sonatype.nexus.repository.storage.Asset;
import org.sonatype.nexus.repository.view.Request;
import org.sonatype.nexus.selector.VariableSourceBuilder;

@Named(value="nuget")
public class NugetVariableResolverAdapter
extends VariableResolverAdapterSupport
implements VariableResolverAdapter {
    private final NugetPackagePathParser nugetPackagePathParser;

    @Inject
    public NugetVariableResolverAdapter(@Named(value="nuget") NugetPackagePathParser nugetPackagePathParser) {
        this.nugetPackagePathParser = (NugetPackagePathParser)Preconditions.checkNotNull((Object)nugetPackagePathParser);
    }

    protected void addFromRequest(VariableSourceBuilder builder, Request request) {
        this.addNugetCoordinates(builder, request.getPath());
    }

    protected void addFromDocument(VariableSourceBuilder builder, ODocument document) {
    }

    protected void addFromAsset(VariableSourceBuilder builder, Asset asset) {
    }

    protected void addFromSourceLookup(VariableSourceBuilder builder, SourceLookup sourceLookup, Map<String, Object> asset) {
    }

    private void addNugetCoordinates(VariableSourceBuilder builder, String path) {
        Preconditions.checkNotNull((Object)builder);
        Preconditions.checkNotNull((Object)path);
        NugetPackageCoords coords = this.nugetPackagePathParser.parsePath(path);
        if (coords != null) {
            HashMap<String, String> coordMap = new HashMap<String, String>();
            coordMap.put("id", coords.getId());
            coordMap.put("version", coords.getVersion());
            this.addCoordinates(builder, coordMap);
        }
    }
}

