/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.nuget.internal.proxy;

import com.sonatype.nexus.repository.nuget.NugetCachingGalleryFacet;
import com.sonatype.nexus.repository.nuget.internal.NugetFeedFetcher;
import java.io.IOException;
import java.net.URI;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import org.sonatype.nexus.repository.cache.CacheInfo;
import org.sonatype.nexus.repository.proxy.ProxyFacetSupport;
import org.sonatype.nexus.repository.view.Content;
import org.sonatype.nexus.repository.view.Context;
import org.sonatype.nexus.repository.view.matchers.token.TokenMatcher;

public class NugetProxyFacet
extends ProxyFacetSupport {
    private final NugetFeedFetcher fetcher;

    @Inject
    public NugetProxyFacet(NugetFeedFetcher fetcher) {
        this.fetcher = fetcher;
    }

    public void invalidateProxyCaches() {
        super.invalidateProxyCaches();
        this.gallery().invalidateCaches();
    }

    protected Content getCachedContent(Context context) throws IOException {
        String[] coords = NugetProxyFacet.coords(context);
        return this.gallery().get(coords[0], coords[1]);
    }

    protected Content fetch(Context context, Content stale) throws IOException {
        String[] coords = NugetProxyFacet.coords(context);
        String suffix = "Packages(Id='" + coords[0] + "',Version='" + coords[1] + "')";
        URI remoteEntryUri = this.getRemoteUrl().resolve(suffix);
        StringBuilder contentLocation = new StringBuilder();
        this.fetcher.cachePackageFeed(this.getRepository(), remoteEntryUri, false, data -> {
            if (contentLocation.length() == 0) {
                contentLocation.append((String)data.get("LOCATION"));
            }
            this.gallery().putMetadata(data);
        });
        if (contentLocation.length() == 0) {
            this.log.debug("Proxy repo {} found no package entry for {} {} at remote", new Object[]{this.getRepository().getName(), coords[0], coords[1]});
            return null;
        }
        return this.fetch(contentLocation.toString(), context, stale);
    }

    protected Content store(Context context, Content payload) throws IOException {
        String[] coords = NugetProxyFacet.coords(context);
        return this.gallery().putContent(coords[0], coords[1], payload);
    }

    protected void indicateVerified(Context context, Content content, CacheInfo cacheInfo) throws IOException {
        String[] coords = NugetProxyFacet.coords(context);
        this.gallery().setCacheInfo(coords[0], coords[1], content, cacheInfo);
    }

    protected String getUrl(@Nonnull Context context) {
        String[] coords = NugetProxyFacet.coords(context);
        return String.valueOf(coords[0]) + "/" + coords[1];
    }

    private NugetCachingGalleryFacet gallery() {
        return (NugetCachingGalleryFacet)this.getRepository().facet(NugetCachingGalleryFacet.class);
    }

    private static String[] coords(Context context) {
        Map tokens = ((TokenMatcher.State)context.getAttributes().require(TokenMatcher.State.class)).getTokens();
        return new String[]{(String)tokens.get("id"), (String)tokens.get("version")};
    }
}

