/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.nuget.internal.security;

import com.codahale.metrics.annotation.ExceptionMetered;
import com.codahale.metrics.annotation.Timed;
import com.google.common.base.Preconditions;
import com.softwarementors.extjs.djn.config.annotations.DirectAction;
import com.softwarementors.extjs.djn.config.annotations.DirectMethod;
import com.sonatype.nexus.repository.nuget.security.NugetApiKeyExtractor;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import java.lang.ref.SoftReference;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.hibernate.validator.constraints.NotEmpty;
import org.sonatype.nexus.common.wonderland.AuthTicketService;
import org.sonatype.nexus.extdirect.DirectComponentSupport;
import org.sonatype.nexus.security.SecurityHelper;
import org.sonatype.nexus.security.authc.apikey.ApiKeyStore;
import org.sonatype.nexus.validation.Validate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Named
@Singleton
@DirectAction(action={"nuget_NuGetApiKey"})
public class NugetApiKeyComponent
extends DirectComponentSupport
implements GroovyObject {
    @Inject
    private Provider<ApiKeyStore> keyStore;
    @Inject
    private AuthTicketService authTokens;
    @Inject
    private SecurityHelper securityHelper;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ SoftReference $callSiteArray;

    public NugetApiKeyComponent() {
        MetaClass metaClass;
        CallSite[] callSiteArray = NugetApiKeyComponent.$getCallSiteArray();
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    @DirectMethod
    @Timed
    @ExceptionMetered
    @RequiresPermissions(value={"nexus:apikey:read"})
    @Validate
    public String readKey(@NotEmpty String authToken) {
        CallSite[] callSiteArray = NugetApiKeyComponent.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            callSiteArray[0].callCurrent((GroovyObject)this, (Object)authToken);
        } else {
            this.validateAuthToken(authToken);
        }
        Object principals = callSiteArray[1].callGetProperty(callSiteArray[2].call((Object)this.securityHelper));
        char[] apiKey = (char[])ScriptBytecodeAdapter.castToType((Object)callSiteArray[3].call(callSiteArray[4].call(this.keyStore), callSiteArray[5].callGetProperty(NugetApiKeyExtractor.class), principals), char[].class);
        if (!DefaultTypeTransformation.booleanUnbox((Object)apiKey)) {
            Object object = callSiteArray[6].call(callSiteArray[7].call(this.keyStore), callSiteArray[8].callGetProperty(NugetApiKeyExtractor.class), principals);
            apiKey = (char[])ScriptBytecodeAdapter.castToType((Object)object, char[].class);
        }
        return ShortTypeHandling.castToString((Object)callSiteArray[9].callConstructor(String.class, (Object)apiKey));
    }

    @DirectMethod
    @Timed
    @ExceptionMetered
    @RequiresAuthentication
    @RequiresPermissions(value={"nexus:apikey:delete"})
    @Validate
    public String resetKey(@NotEmpty String authToken) {
        CallSite[] callSiteArray = NugetApiKeyComponent.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            callSiteArray[10].callCurrent((GroovyObject)this, (Object)authToken);
        } else {
            this.validateAuthToken(authToken);
        }
        Object principals = callSiteArray[11].callGetProperty(callSiteArray[12].call((Object)this.securityHelper));
        Object keyStore = callSiteArray[13].call(this.keyStore);
        callSiteArray[14].call(keyStore, callSiteArray[15].callGetProperty(NugetApiKeyExtractor.class), principals);
        char[] apiKey = (char[])ScriptBytecodeAdapter.castToType((Object)callSiteArray[16].call(keyStore, callSiteArray[17].callGetProperty(NugetApiKeyExtractor.class), principals), char[].class);
        return ShortTypeHandling.castToString((Object)callSiteArray[18].callConstructor(String.class, (Object)apiKey));
    }

    private void validateAuthToken(String authToken) {
        CallSite[] callSiteArray = NugetApiKeyComponent.$getCallSiteArray();
        callSiteArray[19].callStatic(Preconditions.class, (Object)authToken);
        callSiteArray[20].call(callSiteArray[21].callGroovyObjectGetProperty((Object)this), (Object)"Validating authentication ticket: {}", (Object)authToken);
        if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[22].call((Object)this.authTokens, (Object)authToken))) {
            throw (Throwable)callSiteArray[23].callConstructor(IllegalAccessException.class, (Object)"Invalid authentication ticket");
        }
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (((Object)((Object)this)).getClass() != NugetApiKeyComponent.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
        }
        return classInfo.getMetaClass();
    }

    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    public Provider<ApiKeyStore> getKeyStore() {
        return this.keyStore;
    }

    public void setKeyStore(Provider<ApiKeyStore> provider) {
        this.keyStore = provider;
    }

    public AuthTicketService getAuthTokens() {
        return this.authTokens;
    }

    public void setAuthTokens(AuthTicketService authTicketService) {
        this.authTokens = authTicketService;
    }

    public SecurityHelper getSecurityHelper() {
        return this.securityHelper;
    }

    public void setSecurityHelper(SecurityHelper securityHelper) {
        this.securityHelper = securityHelper;
    }

    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
        stringArray[0] = "validateAuthToken";
        stringArray[1] = "principals";
        stringArray[2] = "subject";
        stringArray[3] = "getApiKey";
        stringArray[4] = "get";
        stringArray[5] = "NAME";
        stringArray[6] = "createApiKey";
        stringArray[7] = "get";
        stringArray[8] = "NAME";
        stringArray[9] = "<$constructor$>";
        stringArray[10] = "validateAuthToken";
        stringArray[11] = "principals";
        stringArray[12] = "subject";
        stringArray[13] = "get";
        stringArray[14] = "deleteApiKey";
        stringArray[15] = "NAME";
        stringArray[16] = "createApiKey";
        stringArray[17] = "NAME";
        stringArray[18] = "<$constructor$>";
        stringArray[19] = "checkNotNull";
        stringArray[20] = "debug";
        stringArray[21] = "log";
        stringArray[22] = "redeemTicket";
        stringArray[23] = "<$constructor$>";
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[24];
        NugetApiKeyComponent.$createCallSiteArray_1(stringArray);
        return new CallSiteArray(NugetApiKeyComponent.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = NugetApiKeyComponent.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }
}

