/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.nuget.odata;

import com.google.common.base.Preconditions;
import java.util.Objects;

public final class FrameworkName {
    public static final String ASP_NET_FRAMEWORK = "ASP.Net";
    public static final String ASP_NET_CORE_FRAMEWORK = "ASP.NetCore";
    public static final String MONO_ANDROID_FRAMEWORK = "MonoAndroid";
    public static final String MONO_MAC_FRAMEWORK = "MonoMac";
    public static final String MONO_TOUCH_FRAMEWORK = "MonoTouch";
    public static final String NATIVE_FRAMEWORK = "native";
    public static final String NET_FRAMEWORK = ".NETFramework";
    public static final String NET_CORE_FRAMEWORK = ".NETCore";
    public static final String NET_MICRO_FRAMEWORK = ".NETMicroFramework";
    public static final String PORTABLE_FRAMEWORK = ".NETPortable";
    public static final String SILVERLIGHT_FRAMEWORK = "Silverlight";
    public static final String WINDOWS_PHONE_FRAMEWORK = "WindowsPhone";
    public static final String WINDOWS_PHONE_APP_FRAMEWORK = "WindowsPhoneApp";
    public static final String WINDOWS_FRAMEWORK = "Windows";
    public static final String XAMARIN_IOS_FRAMEWORK = "Xamarin.IOS";
    public static final String XAMARIN_MAC_FRAMEWORK = "Xamarin.Mac";
    public static final String XAMARIN_PS3_FRAMEWORK = "Xamarin.PlayStation3";
    public static final String XAMARIN_PS4_FRAMEWORK = "Xamarin.PlayStation4";
    public static final String XAMARIN_PSVITA_FRAMEWORK = "Xamarin.PlayStationVita";
    public static final String XAMARIN_XBOX360_FRAMEWORK = "Xamarin.Xbox360";
    public static final String XAMARIN_XBOXONE_FRAMEWORK = "Xamarin.XboxOne";
    public static final String XAMARIN_TVOS_FRAMEWORK = "Xamarin.TVOS";
    public static final String XAMARIN_WATCHOS_FRAMEWORK = "Xamarin.WatchOS";
    public static final String UNSUPPORTED_FRAMEWORK = "Unsupported";
    public static final String NET_CORE_APP_FRAMEWORK = ".NETCoreApp";
    public static final String NET_PLATFORM_FRAMEWORK = ".NETPlatform";
    public static final String NET_STANDARD_FRAMEWORK = ".NETStandard";
    public static final String NET_STANDARD_APP_FRAMEWORK = ".NETStandardApp";
    public static final String DNX_FRAMEWORK = "DNX";
    public static final String DNX_CORE_FRAMEWORK = "DNXCore";
    public static final String UAP_FRAMEWORK = "UAP";
    public static final String CLIENT_PROFILE = "Client";
    public static final String WINDOWS_PHONE_PROFILE = "WindowsPhone";
    public static final String WINDOWS_PHONE_71_PROFILE = "WindowsPhone71";
    public static final String COMPACT_PROFILE = "CompactFramework";
    public static final String FULL_PROFILE = "";
    public static final String DEFAULT_VERSION = "0.0.0.0";
    public static final FrameworkName UNSUPPORTED = new FrameworkName("Unsupported", "0.0.0.0", "");
    private final String identifier;
    private final String version;
    private final String profile;

    public FrameworkName(String identifier, String version, String profile) {
        this.identifier = (String)Preconditions.checkNotNull((Object)identifier);
        this.version = FrameworkName.normalizeVersion((String)Preconditions.checkNotNull((Object)version));
        this.profile = (String)Preconditions.checkNotNull((Object)profile);
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public String getVersion() {
        return this.version;
    }

    public String getProfile() {
        return this.profile;
    }

    private static String normalizeVersion(String version) {
        switch (version) {
            case "": 
            case "0.0": 
            case "0.0.0": 
            case "0.0.0.0": {
                return DEFAULT_VERSION;
            }
        }
        return version;
    }

    public int hashCode() {
        return Objects.hash(this.identifier, this.version, this.profile);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FrameworkName that = (FrameworkName)o;
        return Objects.equals(this.identifier, that.identifier) && Objects.equals(this.version, that.version) && Objects.equals(this.profile, that.profile);
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + "{" + "identifier=" + this.identifier + ", version=" + this.version + ", profile=" + this.profile + "}";
    }
}

