/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.nuget.odata;

import com.google.common.collect.ImmutableList;
import com.sonatype.nexus.repository.nuget.NugetPackageException;
import com.sonatype.nexus.repository.nuget.odata.FrameworkNameUtils;
import com.sonatype.nexus.repository.nuget.odata.XmlSplicer;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.codehaus.plexus.util.ReaderFactory;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

public final class NuspecSplicer
extends XmlSplicer {
    private static final List<String> ACCEPTED_TAGS = ImmutableList.of((Object)"id", (Object)"version", (Object)"authors", (Object)"description", (Object)"title", (Object)"releaseNotes", (Object)"summary", (Object)"tags", (Object)"projectUrl", (Object)"iconUrl", (Object)"licenseUrl", (Object)"copyright", (Object[])new String[]{"language", "requireLicenseAcceptance"});
    private static final String ID = "id";
    private static final String VERSION = "version";
    final Map<String, String> data = new HashMap<String, String>();
    private String currentTargetFramework = null;

    NuspecSplicer() {
        super(new StringBuilder());
    }

    public static Map<String, String> extractNuspecData(InputStream nuspecInputStream) throws XmlPullParserException, IOException {
        NuspecSplicer splicer = new NuspecSplicer();
        splicer.consume((Reader)ReaderFactory.newXmlReader((InputStream)nuspecInputStream));
        return splicer.populateItemData();
    }

    @Override
    void started(String name, int len, boolean isRoot) throws XmlPullParserException {
        if (isRoot && !"package".equals(name)) {
            throw new XmlPullParserException("Parsed xml has an unexpected start tag: '" + name + "' (expected 'package')");
        }
        if ("dependency".equals(name)) {
            this.processDependency();
        } else if ("group".equals(name)) {
            this.processGroup();
            if (this.xml.toString().endsWith("/>")) {
                this.processDependency();
            }
        }
        this.xml.setLength(0);
    }

    private void processDependency() {
        String deps = this.data.get("DEPENDENCIES");
        String targetFramework = this.currentTargetFramework == null ? "" : ":" + this.currentTargetFramework;
        String id = Objects.toString(this.getAttribute(ID), "");
        String version = Objects.toString(this.getAttribute(VERSION), "");
        String d = String.valueOf(id) + ':' + version + targetFramework;
        this.data.put("DEPENDENCIES", deps == null ? d : String.valueOf(deps) + '|' + d);
    }

    private void processGroup() throws XmlPullParserException {
        String targetFrameworkName = this.getAttribute("targetFramework");
        if (targetFrameworkName != null) {
            try {
                this.currentTargetFramework = FrameworkNameUtils.convertToShortName(targetFrameworkName);
            }
            catch (NugetPackageException pe) {
                throw new XmlPullParserException("Parsed xml has an invalid targetFramework attribute: '" + targetFrameworkName + "'", null, (Throwable)pe);
            }
        }
    }

    @Override
    void ended(String name, int len) {
        if (ACCEPTED_TAGS.contains(name)) {
            this.data.put(name.toUpperCase(Locale.ENGLISH), this.xml.substring(0, this.xml.length() - len));
        } else if ("group".equals(name)) {
            this.currentTargetFramework = null;
        }
    }

    private Map<String, String> populateItemData() throws XmlPullParserException {
        String id = this.data.get("ID");
        if (id == null || id.length() == 0) {
            throw new XmlPullParserException("Missing id");
        }
        String version = this.data.get("VERSION");
        if (version == null || version.length() == 0) {
            throw new XmlPullParserException("Missing version");
        }
        if (version.contains("-")) {
            this.data.put("ISPRERELEASE", "true");
        }
        if (!this.data.containsKey("TITLE")) {
            this.data.put("TITLE", id);
        }
        if (!this.data.containsKey("SUMMARY")) {
            this.data.put("SUMMARY", this.data.get("DESCRIPTION"));
        }
        if (!this.data.containsKey("REQUIRELICENSEACCEPTANCE")) {
            this.data.put("REQUIRELICENSEACCEPTANCE", "false");
        }
        return this.data;
    }
}

