/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.nuget.odata;

import java.io.IOException;
import java.io.Reader;
import org.codehaus.plexus.util.xml.pull.MXParser;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

abstract class XmlSplicer {
    private final MXParser parser = new MXParser();
    final StringBuilder xml;

    XmlSplicer(StringBuilder xml) {
        this.xml = xml;
    }

    final void consume(Reader reader) throws XmlPullParserException, IOException {
        int[] lim = new int[2];
        this.parser.setInput(reader);
        int level = 0;
        int event = this.parser.nextTag();
        while (event != 1) {
            if (event == 4 || event == 5) {
                if (!this.parser.isWhitespace()) {
                    this.xml.append(this.parser.getTextCharacters(lim), lim[0], lim[1]);
                }
            } else if (event == 6) {
                this.xml.append('&').append(this.parser.getTextCharacters(lim), lim[0], lim[1]).append(';');
            } else if (event == 2) {
                this.xml.append(this.parser.getTextCharacters(lim), lim[0], lim[1]);
                this.started(this.parser.getName(), lim[1], level == 0);
                if (this.parser.isEmptyElementTag()) {
                    event = this.parser.next();
                    this.ended(this.parser.getName(), 0);
                    if (level <= 0) {
                        break;
                    }
                } else {
                    ++level;
                }
            } else if (event == 3) {
                this.xml.append(this.parser.getTextCharacters(lim), lim[0], lim[1]);
                this.ended(this.parser.getName(), lim[1]);
                if (--level <= 0) break;
            }
            event = this.parser.nextToken();
        }
    }

    final String getAttribute(String name) {
        return this.parser.getAttributeValue(null, name);
    }

    abstract void started(String var1, int var2, boolean var3) throws XmlPullParserException;

    abstract void ended(String var1, int var2) throws XmlPullParserException;
}

