/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.nuget.repair;

import com.google.common.annotations.VisibleForTesting;
import com.sonatype.nexus.repository.nuget.NugetGalleryFacet;
import com.sonatype.nexus.repository.nuget.NugetPackageException;
import com.sonatype.nexus.repository.nuget.odata.NugetPackageUtils;
import com.sonatype.nexus.repository.nuget.odata.ODataFeedUtils;
import java.io.IOException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Map;
import java.util.Objects;
import java.util.stream.StreamSupport;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.blobstore.api.Blob;
import org.sonatype.nexus.common.time.Clock;
import org.sonatype.nexus.repository.Format;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.Type;
import org.sonatype.nexus.repository.manager.RepositoryManager;
import org.sonatype.nexus.repository.repair.RepairMetadataComponent;
import org.sonatype.nexus.repository.storage.Asset;
import org.sonatype.nexus.repository.storage.AssetEntityAdapter;
import org.sonatype.nexus.repository.storage.StorageTx;

@Named
@Singleton
public class NugetAttributeRepairComponent
extends RepairMetadataComponent {
    private final DateFormat inputDateFormat = new SimpleDateFormat("EEE MMM dd HH:mm:ss zzz yyyy");
    private final DateFormat outputDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");
    @VisibleForTesting
    protected Clock clock = new Clock();

    @Inject
    public NugetAttributeRepairComponent(RepositoryManager repositoryManager, AssetEntityAdapter assetEntityAdapter, @Named(value="hosted") Type hostedType, @Named(value="nuget") Format nugetFormat) {
        super(repositoryManager, assetEntityAdapter, hostedType, nugetFormat);
    }

    public void repair() {
        this.log.info("Beginning processing all Nuget packages for repair");
        StreamSupport.stream(this.repositoryManager.browse().spliterator(), false).filter(r -> r.getFormat().equals((Object)this.format) && r.getType().equals((Object)this.type)).forEach(arg_0 -> ((NugetAttributeRepairComponent)this).doRepairRepository(arg_0));
    }

    protected void updateAsset(Repository repository, StorageTx tx, Asset asset) {
        Blob blob = tx.getBlob(asset.blobRef());
        if (blob != null) {
            this.updateAsset(repository, asset, blob);
        }
    }

    private void updateAsset(Repository repository, Asset asset, Blob blob) {
        try {
            Map<String, String> nuspec = NugetPackageUtils.packageMetadata(blob.getInputStream());
            this.maintainTimestamps(asset, nuspec);
            ((NugetGalleryFacet)repository.facet(NugetGalleryFacet.class)).putMetadata(nuspec);
        }
        catch (NugetPackageException | IOException e) {
            this.log.error("Failed to repair asset {}", (Object)asset.name(), (Object)e);
        }
    }

    private void maintainTimestamps(Asset asset, Map<String, String> nuspec) {
        String creationTime = ODataFeedUtils.datetime(this.clock.millis());
        String created = Objects.toString(asset.formatAttributes().get("created"), creationTime);
        String published = Objects.toString(asset.formatAttributes().get("published"), creationTime);
        String lastUpdated = Objects.toString(asset.formatAttributes().get("last_updated"), creationTime);
        nuspec.put("CREATED", this.parseDate(created, creationTime));
        nuspec.put("PUBLISHED", this.parseDate(published, creationTime));
        nuspec.put("LASTUPDATED", this.parseDate(lastUpdated, creationTime));
    }

    private String parseDate(String created, String defaultValue) {
        try {
            return this.outputDateFormat.format(this.inputDateFormat.parse(created));
        }
        catch (ParseException e) {
            this.log.error("", (Throwable)e);
            return defaultValue;
        }
    }
}

