/*
 * Decompiled with CFR 0.152.
 */
package com.exe4j;

import com.exe4j.runtime.WinLauncher;
import com.exe4j.runtime.splash.SplashEngine;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.EventListener;
import java.util.Stack;

public class Controller {
    private static final int MAX_STORED_STARTUPS = Integer.getInteger("install4j.maxStoredStartups", 50000);
    private static StartupListener startupListener;
    private static boolean startupThreadStarted;
    private static Stack<String> performedStartups;

    public static void writeMessage(String message) throws ConnectionException {
        try {
            SplashEngine.writeMessage(message);
        }
        catch (Exception e) {
            throw new ConnectionException(e);
        }
    }

    public static void hide() throws ConnectionException {
        try {
            SplashEngine.hide();
        }
        catch (Exception e) {
            throw new ConnectionException(e);
        }
    }

    public static synchronized void registerStartupListener(StartupListener startupListener) {
        Controller.startupListener = startupListener;
        if (!startupThreadStarted && WinLauncher.LEGACY_PROCESS_COMM_FILE_NAME != null) {
            startupThreadStarted = true;
            new LegacyStartupThread().start();
        }
        if (startupListener != null) {
            while (!performedStartups.empty()) {
                startupListener.startupPerformed(performedStartups.pop());
            }
        }
    }

    private Controller() {
    }

    private static synchronized void startupPerformed(String str) {
        if (str == null) {
            str = "";
        }
        if (startupListener != null) {
            startupListener.startupPerformed(str);
        } else if (str.length() > 0 && performedStartups.size() < MAX_STORED_STARTUPS) {
            performedStartups.push(str);
        }
    }

    static {
        startupThreadStarted = false;
        performedStartups = new Stack();
    }

    private static class LegacyStartupThread
    extends Thread {
        private File processCommFile = new File(WinLauncher.LEGACY_PROCESS_COMM_FILE_NAME);

        public LegacyStartupThread() {
            super("Exe4JStartupThread");
            this.setDaemon(true);
        }

        @Override
        public void run() {
            long lastModified = 0L;
            int shortWaitCount = 0;
            while (true) {
                if (this.processCommFile.exists() && lastModified != this.processCommFile.lastModified()) {
                    lastModified = this.processCommFile.lastModified();
                    try {
                        String parameters;
                        while (true) {
                            try {
                                BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.processCommFile), "UTF-16LE"));
                                parameters = reader.readLine();
                                reader.close();
                            }
                            catch (IOException e) {
                                continue;
                            }
                            break;
                        }
                        if (startupListener != null) {
                            final String parametersFinal = parameters;
                            new Thread(){

                                @Override
                                public void run() {
                                    startupListener.startupPerformed(parametersFinal);
                                }
                            }.start();
                            shortWaitCount = 15;
                        } else if (parameters != null) {
                            performedStartups.add(parameters);
                        }
                        while (this.processCommFile.exists() && !this.processCommFile.delete()) {
                            try {
                                LegacyStartupThread.sleep(100L);
                            }
                            catch (InterruptedException e) {}
                        }
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                    }
                }
                try {
                    if (shortWaitCount > 0) {
                        LegacyStartupThread.sleep(30L);
                        --shortWaitCount;
                        continue;
                    }
                    if (startupListener != null) {
                        LegacyStartupThread.sleep(300L);
                        continue;
                    }
                    LegacyStartupThread.sleep(3000L);
                }
                catch (InterruptedException e) {
                }
            }
        }
    }

    public static interface StartupListener
    extends EventListener {
        public void startupPerformed(String var1);
    }

    public static class ConnectionException
    extends Exception {
        private ConnectionException(Exception e) {
            super(e.getMessage());
        }
    }
}

