/*
 * Decompiled with CFR 0.152.
 */
package com.exe4j.runtime.util;

import com.exe4j.runtime.util.ReadIOException;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PushbackInputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.Iterator;
import java.util.zip.GZIPInputStream;

public class FileUtil {
    private static final int BUFFER_SIZE = 8192;

    private FileUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean copyFile(File sourceFile, File targetFile) throws IOException {
        FileInputStream fis = null;
        FileOutputStream fos = null;
        try {
            fis = new FileInputStream(sourceFile);
            fos = new FileOutputStream(targetFile);
            boolean bl = FileUtil.pumpStream(fis, fos) != -1L;
            return bl;
        }
        finally {
            if (fis != null) {
                fis.close();
            }
            if (fos != null) {
                fos.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean extractFile(InputStream in, File targetFile, long length, CopyProgressListener copyProgressListener, boolean checkReadIoException) throws IOException {
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(targetFile);
            boolean bl = FileUtil.pumpStream(in, length, fos, copyProgressListener, checkReadIoException) > -1L;
            return bl;
        }
        finally {
            if (fos != null) {
                fos.close();
            }
        }
    }

    public static void emptyDirectory(File dir) {
        File[] files = dir.listFiles();
        if (files == null) {
            return;
        }
        for (File file : files) {
            if (file.isDirectory()) {
                FileUtil.deleteDirectory(file);
                file.delete();
                continue;
            }
            file.delete();
        }
    }

    public static void deleteDirectory(File dir) {
        FileUtil.emptyDirectory(dir);
        dir.delete();
    }

    public static void copyDirectory(File sourceDir, File targetDir, boolean recursive) throws IOException {
        FileUtil.copyDirectory(sourceDir, targetDir, recursive, null, null);
    }

    public static void copyDirectory(File sourceDir, File targetDir, boolean recursive, Collection excludeSuffixes, Collection excludeFiles) throws IOException {
        File[] files = sourceDir.listFiles();
        if (files == null) {
            return;
        }
        for (File file : files) {
            File sourceFile = new File(sourceDir, file.getName()).getCanonicalFile();
            if (excludeFiles != null && excludeFiles.contains(sourceFile)) continue;
            File targetFile = new File(targetDir, sourceFile.getName());
            if (sourceFile.isDirectory() && recursive) {
                if (!targetFile.exists() && !targetFile.mkdirs()) {
                    throw new IOException("Cannot create " + targetDir.getPath());
                }
                FileUtil.copyDirectory(sourceFile, targetFile, true, excludeSuffixes, excludeFiles);
                continue;
            }
            boolean excluded = false;
            if (excludeSuffixes != null) {
                Iterator it = excludeSuffixes.iterator();
                while (it.hasNext() && !excluded) {
                    String suffix = ((String)it.next()).toLowerCase();
                    if (!sourceFile.getName().toLowerCase().endsWith(suffix)) continue;
                    excluded = true;
                }
            }
            if (excluded) continue;
            FileUtil.copyFile(sourceFile, targetFile);
        }
    }

    public static long pumpCharStream(Reader reader, Writer writer) throws IOException {
        int c;
        long count = 0L;
        while ((c = reader.read()) != -1) {
            if (writer != null) {
                writer.write(c);
            }
            ++count;
        }
        if (writer != null) {
            writer.flush();
        }
        return count;
    }

    public static long pumpStream(InputStream is, OutputStream os) throws IOException {
        return FileUtil.pumpStream(is, os, null);
    }

    public static long pumpStream(InputStream is, OutputStream os, CopyProgressListener copyProgressListener) throws IOException {
        return FileUtil.pumpStream(is, os, copyProgressListener, false);
    }

    public static long pumpStream(InputStream is, OutputStream os, CopyProgressListener copyProgressListener, boolean checkReadIoException) throws IOException {
        return FileUtil.pumpStream(is, -1L, os, copyProgressListener, checkReadIoException);
    }

    public static long pumpStream(InputStream is, long length, OutputStream os, CopyProgressListener copyProgressListener, boolean checkReadIoException) throws IOException {
        int currentCount;
        if (length > 819200L && !(is instanceof BufferedInputStream)) {
            is = new BufferedInputStream(is, 8192);
        }
        if (length > 819200L && !(os instanceof BufferedOutputStream)) {
            os = new BufferedOutputStream(os, 8192);
        }
        byte[] buf = new byte[8192];
        long count = 0L;
        try {
            currentCount = is.read(buf);
        }
        catch (RuntimeException e) {
            if (checkReadIoException) {
                throw new ReadIOException(e);
            }
            throw e;
        }
        catch (IOException e) {
            if (checkReadIoException) {
                throw new ReadIOException(e);
            }
            throw e;
        }
        while (currentCount != -1) {
            os.write(buf, 0, currentCount);
            count += (long)currentCount;
            if (copyProgressListener != null && !copyProgressListener.progressPerformed(currentCount)) {
                return -1L;
            }
            try {
                currentCount = is.read(buf);
            }
            catch (RuntimeException e) {
                if (checkReadIoException) {
                    throw new ReadIOException(e);
                }
                throw e;
            }
            catch (IOException e) {
                if (checkReadIoException) {
                    throw new ReadIOException(e);
                }
                throw e;
            }
        }
        os.flush();
        return count;
    }

    public static void rename(File tempFile, File destFile) throws IOException {
        int tryNum = 0;
        while (!tempFile.renameTo(destFile)) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (destFile.exists()) {
                destFile.delete();
            }
            if (tryNum > 20) {
                throw new IOException("could not rename " + tempFile + " to " + destFile);
            }
            ++tryNum;
        }
    }

    public static boolean isContainedInOrEquals(File file, File parent) {
        try {
            while (file != null) {
                if (file.getCanonicalFile().equals(parent.getCanonicalFile())) {
                    return true;
                }
                file = file.getParentFile();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readTextFile(File file, String encoding) throws IOException {
        BufferedReader reader = null;
        try {
            int character;
            reader = FileUtil.createTextFileReader(file, encoding);
            StringWriter stringWriter = new StringWriter();
            while ((character = ((Reader)reader).read()) != -1) {
                stringWriter.write(character);
            }
            String string = stringWriter.toString();
            return string;
        }
        finally {
            if (reader != null) {
                ((Reader)reader).close();
            }
        }
    }

    public static BufferedReader createTextFileReader(File file, String encoding) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(file);
        PushbackInputStream pushbackInputStream = new PushbackInputStream(fileInputStream, 2);
        byte[] signature = new byte[2];
        pushbackInputStream.read(signature);
        pushbackInputStream.unread(signature);
        FilterInputStream sourceInputStream = FileUtil.isGzipStream(signature) ? new GZIPInputStream(pushbackInputStream) : pushbackInputStream;
        InputStreamReader inputStreamReader = encoding == null || encoding.isEmpty() ? new InputStreamReader(sourceInputStream) : new InputStreamReader((InputStream)sourceInputStream, encoding);
        return new BufferedReader(inputStreamReader);
    }

    public static boolean isGzipStream(byte[] bytes) {
        int head = bytes[0] & 0xFF | bytes[1] << 8 & 0xFF00;
        return head == 35615;
    }

    public static interface CopyProgressListener {
        public boolean progressPerformed(long var1);
    }
}

