/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.api.windows;

import com.install4j.api.Util;
import com.install4j.api.context.UserCanceledException;
import com.install4j.api.windows.DriveType;
import com.install4j.api.windows.ShowCommand;
import com.install4j.api.windows.SpecialFolder;
import com.install4j.runtime.installer.helper.MenuHelper;
import com.install4j.runtime.installer.helper.comm.ExecutionContext;
import com.install4j.runtime.installer.platform.win32.FolderInfo;
import com.install4j.runtime.installer.platform.win32.Misc;
import com.install4j.runtime.installer.platform.win32.ShellLink;
import java.io.File;
import java.io.IOException;

public class WinFileSystem {
    public static File getSpecialFolder(SpecialFolder folderType, boolean allUsers) {
        return FolderInfo.getSpecialFolder(folderType.getIntValue(), allUsers);
    }

    public static File getProgramFilesDirectory() {
        return FolderInfo.getProgramFilesDirectory();
    }

    public static File getCommonFilesDirectory() {
        return FolderInfo.getCommonFilesDirectory();
    }

    public static File getProgramDataDirectory() {
        return FolderInfo.getProgramDataDirectory();
    }

    public static File getWindowsDirectory() {
        return FolderInfo.getWindowsDirectory();
    }

    public static File getSystemDirectory() {
        return FolderInfo.getSystemDirectory();
    }

    public static boolean createShellLink(File file, File shortcutTo, File iconFile) {
        return WinFileSystem.createShellLink(file, shortcutTo, iconFile, null, null);
    }

    public static boolean createShellLink(File file, File shortcutTo, File iconFile, String arguments) {
        return WinFileSystem.createShellLink(file, shortcutTo, iconFile, arguments, null);
    }

    public static boolean createShellLink(File file, File shortcutTo, File iconFile, String arguments, String description) {
        return WinFileSystem.createShellLink(file, shortcutTo, iconFile, arguments, description, null);
    }

    public static boolean createShellLink(File file, File shortcutTo, File iconFile, String arguments, String description, File startIn) {
        return WinFileSystem.createShellLink(file, shortcutTo, iconFile, arguments, description, startIn, ShowCommand.NORMAL);
    }

    public static boolean createShellLink(File file, File shortcutTo, File iconFile, String arguments, String description, File startIn, ShowCommand showCommand) {
        ShellLink.initialize();
        boolean success = ShellLink.create(file, shortcutTo, iconFile, arguments, false, description, startIn, WinFileSystem.getShowCommandInt(showCommand));
        ShellLink.uninitialize();
        return success;
    }

    private static int getShowCommandInt(ShowCommand showCommand) {
        if (showCommand != null) {
            switch (showCommand) {
                case MAXIMIZED: {
                    return 3;
                }
                case MINIMIZED: {
                    return 7;
                }
            }
        }
        return 1;
    }

    public static void createStartMenuEntry(String programGroupName, String entryName, File destination, boolean allUsers, File icon) throws IOException {
        WinFileSystem.createStartMenuEntry(programGroupName, entryName, destination, allUsers, icon, null);
    }

    public static void createStartMenuEntry(String programGroupName, String entryName, File destination, boolean allUsers, File icon, String arguments) throws IOException {
        WinFileSystem.createStartMenuEntry(programGroupName, entryName, destination, allUsers, icon, arguments, false);
    }

    public static void createStartMenuEntry(String programGroupName, String entryName, File destination, boolean allUsers, File icon, String arguments, boolean runAsAdministrator) throws IOException {
        File groupDir = new File(FolderInfo.getSpecialFolder(3, allUsers), programGroupName);
        File menuFile = new File(groupDir, entryName);
        try {
            MenuHelper.installWindowsMenu(allUsers ? ExecutionContext.MAXIMUM : ExecutionContext.UNELEVATED, menuFile, destination, icon, arguments, runAsAdministrator, null);
        }
        catch (UserCanceledException e) {
            e.printStackTrace();
            throw new IOException(e.toString());
        }
    }

    public static boolean moveWithDelayUntilReboot(File source, File destination) {
        return Misc.moveWithDelayUntilReboot(source, destination);
    }

    public static DriveType getDriveType(File file) {
        String path;
        if (Util.isWindows() && (path = file.getAbsolutePath()).length() >= 3 && !path.startsWith("\\")) {
            return DriveType.getFromIntValue(FolderInfo.getDriveType(path.substring(0, 3)));
        }
        return DriveType.UNKNOWN;
    }

    private WinFileSystem() {
    }
}

