/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans;

import com.install4j.api.actions.AutoUninstallAction;
import com.install4j.runtime.installer.helper.XmlHelper;
import com.install4j.runtime.installer.helper.fileinst.FileInstaller;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class AutoUninstallHandler {
    private static final String AUTO_UNINSTALL_FILE_PREFIX = "autoUninstall.";
    private static final String ELEMENT_ROOT = "autoUninstall";
    private static final String ELEMENT_ACTION = "action";
    private static final String ELEMENT_PROPERTY = "property";
    private static final String ATTRIBUTE_CLASS_NAME = "className";
    private static final String ATTRIBUTE_NAME = "name";
    private static final String ATTRIBUTE_VALUE = "value";

    public static byte[] getPropertyFileBytes(List autoUninstallActions) throws IOException {
        if (autoUninstallActions.size() == 0) {
            return null;
        }
        Document document = XmlHelper.createDocument();
        Element root = document.createElement(ELEMENT_ROOT);
        document.appendChild(root);
        for (int i = autoUninstallActions.size() - 1; i >= 0; --i) {
            AutoUninstallAction autoUninstallAction = (AutoUninstallAction)autoUninstallActions.get(i);
            Element child = document.createElement(ELEMENT_ACTION);
            child.setAttribute(ATTRIBUTE_CLASS_NAME, autoUninstallAction.getClass().getName());
            Properties properties = autoUninstallAction.getPersistentProperties();
            for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                Element propElement = document.createElement(ELEMENT_PROPERTY);
                propElement.setAttribute(ATTRIBUTE_NAME, (String)entry.getKey());
                propElement.setAttribute(ATTRIBUTE_VALUE, (String)entry.getValue());
                child.appendChild(propElement);
            }
            root.appendChild(child);
        }
        return XmlHelper.getBytes(document);
    }

    public static void writeFile(byte[] bytes, File runtimeDirectory) throws IOException {
        if (bytes != null) {
            File autoUninstallFile;
            int i = 0;
            while ((autoUninstallFile = new File(runtimeDirectory, AUTO_UNINSTALL_FILE_PREFIX + i++)).exists()) {
            }
            FileOutputStream out = new FileOutputStream(autoUninstallFile);
            out.write(bytes);
            out.close();
            FileInstaller.getInstance().registerUninstallFile(autoUninstallFile);
        }
    }

    public static List<AutoUninstallAction> getAutoUninstallActions(File runtimeDirectory) throws IOException {
        ArrayList<Integer> autoUninstallFileNumbers = new ArrayList<Integer>();
        File[] files = runtimeDirectory.listFiles();
        if (files != null) {
            for (File file : files) {
                String name = file.getName();
                if (!name.startsWith(AUTO_UNINSTALL_FILE_PREFIX)) continue;
                try {
                    int number = Integer.parseInt(name.substring(AUTO_UNINSTALL_FILE_PREFIX.length()));
                    autoUninstallFileNumbers.add(number);
                }
                catch (NumberFormatException e) {
                    e.printStackTrace();
                }
            }
        }
        Collections.sort(autoUninstallFileNumbers);
        ArrayList<AutoUninstallAction> autoUninstallActions = new ArrayList<AutoUninstallAction>();
        for (int i = autoUninstallFileNumbers.size() - 1; i >= 0; --i) {
            int number = (Integer)autoUninstallFileNumbers.get(i);
            File autoUninstallFile = new File(runtimeDirectory, AUTO_UNINSTALL_FILE_PREFIX + number);
            AutoUninstallHandler.addAutoUninstallActionsFromFile(autoUninstallFile, autoUninstallActions);
        }
        return autoUninstallActions;
    }

    private static void addAutoUninstallActionsFromFile(File autoUninstallFile, List<AutoUninstallAction> actions) throws IOException {
        Element root = XmlHelper.parseFile(autoUninstallFile).getDocumentElement();
        for (Element actionElement : XmlHelper.childElements(root)) {
            AutoUninstallAction autoUninstallAction;
            block4: {
                autoUninstallAction = null;
                try {
                    autoUninstallAction = (AutoUninstallAction)Class.forName(actionElement.getAttribute(ATTRIBUTE_CLASS_NAME)).newInstance();
                }
                catch (Throwable t) {
                    if (!Boolean.getBoolean("install4j.debugAutoUninstall")) break block4;
                    t.printStackTrace();
                }
            }
            if (autoUninstallAction == null) continue;
            Properties properties = new Properties();
            for (Element propertyElement : XmlHelper.childElements(actionElement)) {
                properties.setProperty(propertyElement.getAttribute(ATTRIBUTE_NAME), propertyElement.getAttribute(ATTRIBUTE_VALUE));
            }
            autoUninstallAction.setPersistentProperties(properties);
            actions.add(autoUninstallAction);
        }
    }
}

