/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.actions;

import com.install4j.api.actions.AutoUninstallAction;
import com.install4j.api.context.Context;
import com.install4j.api.context.ProgressInterface;
import com.install4j.api.context.UninstallerContext;
import com.install4j.api.context.UserCanceledException;
import com.install4j.runtime.beans.AutoUninstallHandler;
import com.install4j.runtime.beans.actions.SystemUninstallAction;
import com.install4j.runtime.installer.config.InstallerConfig;
import com.install4j.runtime.installer.frontend.Messages;
import com.install4j.runtime.installer.helper.InstallerUtil;
import com.install4j.runtime.installer.helper.Logger;
import com.install4j.runtime.installer.helper.RunningProcessChecker;
import com.install4j.runtime.installer.helper.ServiceHandler;
import com.install4j.runtime.installer.helper.comm.ExecutionContext;
import com.install4j.runtime.installer.helper.comm.HelperCommunication;
import com.install4j.runtime.installer.helper.comm.actions.FetchBooleanAction;
import com.install4j.runtime.installer.helper.content.JreInstaller;
import com.install4j.runtime.installer.helper.fileinst.FileInstaller;
import com.install4j.runtime.installer.helper.registry.InstallRegistry;
import java.io.IOException;
import java.util.List;

public class UninstallFilesAction
extends SystemUninstallAction {
    @Override
    public boolean uninstall(UninstallerContext context) throws UserCanceledException {
        ServiceHandler.stopServices(context, false);
        String uninstallMessage = Messages.format(context.getMessage("StatusUninstalling"), InstallerConfig.getCurrentInstance().getApplicationNameWithVersion());
        ProgressInterface progressInterface = context.getProgressInterface();
        progressInterface.setDetailMessage("");
        progressInterface.setStatusMessage(uninstallMessage);
        if (!RunningProcessChecker.checkDefaultRunningLauncher("AppRunningError")) {
            throw new UserCanceledException();
        }
        progressInterface.setDetailMessage("");
        progressInterface.setStatusMessage(uninstallMessage);
        if (!UninstallFilesAction.executeAutoUninstallActions()) {
            return false;
        }
        progressInterface.setDetailMessage("");
        progressInterface.setStatusMessage(uninstallMessage);
        InstallerConfig config = InstallerConfig.getCurrentInstance();
        InstallRegistry.unregisterApplication(config.getApplicationId(), context.getInstallationDirectory());
        JreInstaller.getInstance().prepareUninstall(context);
        FileInstaller fileInstaller = FileInstaller.getInstance();
        try {
            for (String fileName : config.getUninstallDeleteEntries()) {
                fileInstaller.deleteFile(context.getDestinationFile(fileName));
            }
            fileInstaller.uninstall(context.isUninstallForUpgrade());
        }
        catch (IOException e) {
            context.handleCriticalException(e);
        }
        if (!InstallerUtil.isWindows() && !InstallerUtil.isMacOS()) {
            try {
                Runtime.getRuntime().exec("kbuildsycoca");
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        if (InstallerUtil.isMacOS()) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        return true;
    }

    private static boolean executeAutoUninstallActions() {
        return HelperCommunication.getInstance().fetchBoolean(ExecutionContext.MAXIMUM, new FetchBooleanAction(){

            @Override
            protected boolean fetchValue(Context context) throws Exception {
                try {
                    List<AutoUninstallAction> autoUninstallActions = AutoUninstallHandler.getAutoUninstallActions(context.getDestinationFile(".install4j"));
                    for (AutoUninstallAction autoUninstallAction : autoUninstallActions) {
                        Logger.getInstance().info(autoUninstallAction, "executing auto uninstall");
                        try {
                            if (autoUninstallAction.uninstall((UninstallerContext)context)) continue;
                            Logger.getInstance().error(autoUninstallAction, "auto-uninstall action failed");
                        }
                        catch (UserCanceledException e) {
                            return false;
                        }
                        catch (Throwable t) {
                            Logger.getInstance().error(autoUninstallAction, "auto-uninstall action exception:");
                            Logger.getInstance().log(t);
                        }
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                return true;
            }
        });
    }
}

