/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.actions.files;

import com.install4j.api.Util;
import com.install4j.api.context.Context;
import com.install4j.api.context.ProgressInterface;
import com.install4j.api.context.UserCanceledException;
import com.install4j.api.unix.UnixFileSystem;
import com.install4j.runtime.beans.actions.files.AbstractFileAction;
import com.install4j.runtime.installer.frontend.ProgressAdapter;
import java.io.File;
import java.io.IOException;

public abstract class AbstractRecursiveFileAction
extends AbstractFileAction {
    private boolean recursive;
    private boolean showProgress = false;
    private boolean showFileNames = true;
    private transient long maxProgress;
    private transient long currentProgress;

    public boolean isRecursive() {
        return this.recursive;
    }

    public void setRecursive(boolean recursive) {
        this.recursive = recursive;
    }

    public boolean isShowProgress() {
        return this.showProgress;
    }

    public void setShowProgress(boolean showProgress) {
        this.showProgress = showProgress;
    }

    public boolean isShowFileNames() {
        return this.showFileNames;
    }

    public void setShowFileNames(boolean showFileNames) {
        this.showFileNames = showFileNames;
    }

    protected abstract boolean executeForSingleRecursiveFile(Context var1, File var2, File var3, ProgressAdapter var4) throws UserCanceledException, IOException;

    protected boolean postProcessDirectory(Context context, File file) throws UserCanceledException {
        return true;
    }

    protected boolean postProcessTopLevelFile(Context context, File file) throws UserCanceledException {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean executeForMultipleFilesAction(Context context, File[] files) throws UserCanceledException {
        ProgressInterface progressInterface = context.getProgressInterface();
        if (this.showProgress) {
            this.currentProgress = 0L;
            progressInterface.setPercentCompleted(0);
            progressInterface.setDetailMessage("");
            this.maxProgress = 0L;
            for (File file : files) {
                File usedFile = context.getDestinationFile(file);
                if (!usedFile.exists()) continue;
                this.maxProgress += this.getMaxProgressForSingleFile(usedFile, context);
            }
        }
        try {
            boolean bl = super.executeForMultipleFilesAction(context, files);
            return bl;
        }
        finally {
            if (this.showProgress) {
                progressInterface.setPercentCompleted(100);
                progressInterface.setDetailMessage("");
            }
        }
    }

    @Override
    protected final boolean executeForSingleFile(Context context, File file) throws UserCanceledException, IOException {
        File relativeSourceFile = !file.isDirectory() || this.isAddTopLevelDirectoriesToRelativePath() ? new File(file.getName()) : new File(".");
        return this.executeForSingleFile(context, file, relativeSourceFile) && this.postProcessTopLevelFile(context, file);
    }

    protected boolean isAddTopLevelDirectoriesToRelativePath() {
        return true;
    }

    private boolean executeForSingleFile(Context context, File file, File relativeSourceFile) throws UserCanceledException, IOException {
        if (this.passesFileOrDirectoryFilter(file, context)) {
            ProgressInterface progressInterface = context.getProgressInterface();
            ProgressAdapter progressAdapter = null;
            long thisProgress = 153600L + (file.isFile() ? file.length() : 0L);
            if (this.showProgress) {
                if (this.showFileNames) {
                    progressInterface.setDetailMessage(file.getName());
                }
                if (file.isFile()) {
                    progressAdapter = new ProgressAdapter(progressInterface, (int)(this.currentProgress * 100L / this.maxProgress), (int)((this.currentProgress + thisProgress) * 100L / this.maxProgress));
                }
            }
            if (!this.executeForSingleRecursiveFile(context, file, relativeSourceFile, progressAdapter)) {
                return false;
            }
            this.currentProgress += thisProgress;
            if (this.showProgress) {
                progressInterface.setPercentCompleted((int)(this.currentProgress * 100L / this.maxProgress));
            }
            if (file.isDirectory()) {
                if (this.isRecursive() && !this.recurse(context, file, relativeSourceFile)) {
                    return false;
                }
                if (!this.postProcessDirectory(context, file)) {
                    return false;
                }
            }
        }
        return true;
    }

    private boolean recurse(Context context, File file, File relativeSourceFile) throws IOException, UserCanceledException {
        File[] children;
        boolean success = true;
        if (file.isDirectory() && this.followDir(file) && (children = file.listFiles()) != null) {
            for (File child : children) {
                File relativeChildSourceFile;
                if (child == null || this.executeForSingleFile(context, child, relativeChildSourceFile = new File(relativeSourceFile, child.getName()))) continue;
                success = false;
            }
        }
        return success;
    }

    private boolean followDir(File usedFile) {
        if (Util.isWindows()) {
            return true;
        }
        UnixFileSystem.FileInformation info = UnixFileSystem.getFileInformation(usedFile);
        if (info == null) {
            return true;
        }
        return !info.isLink();
    }

    private long getMaxProgressForSingleFile(File sourceFile, Context context) {
        if (!this.passesFileOrDirectoryFilter(sourceFile, context) || !sourceFile.exists()) {
            return 0L;
        }
        long ret = 153600L;
        if (sourceFile.isDirectory()) {
            File[] children = sourceFile.listFiles();
            if (children != null) {
                for (File child : children) {
                    ret += this.getMaxProgressForSingleFile(child, context);
                }
            }
        } else {
            ret += sourceFile.length();
        }
        return ret;
    }
}

