/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.actions.misc;

import com.exe4j.runtime.util.WinDel;
import com.install4j.api.Util;
import com.install4j.api.context.Context;
import com.install4j.api.context.InstallerContext;
import com.install4j.api.context.UserCanceledException;
import com.install4j.runtime.beans.actions.SystemInstallOrUninstallAction;
import com.install4j.runtime.beans.applications.ApplicationWithPath;
import com.install4j.runtime.beans.applications.InstallerApplication;
import com.install4j.runtime.installer.config.InstallerConfig;
import com.install4j.runtime.installer.frontend.Messages;
import com.install4j.runtime.installer.frontend.SplashProgressInterface;
import com.install4j.runtime.installer.frontend.WizardScreenExecutor;
import com.install4j.runtime.installer.helper.InstallerUtil;
import com.install4j.runtime.installer.helper.apiimpl.ApplicationLauncherImpl;
import com.install4j.runtime.installer.helper.comm.HelperCommunication;
import com.install4j.runtime.installer.platform.macos.MacosUserInfo;
import com.install4j.runtime.installer.platform.win32.Win32UserInfo;
import com.install4j.runtime.launcher.SwingWindowChecker;
import java.awt.EventQueue;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import javax.swing.SwingUtilities;

public abstract class AbstractPrivilegesAction
extends SystemInstallOrUninstallAction {
    private static boolean helperStarted = false;

    protected boolean startOnMac(Context context) {
        if (!Util.isMacosInstaller()) {
            return false;
        }
        if (helperStarted) {
            return true;
        }
        HelperCommunication helperCommunication = HelperCommunication.getInstance();
        String identifier = helperCommunication.createListener();
        if (identifier == null) {
            return false;
        }
        StringBuilder arguments = new StringBuilder();
        arguments.append(System.getProperty("install4j.helperMaxHeap", "-Xmx128m"));
        arguments.append(" -classpath \"").append(System.getProperty("java.class.path")).append("\"");
        arguments.append(" -Duser.language=").append(context.getLanguageId());
        arguments.append(" -Dinstall4j.language=").append(context.getLanguageId());
        arguments.append(" -Dinstall4j.systemLanguage=").append(System.getProperty("install4j.systemLanguage"));
        arguments.append(" -Dinstall4j.commIdentifier=").append(identifier);
        arguments.append(" -Dinstall4j.helperAppId=").append(InstallerConfig.getCurrentApplicationId());
        arguments.append(" -Dinstall4j.helperLog=").append(Boolean.getBoolean("install4j.helperLog"));
        if (System.getProperty("exe4j.moduleName") != null) {
            arguments.append(" \"-Dexe4j.moduleName=").append(System.getProperty("exe4j.moduleName")).append("\"");
        }
        if (System.getProperty("i4j.jreBundle") != null) {
            arguments.append(" \"-Di4j.jreBundle=").append(System.getProperty("i4j.jreBundle")).append("\"");
        }
        if (System.getProperty("i4j.tarFile") != null) {
            arguments.append(" \"-Di4j.tarFile=").append(System.getProperty("i4j.tarFile")).append("\"");
        }
        arguments.append(" -Dapple.awt.UIElement=true");
        arguments.append(" ").append(HelperCommunication.class.getName());
        boolean bl = helperStarted = MacosUserInfo.executeElevated(new File(System.getProperty("java.home"), "bin/java").getAbsolutePath(), arguments.toString(), System.getProperty("user.dir"), null) && helperCommunication.connect();
        if (helperStarted) {
            context.setVariable("sys.adminRights", Boolean.TRUE);
        }
        return helperStarted;
    }

    @Override
    public boolean isRollbackSupported() {
        return false;
    }

    protected boolean startOnWindows(Context context) {
        if (!Util.isAtLeastWindowsVista()) {
            return false;
        }
        if (helperStarted) {
            return true;
        }
        if (Win32UserInfo.isUACDisabled()) {
            return false;
        }
        String moduleName = this.getModuleName();
        if (moduleName == null) {
            return true;
        }
        if (!new File(moduleName).exists()) {
            Util.showMessage(Messages.format(Messages.getMessages().getString("ErrorInternal2"), "Could not start elevated: " + moduleName), 0);
            return false;
        }
        HelperCommunication helperCommunication = HelperCommunication.getInstance();
        String identifier = helperCommunication.createListener();
        if (identifier == null) {
            return false;
        }
        SplashProgressInterface splashProgressInterface = this.checkSplashScreen(context);
        InstallerUtil.storeJreInfoForInstaller();
        String maxHeap = System.getProperty("install4j.helperMaxHeap", "-Xmx128m");
        boolean bl = helperStarted = Win32UserInfo.executeElevated(moduleName, "__i4j_lang_restart -J" + maxHeap + " -J-D" + "install4j.commIdentifier" + "=" + identifier + " -J-D" + "install4j.helperAppId" + "=" + InstallerConfig.getCurrentApplicationId() + " -J-Duser.language=" + context.getLanguageId() + " -J-D" + "install4j.language" + "=" + context.getLanguageId() + " -J-D" + "install4j.systemLanguage" + "=" + System.getProperty("install4j.systemLanguage") + " -J-D" + "exe4j.unextractedPositionRestart" + "=" + Integer.getInteger("exe4j.unextractedPositionRestart", Integer.getInteger("exe4j.unextractedPosition", 0)) + " -J-D" + "install4j.commIdentifier" + "=" + identifier + " -J-D" + "install4j.helperLog" + "=" + Boolean.getBoolean("install4j.helperLog") + (WinDel.SEMAPHORE_NAME == null ? "" : " \"-J-Dexe4j.semaphoreName=" + WinDel.SEMAPHORE_NAME + "\""), System.getProperty("user.dir")) && helperCommunication.connect();
        if (splashProgressInterface != null) {
            splashProgressInterface.setVisible(false);
        }
        if (helperStarted) {
            context.setVariable("sys.adminRights", Boolean.TRUE);
        }
        return helperStarted;
    }

    private String getModuleName() {
        String moduleName;
        if (InstallerUtil.isInProcess()) {
            moduleName = ApplicationLauncherImpl.getExeFile((ApplicationWithPath)InstallerConfig.getCurrentApplication()).getAbsolutePath();
        } else {
            moduleName = System.getProperty("exe4j.moduleName");
            if (moduleName == null) {
                Util.showMessage("No elevation can be performed for debug installers. Continuing without elevation.", 1);
            }
        }
        return moduleName;
    }

    private SplashProgressInterface checkSplashScreen(Context context) {
        SplashProgressInterface ret = null;
        if (!(InstallerConfig.isInstaller() && !((InstallerApplication)InstallerConfig.getCurrentApplication()).isSuppressProgressDialog() || context.isConsole() || context.isUnattended() || SwingWindowChecker.hasVisibleWindows())) {
            SplashProgressInterface splashProgressInterface;
            String title = "install4j";
            if (context.getWizardContext() instanceof WizardScreenExecutor) {
                title = ((WizardScreenExecutor)context.getWizardContext()).getWindowTitle();
            }
            ret = splashProgressInterface = new SplashProgressInterface(title, false, false, null, false, null);
            splashProgressInterface.setStatusMessage(Messages.getMessages().getString("ProcessElevationTitle"));
            try {
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        splashProgressInterface.setIndeterminateProgress(true);
                        splashProgressInterface.setVisible(true);
                    }
                };
                if (EventQueue.isDispatchThread()) {
                    runnable.run();
                } else {
                    SwingUtilities.invokeAndWait(runnable);
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        return ret;
    }

    protected void showFailureMessage(Context context) throws UserCanceledException {
        String key = context instanceof InstallerContext ? (Util.isWindows() ? "AdminPrivilegesRequired" : "RootPrivilegesRequired") : "OnlyAdminCanUninstall";
        Util.showMessage(Messages.getMessages().getString(key), 0);
        throw new UserCanceledException("not admin");
    }
}

