/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.actions.registry;

import com.install4j.api.context.Context;
import com.install4j.api.context.InstallerContext;
import com.install4j.api.context.UserCanceledException;
import com.install4j.api.windows.RegistryRoot;
import com.install4j.api.windows.WinRegistry;
import com.install4j.runtime.beans.actions.SystemInstallOrUninstallAction;
import com.install4j.runtime.installer.helper.InstallerUtil;
import java.io.File;
import java.io.IOException;

public class DeleteRegistryItemAction
extends SystemInstallOrUninstallAction {
    private RegistryRoot registryRoot;
    private String keyName = "";
    private String valueName = "";
    private boolean onlyIfEmpty = true;

    public DeleteRegistryItemAction() {
    }

    public DeleteRegistryItemAction(RegistryRoot registryRoot, String keyName, String valueName, boolean onlyIfEmpty) {
        this.registryRoot = registryRoot;
        this.keyName = keyName;
        this.valueName = valueName;
        this.onlyIfEmpty = onlyIfEmpty;
    }

    @Override
    public boolean execute(Context context) throws UserCanceledException {
        if (!InstallerUtil.isWindows()) {
            return true;
        }
        String valueName = this.getValueName();
        PerformedAction performedAction = new PerformedAction();
        this.addRollbackAction(performedAction);
        if (valueName.trim().length() == 0) {
            if (context instanceof InstallerContext) {
                try {
                    performedAction.backupFile = File.createTempFile("i4j", ".reg");
                    performedAction.backupFile.delete();
                    if (!WinRegistry.saveKey(this.getRegistryRoot(), this.getKeyName(), performedAction.backupFile.getAbsolutePath())) {
                        performedAction.backupFile.delete();
                        performedAction.backupFile = null;
                    } else {
                        performedAction.backupFile.deleteOnExit();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            WinRegistry.deleteKey(this.getRegistryRoot(), this.getKeyName(), this.isOnlyIfEmpty());
        } else {
            performedAction.oldValue = WinRegistry.getValue(this.getRegistryRoot(), this.getKeyName(), valueName);
            WinRegistry.deleteValue(this.getRegistryRoot(), this.getKeyName(), valueName);
        }
        return true;
    }

    public RegistryRoot getRegistryRoot() {
        return this.registryRoot;
    }

    public void setRegistryRoot(RegistryRoot registryRoot) {
        this.registryRoot = registryRoot;
    }

    public String getKeyName() {
        return DeleteRegistryItemAction.replaceVariables(this.keyName);
    }

    public void setKeyName(String keyName) {
        this.keyName = keyName;
    }

    public String getValueName() {
        return DeleteRegistryItemAction.replaceVariables(this.valueName);
    }

    public void setValueName(String valueName) {
        this.valueName = valueName;
    }

    public boolean isOnlyIfEmpty() {
        return this.onlyIfEmpty;
    }

    public void setOnlyIfEmpty(boolean onlyIfEmpty) {
        this.onlyIfEmpty = onlyIfEmpty;
    }

    private class PerformedAction
    extends DeleteRegistryItemAction {
        private Object oldValue;
        private File backupFile;

        public PerformedAction() {
            DeleteRegistryItemAction.this.registryRoot = DeleteRegistryItemAction.this.getRegistryRoot();
            DeleteRegistryItemAction.this.keyName = DeleteRegistryItemAction.this.getKeyName();
            DeleteRegistryItemAction.this.valueName = DeleteRegistryItemAction.this.getValueName();
        }

        @Override
        public void rollback(InstallerContext context) {
            if (this.backupFile != null) {
                WinRegistry.restoreKey(DeleteRegistryItemAction.this.registryRoot, DeleteRegistryItemAction.this.keyName, this.backupFile.getAbsolutePath());
            } else if (this.oldValue != null) {
                WinRegistry.setValue(DeleteRegistryItemAction.this.registryRoot, DeleteRegistryItemAction.this.keyName, DeleteRegistryItemAction.this.valueName, this.oldValue);
            }
        }
    }
}

