/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.formcomponents;

import com.install4j.api.Util;
import com.install4j.api.beans.ScriptProperty;
import com.install4j.api.beans.VariableErrorHandlingDescriptor;
import com.install4j.api.context.UserCanceledException;
import com.install4j.api.formcomponents.FormEnvironment;
import com.install4j.api.screens.Console;
import com.install4j.runtime.beans.formcomponents.CoupledComponentsHolder;
import com.install4j.runtime.beans.formcomponents.CoupledComponentsUtil;
import com.install4j.runtime.beans.formcomponents.LeadingLabelComponent;
import com.install4j.runtime.installer.helper.Logger;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.JCheckBox;
import javax.swing.JComponent;

public class CheckboxComponent
extends LeadingLabelComponent
implements CoupledComponentsHolder {
    private String variableName = "";
    private String checkboxText = "";
    private boolean initiallySelected;
    private List<String> coupledComponentIds = new ArrayList<String>();
    private boolean inverseCoupling = false;
    private ScriptProperty selectionScript;
    private JCheckBox checkbox;

    public String getVariableName() {
        return this.variableName;
    }

    public void setVariableName(String variableName) {
        this.variableName = variableName;
    }

    public String getCheckboxText() {
        return CheckboxComponent.replaceVariables(this.checkboxText, VariableErrorHandlingDescriptor.ALWAYS_ERROR_MESSAGE);
    }

    public void setCheckboxText(String checkboxText) {
        this.checkboxText = checkboxText;
    }

    public boolean isInitiallySelected() {
        return this.initiallySelected;
    }

    public void setInitiallySelected(boolean initiallySelected) {
        this.initiallySelected = initiallySelected;
    }

    public ScriptProperty getSelectionScript() {
        return this.selectionScript;
    }

    public void setSelectionScript(ScriptProperty selectionScript) {
        this.selectionScript = selectionScript;
    }

    @Override
    public List<String> getCoupledComponentIds() {
        return this.coupledComponentIds;
    }

    @Override
    public void setCoupledComponentIds(List<String> coupledComponentIds) {
        this.coupledComponentIds = coupledComponentIds;
    }

    @Override
    public boolean isInverseCoupling() {
        return this.inverseCoupling;
    }

    @Override
    public void setInverseCoupling(boolean inverseCoupling) {
        this.inverseCoupling = inverseCoupling;
    }

    @Override
    public Boolean isEnableCoupledComponents() {
        if (this.checkbox == null) {
            return null;
        }
        return this.checkbox.isSelected();
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        CoupledComponentsUtil.enableCoupledComponents(this);
    }

    @Override
    public void migrateIds(Map<String, String> oldItToNewId) {
        super.migrateIds(oldItToNewId);
        CoupledComponentsUtil.migrateCoupledIds(this, oldItToNewId);
    }

    @Override
    public void initialize() {
        super.initialize();
        if (this.checkboxText.trim().length() > 0) {
            this.checkbox.setText(this.getCheckboxText());
        }
        if (((Boolean)this.getInitValue(this.isInitiallySelected(), this.getVariableName(), Boolean.class)).booleanValue()) {
            this.checkbox.setSelected(true);
        }
    }

    @Override
    public void formWillActivate() {
        super.formWillActivate();
        CoupledComponentsUtil.enableCoupledComponents(this);
    }

    @Override
    public void setFormEnvironment(FormEnvironment formEnvironment) {
        super.setFormEnvironment(formEnvironment);
        if (this.checkbox != null && formEnvironment != null) {
            this.checkbox.setName(formEnvironment.getId(this));
        }
    }

    @Override
    public JComponent createCenterComponent() {
        this.checkbox = new JCheckBox();
        this.checkbox.setAlignmentX(0.0f);
        this.checkbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                CoupledComponentsUtil.enableCoupledComponents(CheckboxComponent.this);
                CheckboxComponent.this.executeSelectionScript();
            }
        });
        return this.checkbox;
    }

    private void executeSelectionScript() {
        try {
            this.getContext().runScript(this.selectionScript, this, new Object[]{this.getFormEnvironment(), this.checkbox.isSelected()});
        }
        catch (Exception e) {
            Util.printAnnotatedStackTrace(e);
            Logger.getInstance().log(e);
        }
    }

    @Override
    public boolean isFillCenterHorizontal() {
        return false;
    }

    @Override
    public Object getConfigurationObject() {
        return this.checkbox;
    }

    @Override
    public Class getConfigurationObjectClass() {
        return JCheckBox.class;
    }

    @Override
    public boolean checkCompleted() {
        this.getContext().setVariable(this.getVariableName(), this.checkbox.isSelected());
        this.getContext().registerResponseFileVariable(this.getVariableName());
        return true;
    }

    @Override
    public boolean handleConsole(Console console) throws UserCanceledException {
        this.checkbox.setSelected(console.askYesNo(this.getConsoleLabelText(true) + this.appendConditional(this.checkbox.getText(), "?", false), this.checkbox.isSelected()));
        CoupledComponentsUtil.enableCoupledComponents(this);
        this.executeSelectionScript();
        return true;
    }

    @Override
    public boolean handleUnattended() {
        CoupledComponentsUtil.enableCoupledComponents(this);
        return super.handleUnattended();
    }
}

