/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.groups;

import com.install4j.api.Util;
import com.install4j.api.beans.Anchor;
import com.install4j.api.beans.ExternalFile;
import com.install4j.api.beans.ScriptProperty;
import com.install4j.api.formcomponents.AbstractFormComponent;
import com.install4j.api.formcomponents.GroupType;
import com.install4j.runtime.beans.groups.GroupOrientation;
import com.install4j.runtime.beans.groups.LayoutManagerGroup;
import com.install4j.runtime.installer.frontend.GUIHelper;
import com.install4j.runtime.installer.helper.Logger;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.File;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class TabGroup
extends LayoutManagerGroup {
    private static final Object TAB_ICON = "tabIcon";
    private String title = "";
    private ExternalFile iconFile;
    private ScriptProperty activationScript;
    private String tooltipText = "";
    private JTabbedPane tabbedPane;
    private JComponent tabComponent;
    private int lastIndex = -1;

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public ExternalFile getIconFile() {
        return this.iconFile;
    }

    public void setIconFile(ExternalFile iconFile) {
        this.iconFile = iconFile;
    }

    public ScriptProperty getActivationScript() {
        return this.activationScript;
    }

    public void setActivationScript(ScriptProperty activationScript) {
        this.activationScript = activationScript;
    }

    public String getTooltipText() {
        return this.tooltipText;
    }

    public void setTooltipText(String tooltipText) {
        this.tooltipText = tooltipText;
    }

    @Override
    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.insertTab(this.lastIndex);
            this.setEnabled(this.isEnabled());
        } else {
            int index = this.tabbedPane.indexOfComponent(this.tabComponent);
            if (index >= 0) {
                this.lastIndex = index;
                this.tabbedPane.removeTabAt(index);
            }
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        int index = this.tabbedPane.indexOfComponent(this.tabComponent);
        if (index >= 0) {
            this.tabbedPane.setEnabledAt(index, enabled);
        }
    }

    @Override
    protected int getDefaultCellSpacing() {
        return 0;
    }

    @Override
    public GroupOrientation getGroupOrientation() {
        return GroupOrientation.VERTICAL;
    }

    @Override
    public GroupType getGroupType() {
        return GroupType.SINGLE_TAB;
    }

    @Override
    public Anchor getDefaultAnchor() {
        return Anchor.NORTHWEST;
    }

    @Override
    public JComponent createComponent(JComponent container) {
        File actualFile;
        this.tabComponent = super.createComponent(container);
        if (this.iconFile != null && (actualFile = this.getContext().getExternalFile(this.iconFile, false)).exists()) {
            try {
                this.tabComponent.putClientProperty(TAB_ICON, GUIHelper.loadIcon(actualFile));
            }
            catch (Exception e) {
                Util.printAnnotatedStackTrace(e);
                Logger.getInstance().log(e);
            }
        }
        this.tabbedPane = (JTabbedPane)container;
        this.insertTab(-1);
        this.tabbedPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent event) {
                if (TabGroup.this.activationScript != null && TabGroup.this.tabbedPane.getSelectedComponent() == TabGroup.this.tabComponent) {
                    try {
                        TabGroup.this.getContext().runScript(TabGroup.this.activationScript, TabGroup.this, new Object[]{TabGroup.this.getFormEnvironment().getLayoutGroupById(TabGroup.this.getId()), TabGroup.this.getFormEnvironment()});
                    }
                    catch (Exception e) {
                        Util.printAnnotatedStackTrace(e);
                        Logger.getInstance().log(e);
                    }
                }
            }
        });
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setOpaque(false);
        return panel;
    }

    private void insertTab(int index) {
        if (this.isVisible()) {
            int componentCount = this.tabbedPane.getComponentCount();
            int actualIndex = index < 0 ? componentCount : Math.min(index, componentCount);
            String titleWithoutMnemonics = AbstractFormComponent.getTextWithoutMnemonics(this.title);
            this.tabbedPane.insertTab(titleWithoutMnemonics, (Icon)this.tabComponent.getClientProperty(TAB_ICON), this.tabComponent, this.tooltipText.length() > 0 ? this.tooltipText : null, actualIndex);
            int mnemonicCharIndex = AbstractFormComponent.getMnemonicCharIndex(this.title);
            if (mnemonicCharIndex >= 0) {
                int mnemonic = titleWithoutMnemonics.charAt(mnemonicCharIndex);
                if (mnemonic >= 97 && mnemonic <= 122) {
                    mnemonic -= 32;
                }
                this.tabbedPane.setMnemonicAt(actualIndex, mnemonic);
                this.tabbedPane.setDisplayedMnemonicIndexAt(actualIndex, mnemonicCharIndex);
            }
        }
    }

    @Override
    protected Insets getDefaultInsets() {
        return new Insets(5, 5, 5, 5);
    }

    public void makeTabVisible() {
        this.tabbedPane.setSelectedComponent(this.tabComponent);
    }
}

