/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.screens;

import com.install4j.api.context.InstallerContext;
import com.install4j.api.context.UserCanceledException;
import com.install4j.api.screens.Console;
import com.install4j.runtime.beans.screens.DescriptionScreen;
import com.install4j.runtime.beans.screens.installationtype.ComponentsSelectionType;
import com.install4j.runtime.beans.screens.installationtype.InstallationTypeConfig;
import com.install4j.runtime.beans.screens.installationtype.InstallationTypeTree;
import com.install4j.runtime.installer.InstallerVariables;
import com.install4j.runtime.installer.config.ComponentConfig;
import com.install4j.runtime.installer.config.ComponentFolderConfig;
import com.install4j.runtime.installer.config.ComponentNodeConfig;
import com.install4j.runtime.installer.config.InstallerConfig;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class InstallationTypeScreen
extends DescriptionScreen {
    public static final String VARIABLE_PREVENT_COMPONENT_CUSTOMIZATION = "sys.preventComponentCustomization";
    private InstallationTypeTree tree;
    private JScrollPane scpTree;
    private List<InstallationTypeConfig> installationTypeConfigs = new ArrayList<InstallationTypeConfig>();
    private String initialId = null;
    private Boolean overridePreventComponentCustomization;

    public List<InstallationTypeConfig> getInstallationTypeConfigs() {
        return this.installationTypeConfigs;
    }

    public void setInstallationTypeConfigs(List<InstallationTypeConfig> installationTypeConfigs) {
        this.installationTypeConfigs = installationTypeConfigs;
    }

    @Override
    public String getTitle() {
        return this.getMessage("WizardInstallationType");
    }

    @Override
    public String getSubTitle() {
        return this.getMessage("SelectInstallationType");
    }

    public String getInitialId() {
        return this.initialId;
    }

    @Override
    public boolean next() {
        this.applySelectedConfig(this.tree.getSelectedConfig());
        return true;
    }

    private void applySelectedConfig(InstallationTypeConfig selectedConfig) {
        if (selectedConfig != null) {
            for (ComponentConfig componentConfig : InstallerConfig.getCurrentInstance().getComponents()) {
                if (componentConfig.isMandatory()) continue;
                componentConfig.setSelected(false);
            }
            for (ComponentConfig componentConfig : InstallerConfig.getCurrentInstance().getComponents()) {
                if (componentConfig.isMandatory()) continue;
                componentConfig.setSelected(this.isSelectedComponent(componentConfig, selectedConfig));
            }
        }
    }

    private boolean isSelectedComponent(ComponentConfig componentConfig, InstallationTypeConfig selectedConfig) {
        ComponentsSelectionType componentsSelectionType = selectedConfig.getComponentsSelectionType();
        if (componentsSelectionType == ComponentsSelectionType.ALL) {
            return true;
        }
        if (componentsSelectionType == ComponentsSelectionType.DEFAULT) {
            return componentConfig.isInitiallySelected();
        }
        String targetId = componentConfig.getId();
        for (String componentId : selectedConfig.getSelectedComponentIds()) {
            ComponentNodeConfig selectedComponentConfig = InstallerConfig.getCurrentInstance().getComponentNodeById(componentId);
            if (selectedComponentConfig == null || !(selectedComponentConfig instanceof ComponentFolderConfig ? this.isContainedInFolder((ComponentFolderConfig)selectedComponentConfig, targetId) : selectedComponentConfig.getId().equals(targetId))) continue;
            return true;
        }
        return false;
    }

    private boolean isContainedInFolder(ComponentFolderConfig componentFolderConfig, String id) {
        for (ComponentNodeConfig componentNodeConfig : componentFolderConfig.getComponents()) {
            boolean found;
            if (!(componentNodeConfig instanceof ComponentFolderConfig ? (found = this.isContainedInFolder((ComponentFolderConfig)componentNodeConfig, id)) : componentNodeConfig.getId().equals(id))) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void addScreenContent(JPanel panel, GridBagConstraints gc) {
        String headerMessage = this.getMessage("SelectInstallationTypeLabel");
        if (headerMessage.trim().length() > 0) {
            this.addDisplayTextArea(headerMessage, panel, gc);
        }
        gc.weighty = 1.0;
        gc.weightx = 1.0;
        gc.fill = 1;
        panel.add((Component)this.scpTree, gc);
        ++gc.gridy;
    }

    @Override
    public void setInstallerContext(InstallerContext context) {
        super.setInstallerContext(context);
        InstallerVariables.registerResponseFileVariable("sys.installationTypeId");
        Object varValue = InstallerVariables.getVariable("sys.installationTypeId");
        if (varValue != null && varValue instanceof String) {
            this.initialId = (String)varValue;
        }
        InstallerVariables.registerVariableProvider("sys.installationTypeId", new InstallerVariables.VariableProvider(){

            @Override
            public Object getVariable() {
                return InstallationTypeScreen.this.tree == null ? InstallationTypeScreen.this.initialId : InstallationTypeScreen.this.tree.getSelectedId();
            }

            @Override
            public void setVariable(Object value) {
                if (value != null && value instanceof String) {
                    String id = (String)value;
                    if (InstallationTypeScreen.this.tree == null) {
                        InstallationTypeScreen.this.initialId = id;
                    } else {
                        InstallationTypeScreen.this.tree.setSelectedId(id);
                    }
                }
            }
        });
        InstallerVariables.registerVariableProvider(VARIABLE_PREVENT_COMPONENT_CUSTOMIZATION, new InstallerVariables.VariableProvider(){

            @Override
            public Object getVariable() {
                if (InstallationTypeScreen.this.overridePreventComponentCustomization != null) {
                    return InstallationTypeScreen.this.overridePreventComponentCustomization;
                }
                if (InstallationTypeScreen.this.tree == null) {
                    return Boolean.FALSE;
                }
                InstallationTypeConfig selectedConfig = InstallationTypeScreen.this.tree.getSelectedConfig();
                if (selectedConfig == null) {
                    return Boolean.FALSE;
                }
                return selectedConfig.isUserCanCustomize() ? Boolean.FALSE : Boolean.TRUE;
            }

            @Override
            public void setVariable(Object value) {
            }
        });
    }

    @Override
    protected void setupControls() {
        super.setupControls();
        this.tree = new InstallationTypeTree(this);
        this.scpTree = new JScrollPane(this.tree);
    }

    @Override
    public boolean handleConsole(Console console) throws UserCanceledException {
        if (!super.handleConsole(console)) {
            return false;
        }
        int typeCount = this.installationTypeConfigs.size();
        String[] keys = new String[typeCount];
        String[] descriptions = new String[typeCount];
        int defaultValue = 0;
        for (int i = 0; i < keys.length; ++i) {
            keys[i] = String.valueOf(i + 1);
            InstallationTypeConfig config = this.installationTypeConfigs.get(i);
            descriptions[i] = config.getName();
            if (!config.getId().equals(this.initialId) && !config.getDisplayedId().equals(this.initialId)) continue;
            defaultValue = i;
        }
        int result = console.askOption(this.getMessage("SelectInstallationType"), descriptions, keys, defaultValue, false, true);
        if (result > -1) {
            InstallationTypeConfig selectedConfig = this.installationTypeConfigs.get(result);
            this.overridePreventComponentCustomization = selectedConfig.isUserCanCustomize() ? Boolean.FALSE : Boolean.TRUE;
            this.applySelectedConfig(selectedConfig);
            this.initialId = selectedConfig.getDisplayedId();
        }
        return true;
    }
}

