/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.dirchooser;

import com.install4j.api.Util;
import com.install4j.runtime.dirchooser.DirectoryChooserDialog;
import com.install4j.runtime.dirchooser.DirectoryChooserUI;
import java.awt.Component;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.UIManager;
import javax.swing.filechooser.FileSystemView;
import javax.swing.plaf.ComponentUI;

public class DirectoryChooser
extends JFileChooser {
    static final String PROPERTY_MANUAL_DIRECTORY_CHOOSER = "manualDirectoryChooser";
    private String title;
    private DirectoryChooserDialog dialog;
    private int returnValue = -1;
    private boolean activated;
    private boolean allowFolderCreation;
    private String cancelButtonText;

    public DirectoryChooser() {
    }

    public DirectoryChooser(File currentDirectory) {
        super(currentDirectory);
    }

    public DirectoryChooser(File currentDirectory, FileSystemView fsv) {
        super(currentDirectory, fsv);
    }

    public DirectoryChooser(FileSystemView fsv) {
        super(fsv);
    }

    public DirectoryChooser(String currentDirectoryPath) {
        super(currentDirectoryPath);
    }

    public DirectoryChooser(String currentDirectoryPath, FileSystemView fsv) {
        super(currentDirectoryPath, fsv);
    }

    public boolean isAllowFolderCreation() {
        return this.allowFolderCreation;
    }

    public void setAllowFolderCreation(boolean allowFolderCreation) {
        this.allowFolderCreation = allowFolderCreation;
        this.updateUI();
    }

    public boolean isDialogVisible() {
        return this.dialog != null && this.dialog.isVisible();
    }

    @Override
    public void setUI(ComponentUI ui) {
        if (!(ui instanceof DirectoryChooserUI)) {
            this.setUI(new DirectoryChooserUI(this));
        } else {
            super.setUI(ui);
        }
    }

    @Override
    public void setCurrentDirectory(File dir) {
        if (dir != null && this.getSelectedFile() != null && !dir.equals(this.getSelectedFile())) {
            this.setSelectedFile(null);
        }
        super.setCurrentDirectory(dir);
    }

    @Override
    public void setSelectedFiles(File[] selectedFiles) {
        super.setSelectedFiles(selectedFiles);
        this.setSelectedFile(selectedFiles[0]);
    }

    @Override
    public int showDialog(Component parent, String approveButtonText) {
        return this.showDialog(parent, approveButtonText, null);
    }

    public int showDialog(Component parent, String approveButtonText, String cancelButtonText) {
        this.cancelButtonText = cancelButtonText;
        if (approveButtonText != null) {
            this.setApproveButtonText(approveButtonText);
        }
        if (this.dialog == null) {
            this.dialog = DirectoryChooserDialog.create(this, Util.getParentWindow());
            this.dialog.setTitle(this.title);
            this.dialog.addWindowListener(new WindowAdapter(){

                @Override
                public void windowActivated(WindowEvent e) {
                    if (!DirectoryChooser.this.activated) {
                        ((DirectoryChooserUI)DirectoryChooser.this.getUI()).scrollToSelection();
                    }
                    DirectoryChooser.this.activated = true;
                }

                @Override
                public void windowClosing(WindowEvent e) {
                    DirectoryChooser.this.returnValue = 1;
                }
            });
        }
        this.returnValue = -1;
        this.rescanCurrentDirectory();
        this.dialog.setVisible(true);
        return this.returnValue;
    }

    @Override
    protected void fireActionPerformed(String command) {
        if (command.equals("ApproveSelection")) {
            this.returnValue = 0;
            this.dialog.setVisible(false);
        } else if (command.equals("CancelSelection")) {
            this.returnValue = 1;
            this.dialog.setVisible(false);
        }
        super.fireActionPerformed(command);
    }

    public static void main(String[] args) throws Exception {
        UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        System.setProperty(PROPERTY_MANUAL_DIRECTORY_CHOOSER, "true");
        DirectoryChooser chooser = new DirectoryChooser();
        chooser.setMultiSelectionEnabled(false);
        chooser.setAllowFolderCreation(true);
        chooser.setTitle("Select directory");
        chooser.setCurrentDirectory(new File("c:\\Program Files (x86)"));
        int choice = chooser.showOpenDialog(null);
        if (choice == 1) {
            System.out.println("User Canceled");
        } else {
            System.out.println("Dialog Selection: " + chooser.getSelectedFile().getAbsolutePath());
        }
        System.exit(0);
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void focusTree() {
        ((DirectoryChooserUI)this.getUI()).focusTree();
    }

    public String getCancelButtonText() {
        return this.cancelButtonText;
    }
}

