/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer;

import com.install4j.api.Util;
import com.install4j.api.actions.UninstallAction;
import com.install4j.api.context.Context;
import com.install4j.api.context.UninstallerContext;
import com.install4j.api.context.UserCanceledException;
import com.install4j.api.screens.Screen;
import com.install4j.api.screens.UninstallerScreen;
import com.install4j.runtime.installer.ContextImpl;
import com.install4j.runtime.installer.InstallerVariables;
import com.install4j.runtime.installer.WrapperUninstallerContext;
import com.install4j.runtime.installer.config.AbstractBeanConfig;
import com.install4j.runtime.installer.config.ActionBeanConfig;
import com.install4j.runtime.installer.config.ScreenBeanConfig;
import com.install4j.runtime.installer.controller.ScreenExecutor;
import com.install4j.runtime.installer.helper.ClasspathModificator;
import com.install4j.runtime.installer.helper.comm.HelperCommunication;
import com.install4j.runtime.installer.helper.comm.actions.FetchObjectAction;
import com.install4j.runtime.installer.helper.fileinst.FileInstaller;
import com.install4j.runtime.installer.helper.versionspecific.VersionSpecificHelper;
import java.io.File;
import java.io.IOException;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class UninstallerContextImpl
extends ContextImpl
implements UninstallerContext,
Serializable {
    private Map<String, UninstallerContext> idNamespaceToContext = new HashMap<String, UninstallerContext>();

    public UninstallerContextImpl(ScreenExecutor screenExecutor) {
        super(screenExecutor);
        UninstallerContextImpl.preLoadLibraries();
        InstallerVariables.registerVariableProvider("sys.installationDir", new InstallerVariables.VariableProvider(){

            @Override
            public Object getVariable() {
                return UninstallerContextImpl.this.getInstallationDirectory().getPath();
            }

            @Override
            public void setVariable(Object value) {
            }
        });
    }

    public static void preLoadLibraries() {
        if (!Util.isWindows() && VersionSpecificHelper.isJava7Helper()) {
            try {
                VersionSpecificHelper.getFileInformation(new File(System.getProperty("java.home")));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    @Override
    public void applyToScreen(Screen screen, ScreenBeanConfig config) {
        if (screen instanceof UninstallerScreen) {
            ((UninstallerScreen)screen).setUninstallerContext(this.getIdWrapperUninstallerContext(config));
        }
    }

    @Override
    public Context getIdWrapperContext(AbstractBeanConfig config) {
        return this.getIdWrapperUninstallerContext(config);
    }

    @Override
    public File getAdditionalUserJarsDir() {
        return null;
    }

    private UninstallerContext getIdWrapperUninstallerContext(AbstractBeanConfig config) {
        String idNamespace = config.getIdNamespace();
        if (idNamespace.length() == 0) {
            return this;
        }
        UninstallerContext wrapperContext = this.idNamespaceToContext.get(idNamespace);
        if (wrapperContext == null) {
            wrapperContext = new WrapperUninstallerContext(this, idNamespace);
            this.idNamespaceToContext.put(idNamespace, wrapperContext);
        }
        return wrapperContext;
    }

    @Override
    public boolean performActionInt(ActionBeanConfig config) throws UserCanceledException {
        UninstallerContext currentContext = this.getIdWrapperUninstallerContext(config);
        return UninstallerContextImpl.performActionIntStatic(config, currentContext);
    }

    private static boolean performActionIntStatic(ActionBeanConfig config, UninstallerContext currentContext) throws UserCanceledException {
        ContextImpl.setCurrentContext(currentContext);
        final UninstallAction action = (UninstallAction)config.getOrInstantiateAction(false);
        try {
            boolean bl = UninstallerContextImpl.handlePostActionExecutionState(config, HelperCommunication.getInstance().fetchObjectChecked(config.getExecutionContext(), new FetchObjectAction<ContextImpl.PostActionExecutionState>(){

                @Override
                protected ContextImpl.PostActionExecutionState fetchValue(Context context) throws UserCanceledException {
                    boolean success = action.uninstall((UninstallerContext)context);
                    return new ContextImpl.PostActionExecutionState(action, success);
                }
            }));
            return bl;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            ContextImpl.setCurrentContext(null);
        }
    }

    @Override
    public void rollbackActionInt(ActionBeanConfig config) {
    }

    @Override
    public boolean isUninstallForUpgrade() {
        return Boolean.getBoolean("install4j.upgradeUninstall");
    }

    @Override
    public boolean checkStart() {
        ClasspathModificator.addCustomJarsToClasspath(this);
        return super.checkStart();
    }

    @Override
    public void finish(int exitCode) {
        if (this.isUninstallForUpgrade()) {
            System.setProperty("install4j.noRebootDeletion", "true");
        }
        FileInstaller.getInstance().finishUninstall();
        super.finish(exitCode);
    }

    @Override
    protected String getRebootMessageId() {
        return "UninstalledAndNeedsRestart";
    }

    private Object writeReplace() throws ObjectStreamException {
        return new ContextStandin();
    }

    private static class ContextStandin
    implements Serializable {
        private ContextStandin() {
        }

        private Object readResolve() throws ObjectStreamException {
            return ContextImpl.getCurrentContext();
        }
    }
}

