/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.config;

import com.install4j.api.beans.Bean;
import com.install4j.runtime.beans.groups.Group;
import com.install4j.runtime.installer.config.AbstractBeanConfig;
import com.install4j.runtime.installer.config.ActionBeanConfig;
import com.install4j.runtime.installer.config.FormComponentBeanConfig;
import com.install4j.runtime.installer.config.GroupProvider;
import com.install4j.runtime.installer.config.LinkActionBeanConfig;
import com.install4j.runtime.installer.config.LinkGroupBeanConfig;
import com.install4j.runtime.installer.config.LinkScreenBeanConfig;
import com.install4j.runtime.installer.config.ScreenBeanConfig;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Element;

public class GroupBeanConfig
extends AbstractBeanConfig
implements GroupProvider {
    private Group instance;
    private List<AbstractBeanConfig> beanConfigs;
    private boolean screenGroup;

    public GroupBeanConfig(boolean screenGroup) {
        this.screenGroup = screenGroup;
    }

    public Group getOrInstantiateGroup(boolean suppressErrors) {
        if (this.instance == null) {
            this.instance = (Group)this.instantiateBean(suppressErrors);
        }
        return this.instance;
    }

    @Override
    public Object getOrInstantiateBean() {
        return this.getOrInstantiateGroup(false);
    }

    @Override
    public List<AbstractBeanConfig> getBeanConfigs() {
        return this.beanConfigs;
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    @Override
    public boolean isInstantiated() {
        return this.instance != null;
    }

    @Override
    protected void setBean(Bean bean) {
        this.instance = (Group)bean;
    }

    @Override
    protected void read(Element element) {
        super.read(element);
        this.readBeanConfigs(element);
    }

    private void readBeanConfigs(Element element) {
        LinkedList<ActionBeanConfig> beanConfigs = new LinkedList<ActionBeanConfig>();
        Element beansElement = GroupBeanConfig.findChild(element, "beans");
        if (beansElement != null) {
            for (Element beanElement : GroupBeanConfig.childElements(beansElement)) {
                AbstractBeanConfig beanConfig;
                String beanElementName = beanElement.getTagName();
                if (beanElementName.equalsIgnoreCase("action")) {
                    beanConfig = new ActionBeanConfig();
                } else if (beanElementName.equalsIgnoreCase("screen")) {
                    beanConfig = new ScreenBeanConfig();
                } else if (beanElementName.equalsIgnoreCase("link")) {
                    beanConfig = GroupBeanConfig.readAttribute(beanElement, "group", false) ? new LinkGroupBeanConfig(this.screenGroup) : (this.screenGroup ? new LinkScreenBeanConfig() : new LinkActionBeanConfig());
                } else if (beanElementName.equalsIgnoreCase("formComponent")) {
                    beanConfig = new FormComponentBeanConfig();
                } else {
                    if (!beanElementName.equalsIgnoreCase("group")) continue;
                    beanConfig = new GroupBeanConfig(this.screenGroup);
                }
                ((AbstractBeanConfig)beanConfig).read(beanElement);
                beanConfigs.add((ActionBeanConfig)beanConfig);
            }
        }
        this.beanConfigs = Collections.unmodifiableList(beanConfigs);
    }

    @Override
    public void addAllTo(Map<String, AbstractBeanConfig> id2BeanConfig) {
        super.addAllTo(id2BeanConfig);
        for (AbstractBeanConfig beanConfig : this.beanConfigs) {
            beanConfig.addAllTo(id2BeanConfig);
        }
    }
}

