/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.controller;

import com.install4j.api.Util;
import com.install4j.api.actions.Action;
import com.install4j.api.actions.InstallAction;
import com.install4j.api.beans.Bean;
import com.install4j.api.beans.UndefinedVariableException;
import com.install4j.api.context.UserCanceledException;
import com.install4j.api.events.EventType;
import com.install4j.api.events.InstallerEvent;
import com.install4j.api.screens.Screen;
import com.install4j.runtime.beans.groups.ActionGroup;
import com.install4j.runtime.beans.screens.StartupScreen;
import com.install4j.runtime.installer.ContextImpl;
import com.install4j.runtime.installer.InstallerVariables;
import com.install4j.runtime.installer.config.AbstractBeanConfig;
import com.install4j.runtime.installer.config.ActionBeanConfig;
import com.install4j.runtime.installer.config.GroupBeanConfig;
import com.install4j.runtime.installer.config.InstallerConfig;
import com.install4j.runtime.installer.config.ScreenBeanConfig;
import com.install4j.runtime.installer.controller.ActionCallback;
import com.install4j.runtime.installer.controller.ActionCallbackCommand;
import com.install4j.runtime.installer.controller.CommandSink;
import com.install4j.runtime.installer.controller.ControllerCommand;
import com.install4j.runtime.installer.controller.FinishCommand;
import com.install4j.runtime.installer.controller.GoBackCommand;
import com.install4j.runtime.installer.controller.GoBackInHistoryToScreenCommand;
import com.install4j.runtime.installer.controller.GoForwardCommand;
import com.install4j.runtime.installer.controller.GotoScreenCommand;
import com.install4j.runtime.installer.controller.LanguageSelector;
import com.install4j.runtime.installer.controller.ScreenExecutor;
import com.install4j.runtime.installer.controller.ScreenNavigator;
import com.install4j.runtime.installer.frontend.Messages;
import com.install4j.runtime.installer.frontend.VariableResourceBundleWrapper;
import com.install4j.runtime.installer.helper.InstallerUtil;
import com.install4j.runtime.installer.helper.Logger;
import com.install4j.runtime.installer.helper.ServiceHandler;
import com.install4j.runtime.installer.helper.fileinst.FileInstaller;
import java.awt.EventQueue;
import java.util.ArrayList;
import java.util.List;

public class Controller {
    private ScreenExecutor screenExecutor;
    private ContextImpl context;
    private List<ActionBeanConfig> startedActionsConfigs = new ArrayList<ActionBeanConfig>();
    private ScreenNavigator screenNavigator;

    public Controller(ScreenExecutor screenExecutor) {
        this.screenExecutor = screenExecutor;
        this.context = screenExecutor.getContext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        LanguageSelector.initSystemAndDefaultLanguage();
        InstallerVariables.initUserVars();
        InstallerUtil.registerStarted(false);
        InstallerVariables.setReplaceI18nVariables(true);
        InstallerVariables.setReplaceInstallerAndCompilerVariables(true);
        InstallerUtil.setConsole(this.screenExecutor.isConsole());
        InstallerUtil.setUnattended(this.screenExecutor.isUnattended());
        InstallerUtil.loadJREDeployLibs();
        LanguageSelector.initLanguage(this.context, this.screenExecutor);
        if (!this.context.checkStart()) {
            this.context.exit(1);
        }
        this.context.registerScreens();
        if (this.getScreenConfigsFlat().size() == 0) {
            return;
        }
        this.screenNavigator = new ScreenNavigator(this.context);
        ScreenBeanConfig screenConfig = this.handleStartup();
        if (screenConfig == null && InstallerUtil.isInProcess()) {
            return;
        }
        ControllerCommand lastCommand = null;
        while (screenConfig != null) {
            CommandSink commandSink = new CommandSink(this);
            this.execute(screenConfig, commandSink, lastCommand);
            CommandSink commandSink2 = commandSink;
            synchronized (commandSink2) {
                while (commandSink.getCommand() == null) {
                    try {
                        commandSink.wait();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            }
            lastCommand = commandSink.getCommand();
            screenConfig = this.handleCommand(commandSink, screenConfig);
            if (commandSink.isFinished()) {
                return;
            }
            if (screenConfig == null) {
                Logger.getImpl().setCurrentScreen(null);
                commandSink.finished();
                continue;
            }
            Logger.getImpl().setCurrentScreen(screenConfig.getOrInstantiateScreen(false));
        }
        this.context.immediateExit(0);
    }

    private ScreenBeanConfig handleStartup() {
        ScreenBeanConfig startupScreenConfig = this.getScreenConfigsFlat().get(0);
        CommandSink commandSink = new CommandSink(this);
        commandSink.returnToController(new GoForwardCommand(1, true, true, null));
        this.screenExecutor.setCommandSink(commandSink);
        return this.handleCommand(commandSink, startupScreenConfig);
    }

    private void execute(final ScreenBeanConfig screenConfig, final CommandSink commandSink, final ControllerCommand lastCommand) {
        this.screenNavigator.addHistory(screenConfig);
        ArrayList<AbstractBeanConfig> hiddenForPreviousActionConfigs = new ArrayList<AbstractBeanConfig>();
        ScreenBeanConfig previousScreenConfig = this.screenNavigator.findPreviousScreenConfigInHistory(false, hiddenForPreviousActionConfigs, 1);
        final boolean previousPossible = previousScreenConfig != null && screenConfig.getBackButtonType() != 3 && (screenConfig.getBackButtonType() != 2 || !this.hasNonMultiExecActions(previousScreenConfig.getActionConfigs()) && hiddenForPreviousActionConfigs.size() == 0);
        Screen screen = screenConfig.getOrInstantiateScreen(false);
        this.context.fireInstallerEvent(new InstallerEvent(screen, this.context, EventType.SHOW_SCREEN));
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                Controller.this.screenExecutor.execute(screenConfig, commandSink, previousPossible, lastCommand);
            }
        });
    }

    private boolean hasNonMultiExecActions(List<AbstractBeanConfig> actionConfigs) {
        for (AbstractBeanConfig beanConfig : actionConfigs) {
            if (!(beanConfig instanceof GroupBeanConfig ? this.hasNonMultiExecActions(((GroupBeanConfig)beanConfig).getBeanConfigs()) : beanConfig instanceof ActionBeanConfig && !((ActionBeanConfig)beanConfig).isMultiExec())) continue;
            return true;
        }
        return false;
    }

    private ScreenBeanConfig handleCommand(CommandSink commandSink, ScreenBeanConfig currentScreenConfig) {
        Logger.getImpl().resetOrigin();
        ControllerCommand command = commandSink.getCommand();
        ActionCallback actionCallback = null;
        try {
            if (command instanceof GoForwardCommand && ((GoForwardCommand)command).isExecuteActions() || command instanceof FinishCommand) {
                actionCallback = ((ActionCallbackCommand)command).getActionCallback();
                commandSink.allowOverride();
                if (actionCallback != null) {
                    actionCallback.actionsStarted();
                }
                try {
                    this.executeActions(currentScreenConfig.getActionConfigs(), "", false);
                    this.checkRollbackBarrier(currentScreenConfig, currentScreenConfig.getOrInstantiateScreen(false));
                }
                catch (ReturnToScreenException e) {
                    if (!(currentScreenConfig.getOrInstantiateScreen(false) instanceof StartupScreen)) {
                        this.context.goBack(0);
                    }
                }
                catch (UserCanceledException e) {
                    this.rollback(commandSink);
                    ScreenBeanConfig screenBeanConfig = null;
                    if (actionCallback != null) {
                        actionCallback.actionsFinished();
                    }
                    return screenBeanConfig;
                }
                command = commandSink.getOverriddenCommand();
            }
            Logger.getInstance().info(currentScreenConfig.getOrInstantiateScreen(false), "command: " + command);
            if (command instanceof GoForwardCommand) {
                GoForwardCommand goForwardCommand = (GoForwardCommand)command;
                ScreenBeanConfig nextScreenConfig = this.screenNavigator.findNextScreenConfig(currentScreenConfig, goForwardCommand.getNumber(), goForwardCommand.isCheckCondition());
                if (nextScreenConfig == null) {
                    this.context.fireInstallerEvent(new InstallerEvent(this.context, this.context, EventType.FINISHING));
                    commandSink.finished();
                    this.context.finish(0);
                }
                ScreenBeanConfig screenBeanConfig = nextScreenConfig;
                return screenBeanConfig;
            }
            if (command instanceof GoBackCommand) {
                GoBackCommand goBackCommand = (GoBackCommand)command;
                if (goBackCommand.isUseHistory()) {
                    this.screenNavigator.removeLastHistoryItem();
                    if (goBackCommand.getNumber() == 0) {
                        ScreenBeanConfig nextScreenConfig = currentScreenConfig;
                        return nextScreenConfig;
                    }
                    ScreenBeanConfig screenConfig2 = this.screenNavigator.findPreviousScreenConfigInHistory(true, null, goBackCommand.getNumber());
                    if (screenConfig2 == null) {
                        throw new RuntimeException("Could not go back " + goBackCommand.getNumber() + " step in history from " + currentScreenConfig.getOrInstantiateScreen(true));
                    }
                    ScreenBeanConfig screenBeanConfig = screenConfig2;
                    return screenBeanConfig;
                }
                ScreenBeanConfig screenConfig2 = this.screenNavigator.findPreviousScreenConfig(currentScreenConfig, goBackCommand.getNumber());
                return screenConfig2;
            }
            if (command instanceof GoBackInHistoryToScreenCommand) {
                ScreenBeanConfig screenConfig;
                Screen targetScreen = ((GoBackInHistoryToScreenCommand)command).getScreen();
                this.screenNavigator.removeLastHistoryItem();
                if (targetScreen == currentScreenConfig.getOrInstantiateScreen(false)) {
                    ScreenBeanConfig screenConfig2 = currentScreenConfig;
                    return screenConfig2;
                }
                do {
                    if ((screenConfig = this.screenNavigator.findPreviousScreenConfigInHistory(true, null, 1)) != null) continue;
                    throw new RuntimeException("Could not go back in history to screen " + targetScreen.toString());
                } while (screenConfig.getOrInstantiateScreen(false) != targetScreen);
                ScreenBeanConfig screenBeanConfig = screenConfig;
                return screenBeanConfig;
            }
            if (command instanceof FinishCommand) {
                this.context.fireInstallerEvent(new InstallerEvent(this.context, this.context, EventType.FINISHING));
                commandSink.finished();
                this.context.finish(0);
                ScreenBeanConfig targetScreen = null;
                return targetScreen;
            }
            if (command == ControllerCommand.CANCEL) {
                this.rollback(commandSink);
                ScreenBeanConfig targetScreen = null;
                return targetScreen;
            }
            if (command instanceof GotoScreenCommand) {
                ScreenBeanConfig screenConfig = this.findScreenConfig(((GotoScreenCommand)command).getScreen());
                this.screenNavigator.sync(screenConfig);
                ScreenBeanConfig screenBeanConfig = screenConfig;
                return screenBeanConfig;
            }
            throw new RuntimeException("Unknown command " + command.toString());
        }
        finally {
            if (actionCallback != null) {
                actionCallback.actionsFinished();
            }
        }
    }

    public void rollback(CommandSink commandSink) {
        this.context.fireInstallerEvent(new InstallerEvent(this.context, this.context, EventType.CANCELLING));
        if (InstallerConfig.getCurrentApplication().isRollback()) {
            FileInstaller fileInstaller = FileInstaller.getInstance();
            boolean rollbackFiles = fileInstaller.hasRollbackFiles();
            if (this.startedActionsConfigs.size() > 0 || rollbackFiles) {
                ServiceHandler.resetStopState();
                this.context.setRollback();
                this.context.getProgressInterface().setDetailMessage("");
                if (rollbackFiles) {
                    ServiceHandler.stopServices(this.context, true);
                }
                this.context.getProgressInterface().setStatusMessage(Messages.getMessages().getString("StatusRollback"));
                for (int i = this.startedActionsConfigs.size() - 1; i >= 0; --i) {
                    Logger.getImpl().resetOrigin();
                    ActionBeanConfig actionBeanConfig = this.startedActionsConfigs.get(i);
                    if (actionBeanConfig.isRolledBack()) continue;
                    if (rollbackFiles) {
                        fileInstaller.rollback(actionBeanConfig.getRollbackId());
                    }
                    this.context.rollbackAction(actionBeanConfig);
                    actionBeanConfig.setRolledBack(true);
                }
                if (rollbackFiles) {
                    fileInstaller.rollbackAll();
                }
            }
            if (fileInstaller.hasUnrollbackedFiles()) {
                this.context.fireInstallerEvent(new InstallerEvent(this.context, this.context, EventType.CANCELED));
                commandSink.finished();
                this.context.finish(1);
            }
        }
        this.context.fireInstallerEvent(new InstallerEvent(this.context, this.context, EventType.CANCELED));
        commandSink.finished();
        this.context.exit(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean executeActions(List<AbstractBeanConfig> actionConfigs, String defaultMessage, boolean breakGroup) throws UserCanceledException {
        for (AbstractBeanConfig beanConfig : actionConfigs) {
            Logger.getImpl().resetOrigin();
            if (beanConfig instanceof ActionBeanConfig) {
                ActionBeanConfig actionBeanConfig = (ActionBeanConfig)beanConfig;
                Action action = actionBeanConfig.getOrInstantiateAction(false);
                boolean repeat = false;
                do {
                    if (this.context.isCancelling()) {
                        throw new UserCanceledException();
                    }
                    if (!repeat && (!actionBeanConfig.isMultiExec() && actionBeanConfig.isExecuted() || !this.context.runBooleanScript(actionBeanConfig.getConditionClassName(), action))) continue;
                    if (!(actionBeanConfig.isExecuted() || action instanceof InstallAction && !this.isRollbackSupported(action))) {
                        this.startedActionsConfigs.add(actionBeanConfig);
                    }
                    actionBeanConfig.setExecuted(true);
                    try {
                        Logger.getImpl().setCurrentAction(actionBeanConfig.getOrInstantiateAction(false));
                        if (!this.context.performAction(actionBeanConfig)) {
                            repeat = this.handleFailure(actionBeanConfig, action.getClass(), defaultMessage);
                            if (repeat || !breakGroup) continue;
                            boolean bl = false;
                            return bl;
                        }
                        repeat = false;
                    }
                    catch (UndefinedVariableException e) {
                        Logger.getInstance().error(action, "undefined variable: " + e.getMessage());
                        repeat = this.handleFailure(actionBeanConfig, action.getClass(), defaultMessage);
                        if (repeat || !breakGroup) continue;
                        boolean bl = false;
                        return bl;
                    }
                    finally {
                        this.checkRollbackBarrier(actionBeanConfig, action);
                        Logger.getImpl().setCurrentAction(null);
                    }
                } while (repeat);
                continue;
            }
            GroupBeanConfig groupBeanConfig = (GroupBeanConfig)beanConfig;
            if (!this.context.checkGroupCondition(groupBeanConfig)) continue;
            ActionGroup actionGroup = (ActionGroup)groupBeanConfig.getOrInstantiateGroup(false);
            ContextImpl.GroupState groupState = new ContextImpl.GroupState();
            this.context.initLoopIndex(groupBeanConfig, groupState);
            do {
                String newDefaultMessage;
                if ((newDefaultMessage = actionGroup.getDefaultErrorMessage().trim()).length() == 0) {
                    newDefaultMessage = defaultMessage;
                }
                if (this.executeActions(groupBeanConfig.getBeanConfigs(), newDefaultMessage, actionGroup.isOnErrorBreakGroup()) || !breakGroup) continue;
                return false;
            } while (this.context.isGroupLoop(groupBeanConfig, groupState));
        }
        return true;
    }

    private boolean isRollbackSupported(Action action) {
        try {
            return ((InstallAction)action).isRollbackSupported();
        }
        catch (AbstractMethodError e) {
            return false;
        }
    }

    private boolean handleFailure(ActionBeanConfig actionBeanConfig, Class actionClass, String defaultMessage) throws UserCanceledException {
        boolean strategyReturnToScreen;
        int failureStrategy;
        this.context.setErrorOccurred(true);
        String errorMessage = actionBeanConfig.getErrorMessage().trim();
        if (errorMessage.length() == 0) {
            errorMessage = defaultMessage.trim();
        }
        boolean strategyQuit = (failureStrategy = actionBeanConfig.getFailureStrategy()) == 2;
        boolean bl = strategyReturnToScreen = failureStrategy == 5;
        if (strategyQuit || strategyReturnToScreen || failureStrategy == 1) {
            if (errorMessage.length() > 0) {
                Util.showMessage(errorMessage, strategyQuit ? 0 : 2);
            }
            if (strategyQuit) {
                this.quitAndKeepLogFile();
            } else if (strategyReturnToScreen) {
                throw new ReturnToScreenException();
            }
        } else {
            VariableResourceBundleWrapper messages = Messages.getMessages();
            if (errorMessage.length() == 0) {
                errorMessage = Messages.format(messages.getString("ErrorFunctionFailedNoCode"), actionClass.getName()) + "\n";
            }
            if (failureStrategy == 3) {
                if (Util.showOptionDialog(errorMessage, new String[]{messages.getString("ButtonIgnore"), messages.getString("ButtonQuit")}, 0) == 1) {
                    this.quitAndKeepLogFile();
                }
            } else {
                int result = Util.showOptionDialog(errorMessage, new String[]{messages.getString("ButtonIgnore"), messages.getString("ButtonRetry"), messages.getString("ButtonQuit")}, 0);
                if (result == 2) {
                    this.quitAndKeepLogFile();
                } else if (result == 1) {
                    return true;
                }
            }
        }
        return false;
    }

    private void quitAndKeepLogFile() throws UserCanceledException {
        System.setProperty("install4j.keepLog", "true");
        throw new UserCanceledException();
    }

    private void checkRollbackBarrier(AbstractBeanConfig beanConfig, Bean source) {
        if (beanConfig.isRollbackBarrier()) {
            this.startedActionsConfigs.clear();
            FileInstaller.getInstance().setRollbackBarrier();
            Logger.getInstance().info(source, "Rollback barrier reached");
        }
    }

    private ScreenBeanConfig findScreenConfig(Screen screen) {
        for (ScreenBeanConfig screenConfig : this.getScreenConfigsFlat()) {
            if (screenConfig.getOrInstantiateScreen(false) != screen) continue;
            return screenConfig;
        }
        throw new RuntimeException("not in screen sequence; " + screen);
    }

    private List<ScreenBeanConfig> getScreenConfigsFlat() {
        return this.context.getScreenConfigsFlat();
    }

    private class ReturnToScreenException
    extends RuntimeException {
        private ReturnToScreenException() {
        }
    }
}

