/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.controller;

import com.exe4j.runtime.WinLauncher;
import com.install4j.api.beans.ScriptProperty;
import com.install4j.runtime.beans.applications.Application;
import com.install4j.runtime.beans.applications.InstallerApplication;
import com.install4j.runtime.installer.ContextImpl;
import com.install4j.runtime.installer.config.InstallerConfig;
import com.install4j.runtime.installer.controller.ReturnToken;
import com.install4j.runtime.installer.controller.ScreenExecutor;
import com.install4j.runtime.installer.frontend.Messages;
import com.install4j.runtime.installer.helper.InstallerUtil;
import com.install4j.runtime.installer.helper.Logger;
import com.install4j.runtime.launcher.Launcher;
import com.install4j.runtime.util.StreamConsumerThread;
import java.io.File;
import java.io.IOException;
import java.util.Locale;
import javax.swing.SwingUtilities;

class LanguageSelector {
    LanguageSelector() {
    }

    static void initSystemAndDefaultLanguage() {
        String defaultLanguageId;
        String systemLanguageId = System.getProperty("install4j.systemLanguage");
        if (systemLanguageId == null || !systemLanguageId.matches("\\w\\w")) {
            systemLanguageId = System.getProperty("user.language");
            System.setProperty("install4j.systemLanguage", systemLanguageId);
        }
        if ((defaultLanguageId = System.getProperty("install4j.defaultLanguage")) != null && systemLanguageId.matches("\\w\\w|\\w\\w_\\w\\w")) {
            System.setProperty("user.language", defaultLanguageId);
            Locale.setDefault(new Locale(defaultLanguageId.substring(0, 2), defaultLanguageId.length() == 5 ? defaultLanguageId.substring(3, 5) : Locale.getDefault().getCountry()));
            System.setProperty("install4j.defaultLanguage", "");
        }
    }

    static void initLanguage(ContextImpl context, ScreenExecutor screenExecutor) {
        ScriptProperty languageSelectionScript;
        String languageId = context.getLanguageId();
        Application application = InstallerConfig.getCurrentApplication();
        if (application instanceof InstallerApplication && System.getProperty("install4j.language") == null && (languageSelectionScript = ((InstallerApplication)application).getLanguageSelectionScript()) != null && !languageSelectionScript.getValue().equals("")) {
            try {
                languageId = (String)context.runScript(languageSelectionScript, application, new Object[]{languageId});
                if (InstallerConfig.getCurrentInstance().getLanguageById(languageId) == null) {
                    languageId = null;
                }
            }
            catch (Exception e) {
                Logger.getInstance().log(e);
            }
        }
        if (languageId != null) {
            Messages.setLanguageConfig(InstallerConfig.getCurrentInstance().getLanguageById(languageId));
        } else {
            languageId = LanguageSelector.queryLanguage(screenExecutor);
            if (languageId == null) {
                InstallerUtil.exit(1);
            } else {
                context.setLanguageId(languageId);
                String installerFileName = System.getProperty("exe4j.moduleName");
                if (installerFileName == null || !new File(installerFileName).exists() || InstallerUtil.isMacOS() || languageId.equals(System.getProperty("user.language")) || context.isConsole() || context.isUnattended() || Boolean.getBoolean("install4j.noSecondaryProcess")) {
                    Messages.setLanguageConfig(InstallerConfig.getCurrentInstance().getLanguageById(languageId));
                } else {
                    String[] cmdarray;
                    Logger.getImpl().switchToSecondaryProcess();
                    if (InstallerUtil.isWindows()) {
                        InstallerUtil.storeJreInfoForInstaller();
                        cmdarray = WinLauncher.appendOriginalArgs(new String[]{installerFileName, "__i4j_lang_restart", "-Duser.language=" + languageId, "-Dinstall4j.language=" + languageId, "-Dinstall4j.systemLanguage=" + System.getProperty("install4j.systemLanguage"), "-Dexe4j.unextractedPositionRestart=" + Integer.getInteger("exe4j.unextractedPosition", 0)});
                    } else {
                        cmdarray = Launcher.appendOriginalArgs(new String[]{"/bin/sh", installerFileName, "__i4j_lang_restart", "-Duser.language=" + languageId, "-Dinstall4j.language=" + languageId, "-Dinstall4j.systemLanguage=" + System.getProperty("install4j.systemLanguage")});
                    }
                    try {
                        Process process = new ProcessBuilder(cmdarray).directory(new File(System.getProperty("user.dir"))).start();
                        StreamConsumerThread.consumeOutput(process);
                        try {
                            System.exit(process.waitFor());
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                            System.exit(1);
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        Messages.setLanguageConfig(InstallerConfig.getCurrentInstance().getLanguageById(languageId));
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String queryLanguage(final ScreenExecutor screenExecutor) {
        final ReturnToken wakeupToken = new ReturnToken();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                screenExecutor.selectLanguage(wakeupToken);
            }
        });
        ReturnToken returnToken = wakeupToken;
        synchronized (returnToken) {
            while (!wakeupToken.isWokenUp()) {
                try {
                    wakeupToken.wait();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
        return (String)wakeupToken.getReturnValue();
    }
}

