/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.frontend;

import com.install4j.api.Util;
import com.install4j.api.context.Context;
import com.install4j.api.context.ProgressInterface;
import com.install4j.api.context.UserCanceledException;
import com.install4j.api.formcomponents.ComponentTuple;
import com.install4j.api.formcomponents.FormComponent;
import com.install4j.api.formcomponents.FormEnvironment;
import com.install4j.api.screens.Console;
import com.install4j.api.screens.FormPanelContainer;
import com.install4j.api.screens.Screen;
import com.install4j.runtime.beans.formcomponents.CompoundComponentHandler;
import com.install4j.runtime.beans.formcomponents.FormEnvironmentImpl;
import com.install4j.runtime.beans.groups.FormComponentGroup;
import com.install4j.runtime.beans.groups.GroupOrientation;
import com.install4j.runtime.beans.groups.HorizontalFormComponentGroup;
import com.install4j.runtime.beans.groups.LayoutManagerGroup;
import com.install4j.runtime.beans.groups.TabGroup;
import com.install4j.runtime.beans.groups.VerticalFormComponentGroup;
import com.install4j.runtime.beans.screens.components.ScrollablePanel;
import com.install4j.runtime.installer.ContextImpl;
import com.install4j.runtime.installer.ContextInt;
import com.install4j.runtime.installer.config.FormComponentBeanConfig;
import com.install4j.runtime.installer.config.FormComponentProvider;
import com.install4j.runtime.installer.config.GroupProvider;
import com.install4j.runtime.installer.frontend.ComponentTupleImpl;
import com.install4j.runtime.installer.frontend.GUIHelper;
import com.install4j.runtime.installer.frontend.LayoutGroupImpl;
import com.install4j.runtime.installer.helper.InstallerUtil;
import com.install4j.runtime.installer.helper.Logger;
import com.install4j.runtime.util.SizeGroupComponentWrapper;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JViewport;

public class FormPanel
extends JPanel {
    private static final int[][] ANCHOR_MATRIX = new int[][]{{18, 11, 12}, {17, 10, 13}, {16, 15, 14}};
    private List<?> beanConfigs;
    private List<FormComponentProvider> formComponentProviders;
    private Context context;
    private boolean banner;
    private Screen screen;
    private JScrollPane scpComponents;
    protected JPanel componentsPanel;
    private Set<FormComponent> initializedComponents = new HashSet<FormComponent>();
    private FormEnvironment formEnvironment;

    public FormPanel(List<?> beanConfigs, Context context, boolean banner, Screen screen) {
        this.beanConfigs = beanConfigs;
        this.context = context;
        this.banner = banner;
        this.screen = screen;
        this.setupControls();
        this.setupComponent();
        GUIHelper.makeTransparent(this);
    }

    public FormEnvironment getFormEnvironment() {
        return this.formEnvironment;
    }

    public Screen getScreen() {
        return this.screen;
    }

    public ProgressInterface findProgressInterface() {
        for (FormComponentProvider formComponentProvider : this.formComponentProviders) {
            FormComponent formComponent = formComponentProvider.getFormComponent();
            if (!(formComponent instanceof ProgressInterface) || !formComponent.isEnabled()) continue;
            return (ProgressInterface)((Object)formComponent);
        }
        return null;
    }

    public void reinitializeComponents() {
        this.initializedComponents.clear();
        this.initializeComponents();
    }

    public void previous() {
        for (FormComponentProvider config : this.formComponentProviders) {
            if (!config.isResetInitOnPrevious()) continue;
            this.initializedComponents.remove(config.getFormComponent());
        }
    }

    public boolean checkCompleted() {
        for (FormComponentProvider config : this.formComponentProviders) {
            FormComponent formComponent = config.getFormComponent();
            if (!formComponent.isVisible() || formComponent.checkCompleted()) continue;
            return false;
        }
        return true;
    }

    public void willActivate() {
        this.initializeComponents();
        for (FormComponentProvider config : this.formComponentProviders) {
            config.getFormComponent().formWillActivate();
        }
    }

    public void activated() {
        for (FormComponentProvider config : this.formComponentProviders) {
            config.getFormComponent().formActivated();
        }
    }

    public void deactivated() {
        for (FormComponentProvider config : this.formComponentProviders) {
            config.getFormComponent().formDeactivated();
        }
    }

    public boolean handleUnattended() {
        this.initializeComponents();
        for (FormComponentProvider config : this.formComponentProviders) {
            FormComponent formComponent = this.processFormComponent(config);
            if (formComponent == null || formComponent.handleUnattended()) continue;
            return false;
        }
        return this.checkCompleted();
    }

    public boolean handleConsole(Console console) throws UserCanceledException {
        this.willActivate();
        this.activated();
        this.enableLayoutGroups(this.beanConfigs);
        do {
            for (FormComponentProvider config : this.formComponentProviders) {
                FormComponent formComponent = this.processFormComponent(config);
                if (formComponent == null || formComponent.handleConsole(console)) continue;
                this.deactivated();
                return false;
            }
        } while (!this.checkCompleted());
        this.deactivated();
        return true;
    }

    private boolean isInHiddenLayoutGroup(FormComponent formComponent) {
        return this.isInHiddenLayoutGroup(formComponent, this.beanConfigs);
    }

    private boolean isInHiddenLayoutGroup(FormComponent formComponent, List<?> beanConfigs) {
        for (Object bean : beanConfigs) {
            GroupProvider groupProvider;
            if (!(bean instanceof GroupProvider ? ((FormComponentGroup)(groupProvider = (GroupProvider)bean).getOrInstantiateBean()).isVisible() && !this.isInHiddenLayoutGroup(formComponent, groupProvider.getBeanConfigs()) : bean instanceof FormComponentProvider && ((FormComponentProvider)bean).getFormComponent() == formComponent)) continue;
            return false;
        }
        return true;
    }

    private void enableLayoutGroups(List beanConfigs) {
        for (Object bean : beanConfigs) {
            if (!(bean instanceof GroupProvider)) continue;
            GroupProvider groupProvider = (GroupProvider)bean;
            FormComponentGroup group = (FormComponentGroup)groupProvider.getOrInstantiateBean();
            try {
                Boolean visible = (Boolean)this.context.runScript(group.getVisibilityScript(), group, new Object[]{this.formEnvironment});
                if (visible != null) {
                    group.setVisible(visible);
                }
                this.enableLayoutGroups(groupProvider.getBeanConfigs());
            }
            catch (Exception e) {
                Util.printAnnotatedStackTrace(e);
                Logger.getInstance().log(e);
                return;
            }
        }
    }

    private FormComponent processFormComponent(FormComponentProvider config) {
        FormComponent formComponent = config.getFormComponent();
        if (this.isInHiddenLayoutGroup(formComponent)) {
            return null;
        }
        Object[] parameters = formComponent.getConfigurationObjectClass() != null ? new Object[]{this.formEnvironment, formComponent.getConfigurationObject()} : new Object[]{this.formEnvironment};
        formComponent.setVisible(ContextImpl.getContextInt(this.context).runBooleanScript(((FormComponentBeanConfig)config).getVisibilityClassName(), formComponent, parameters));
        if (!(formComponent instanceof CompoundComponentHandler || formComponent.isVisible() && formComponent.isEnabled())) {
            return null;
        }
        return formComponent;
    }

    protected void initializeComponents() {
        this.enableLayoutGroups(this.beanConfigs);
        for (FormComponentProvider config : this.formComponentProviders) {
            FormComponent formComponent = config.getFormComponent();
            if (this.initializedComponents.contains(formComponent)) continue;
            this.initializeComponent(formComponent, config);
            this.initializedComponents.add(formComponent);
        }
    }

    protected void initializeComponent(FormComponent formComponent, FormComponentProvider config) {
        try {
            formComponent.initialize();
        }
        catch (Exception e) {
            e.printStackTrace();
            Logger.getInstance().log(e);
        }
        Object[] parameters = formComponent.getConfigurationObjectClass() != null ? new Object[]{this.formEnvironment, formComponent.getConfigurationObject()} : new Object[]{this.formEnvironment};
        ContextInt contextInt = ContextImpl.getContextInt(this.context);
        if (contextInt != null) {
            try {
                formComponent.setVisible(contextInt.runBooleanScript(((FormComponentBeanConfig)config).getVisibilityClassName(), formComponent, parameters));
            }
            catch (Exception e) {
                e.printStackTrace();
                Logger.getInstance().log(e);
            }
            try {
                contextInt.runBooleanScript(((FormComponentBeanConfig)config).getInitClassName(), formComponent, parameters);
            }
            catch (Exception e) {
                e.printStackTrace();
                Logger.getInstance().log(e);
            }
        }
    }

    private void setupControls() {
        this.componentsPanel = new ScrollablePanel();
        this.componentsPanel.setLayout(new GridBagLayout());
        this.scpComponents = new JScrollPane();
        this.scpComponents.setViewport(new JViewport(){

            @Override
            public void setViewPosition(Point p) {
                p.y = Math.max(0, p.y);
                super.setViewPosition(p);
            }
        });
        this.scpComponents.setViewportView(this.componentsPanel);
        this.scpComponents.setHorizontalScrollBarPolicy(31);
        if (this.banner) {
            this.componentsPanel.setBackground(Color.white);
            this.scpComponents.getViewport().setBackground(Color.white);
        } else if (!GUIHelper.isGtkLaF()) {
            this.scpComponents.getViewport().setBackground(this.componentsPanel.getBackground());
        } else {
            this.scpComponents.getViewport().setOpaque(false);
        }
        this.scpComponents.setViewportBorder(null);
        this.scpComponents.setBorder(null);
    }

    private void setupComponent() {
        this.setLayout(new BorderLayout());
        this.formEnvironment = this.createFormEnvironment(new FormComponent[0], new String[0], new String[0], new ComponentTuple[0], Collections.emptyList());
        ArrayList<FormComponent> formComponentsList = new ArrayList<FormComponent>();
        ArrayList<String> idsList = new ArrayList<String>();
        ArrayList<String> displayedIdsList = new ArrayList<String>();
        ArrayList<ComponentTuple> componentTuplesList = new ArrayList<ComponentTuple>();
        this.formComponentProviders = new ArrayList<FormComponentProvider>();
        PanelConstructionState panelConstructionState = this.buildPanel(this.beanConfigs, this.componentsPanel, new VerticalFormComponentGroup(), formComponentsList, idsList, displayedIdsList, componentTuplesList, false);
        FormComponent[] formComponents = formComponentsList.toArray(new FormComponent[formComponentsList.size()]);
        String[] ids = idsList.toArray(new String[idsList.size()]);
        String[] displayedIds = displayedIdsList.toArray(new String[idsList.size()]);
        ComponentTuple[] componentTuples = componentTuplesList.toArray(new ComponentTuple[componentTuplesList.size()]);
        this.formEnvironment = this.createFormEnvironment(formComponents, ids, displayedIds, componentTuples, this.beanConfigs);
        this.setFormEnvironment(this.formEnvironment.getFormComponentTree());
        if (this.screen != null) {
            if (((FormPanelContainer)((Object)this.screen)).isScrollFormPanel()) {
                this.add((Component)this.scpComponents, "Center");
            } else {
                if (!panelConstructionState.verticalSpaceFilled) {
                    GridBagConstraints gc = panelConstructionState.gc;
                    gc.gridx = 0;
                    gc.weighty = 1.0;
                    gc.fill = 3;
                    this.componentsPanel.add((Component)new JPanel(), gc);
                    ++gc.gridy;
                }
                this.add((Component)this.componentsPanel, "Center");
            }
        }
    }

    private void setFormEnvironment(List<?> components) {
        for (Object bean : components) {
            if (bean instanceof FormComponent) {
                ((FormComponent)bean).setFormEnvironment(this.formEnvironment);
                continue;
            }
            if (!(bean instanceof LayoutGroupImpl)) continue;
            LayoutGroupImpl layoutGroup = (LayoutGroupImpl)bean;
            layoutGroup.getGroup().setFormEnvironment(this.formEnvironment);
            this.setFormEnvironment(layoutGroup.getChildren());
        }
    }

    private PanelConstructionState buildPanel(List<?> beanConfigs, JComponent container, FormComponentGroup parentGroup, List<FormComponent> formComponentsList, List<String> idsList, List<String> displayedIdsList, List<ComponentTuple> componentTuplesList, boolean baseLineOverride) {
        GridBagConstraints gc = new GridBagConstraints();
        gc.gridx = 0;
        gc.gridy = 0;
        boolean verticalSpaceFilled = false;
        boolean horizontalSpaceFilled = false;
        boolean first = true;
        SizeGroupComponentWrapper firstSizeGroupComponentWrapper = null;
        for (Object bean : beanConfigs) {
            Object config;
            if (bean instanceof FormComponentProvider && parentGroup instanceof LayoutManagerGroup) {
                config = (FormComponentProvider)bean;
                if (!config.isEnabled() || config.getFormComponent() == null) continue;
                this.formComponentProviders.add((FormComponentProvider)config);
                verticalSpaceFilled = verticalSpaceFilled || config.getFormComponent().isFillCenterVertical();
                horizontalSpaceFilled = horizontalSpaceFilled || config.getFormComponent().isFillCenterHorizontal();
                ComponentTuple componentTuple = this.addFormComponent((FormComponentProvider)config, (JPanel)container, gc, (LayoutManagerGroup)parentGroup, baseLineOverride, first);
                if (first && componentTuple.getLeftComponent() != null) {
                    firstSizeGroupComponentWrapper = (SizeGroupComponentWrapper)componentTuple.getLeftComponent().getParent();
                }
                formComponentsList.add(config.getFormComponent());
                idsList.add(this.dequalifyId(config.getId()));
                displayedIdsList.add(this.dequalifyId(config.getDisplayedId()));
                componentTuplesList.add(componentTuple);
                if (this.banner) {
                    this.makeTransparent(componentTuple.getLeftComponent());
                    this.makeTransparent(componentTuple.getCenterComponent());
                    this.makeTransparent(componentTuple.getRightComponent());
                }
            } else if (bean instanceof GroupProvider) {
                config = (GroupProvider)bean;
                if (!config.isEnabled()) continue;
                FormComponentGroup group = (FormComponentGroup)config.getOrInstantiateBean();
                group.setFormEnvironment(this.formEnvironment);
                group.setContext(this.context);
                group.setId(config.getId());
                JComponent childContainer = group.createComponent(container);
                PanelConstructionState panelConstructionState = this.buildPanel(config.getBeanConfigs(), childContainer, group, formComponentsList, idsList, displayedIdsList, componentTuplesList, group.isBaselineOverride());
                verticalSpaceFilled = verticalSpaceFilled || panelConstructionState.verticalSpaceFilled;
                boolean bl = horizontalSpaceFilled = horizontalSpaceFilled || panelConstructionState.horizontalSpaceFilled;
                if (group instanceof TabGroup) {
                    this.addTabGroup((TabGroup)group, childContainer, panelConstructionState);
                } else {
                    GroupOrientation parentGroupOrientation = parentGroup.getGroupOrientation();
                    if (parentGroupOrientation == GroupOrientation.VERTICAL) {
                        gc.gridx = 0;
                        gc.gridwidth = 3;
                    } else {
                        gc.gridwidth = 1;
                    }
                    if (parentGroup instanceof VerticalFormComponentGroup && group.getGroupOrientation() == GroupOrientation.HORIZONTAL && ((HorizontalFormComponentGroup)group).isAlignFirstLabel() && panelConstructionState.firstSizeGroupComponentWrapper != null) {
                        ((VerticalFormComponentGroup)parentGroup).getSizeGroup().addComponentWrapper(panelConstructionState.firstSizeGroupComponentWrapper);
                    }
                    horizontalSpaceFilled |= group.isWidthOverride();
                    verticalSpaceFilled |= group.isHeightOverride();
                    boolean groupHorizontalSpaceFilled = panelConstructionState.horizontalSpaceFilled || group.isWidthOverride();
                    boolean groupVerticalSpaceFilled = panelConstructionState.verticalSpaceFilled || group.isHeightOverride();
                    gc.anchor = group.getAnchor().getValue();
                    gc.weightx = groupHorizontalSpaceFilled ? 1.0 : 0.0;
                    gc.weighty = groupVerticalSpaceFilled ? 1.0 : 0.0;
                    gc.fill = this.getFillMode(groupHorizontalSpaceFilled, groupVerticalSpaceFilled);
                    gc.insets = (Insets)group.getInsets().clone();
                    container.add((Component)childContainer, gc);
                    ++gc.gridx;
                    if (parentGroupOrientation == GroupOrientation.VERTICAL) {
                        ++gc.gridy;
                    }
                }
            }
            first = false;
        }
        return new PanelConstructionState(gc, verticalSpaceFilled, horizontalSpaceFilled, firstSizeGroupComponentWrapper);
    }

    private void makeTransparent(JComponent component) {
        if (component != null && !GUIHelper.isWindowsClassicLaF()) {
            component.setOpaque(false);
        }
    }

    private void addTabGroup(TabGroup group, JComponent childContainer, PanelConstructionState panelConstructionState) {
        GridBagConstraints gc = new GridBagConstraints();
        gc.anchor = group.getAnchor().getValue();
        gc.fill = this.getFillMode(panelConstructionState.horizontalSpaceFilled, panelConstructionState.verticalSpaceFilled);
        gc.insets = (Insets)group.getInsets().clone();
        gc.weighty = 1.0;
        gc.weightx = 1.0;
        group.getPanel().add((Component)childContainer, gc);
    }

    private String dequalifyId(String id) {
        int index = id.indexOf(58);
        if (index < 0) {
            return id;
        }
        return id.substring(index + 1);
    }

    private int getFillMode(boolean horizontalSpaceFilled, boolean verticalSpaceFilled) {
        if (horizontalSpaceFilled) {
            return verticalSpaceFilled ? 1 : 2;
        }
        return verticalSpaceFilled ? 3 : 0;
    }

    protected FormEnvironmentImpl createFormEnvironment(FormComponent[] formComponents, String[] ids, String[] displayedIds, ComponentTuple[] componentTuples, List beanConfigs) {
        return new FormEnvironmentImpl(this, formComponents, ids, displayedIds, componentTuples, beanConfigs);
    }

    private ComponentTuple addFormComponent(FormComponentProvider config, JPanel panel, GridBagConstraints gc, LayoutManagerGroup group, boolean baselineOverride, boolean first) {
        int cellSpacing;
        GroupOrientation orientation = group.getGroupOrientation();
        FormComponent formComponent = config.getFormComponent();
        formComponent.setContext(config.wrapContext(this.context));
        formComponent.setFormEnvironment(this.formEnvironment);
        JComponent leftComponent = formComponent.createLeftComponent();
        JComponent centerComponent = formComponent.createCenterComponent();
        JComponent rightComponent = formComponent.createRightComponent();
        if (centerComponent == null) {
            return new ComponentTupleImpl(null, null, null);
        }
        gc.insets.top = config.getInsetTop();
        gc.insets.bottom = config.getInsetBottom();
        gc.insets.left = config.getInsetLeft();
        gc.insets.right = 0;
        int n = cellSpacing = first ? 0 : group.getCellSpacing();
        if (orientation == GroupOrientation.VERTICAL) {
            gc.gridx = 0;
            gc.insets.top += cellSpacing;
        } else {
            gc.insets.left += cellSpacing;
        }
        gc.gridwidth = 1;
        boolean baselineLabel = baselineOverride;
        if (leftComponent != null) {
            if (leftComponent instanceof JLabel && ((JLabel)leftComponent).getText().length() > 0 && InstallerUtil.isAtLeastJava16() && !group.isMakeSameHeight()) {
                baselineLabel = true;
            }
            gc.anchor = baselineLabel ? GUIHelper.BASELINE_LEADING : this.getAnchor(leftComponent);
            gc.weightx = 0.0;
            gc.weighty = 0.0;
            gc.fill = 0;
            SizeGroupComponentWrapper componentWrapper = new SizeGroupComponentWrapper(leftComponent);
            panel.add((Component)componentWrapper, gc);
            if (group instanceof VerticalFormComponentGroup) {
                ((VerticalFormComponentGroup)group).getSizeGroup().addComponentWrapper(componentWrapper);
            }
            ++gc.gridx;
            gc.insets.left = 0;
        } else if (orientation == GroupOrientation.VERTICAL) {
            ++gc.gridwidth;
        }
        if (rightComponent == null) {
            if (orientation == GroupOrientation.VERTICAL) {
                ++gc.gridwidth;
            }
            gc.insets.right = config.getInsetRight();
        }
        boolean heightOverride = false;
        boolean widthOverride = false;
        if (orientation == GroupOrientation.HORIZONTAL) {
            gc.weightx = formComponent.isFillCenterHorizontal() ? 1.0 : 0.0;
            heightOverride = group.isMakeSameHeight();
        } else {
            gc.weightx = 1.0;
        }
        if (orientation == GroupOrientation.VERTICAL) {
            gc.weighty = formComponent.isFillCenterVertical() ? 1.0 : 0.0;
            widthOverride = group.isMakeSameWidth();
        } else {
            gc.weighty = 1.0;
        }
        if (widthOverride) {
            gc.weightx = 1.0;
        }
        if (heightOverride) {
            gc.weighty = 1.0;
        }
        gc.fill = this.getFillMode(formComponent.isFillCenterHorizontal() || widthOverride, formComponent.isFillCenterVertical() || heightOverride);
        gc.anchor = baselineLabel ? GUIHelper.BASELINE_LEADING : this.getAnchor(centerComponent);
        panel.add((Component)centerComponent, gc);
        gc.gridx += gc.gridwidth;
        if (rightComponent != null) {
            gc.gridwidth = 1;
            gc.weightx = 0.0;
            gc.weighty = 0.0;
            gc.fill = 0;
            gc.anchor = baselineLabel ? GUIHelper.BASELINE_LEADING : this.getAnchor(rightComponent);
            gc.insets.right = config.getInsetRight();
            gc.insets.left = 0;
            panel.add((Component)rightComponent, gc);
            ++gc.gridx;
        }
        if (orientation == GroupOrientation.VERTICAL) {
            ++gc.gridy;
        }
        return new ComponentTupleImpl(leftComponent, centerComponent, rightComponent);
    }

    private int getAnchor(JComponent component) {
        float alignmentY = component.getAlignmentY();
        int vertical = alignmentY < 0.5f ? 0 : (alignmentY > 0.5f ? 2 : 1);
        float alignmentX = component.getAlignmentX();
        int horizontal = alignmentX < 0.5f ? 0 : (alignmentY > 0.5f ? 2 : 1);
        return ANCHOR_MATRIX[vertical][horizontal];
    }

    private class PanelConstructionState {
        private final GridBagConstraints gc;
        private final boolean verticalSpaceFilled;
        private final boolean horizontalSpaceFilled;
        private final SizeGroupComponentWrapper firstSizeGroupComponentWrapper;

        public PanelConstructionState(GridBagConstraints gc, boolean verticalSpaceFilled, boolean horizontalSpaceFilled, SizeGroupComponentWrapper firstSizeGroupComponentWrapper) {
            this.gc = gc;
            this.verticalSpaceFilled = verticalSpaceFilled;
            this.horizontalSpaceFilled = horizontalSpaceFilled;
            this.firstSizeGroupComponentWrapper = firstSizeGroupComponentWrapper;
        }
    }
}

