/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.frontend;

import com.install4j.api.Util;
import com.install4j.api.beans.ExternalFile;
import com.install4j.api.context.UserCanceledException;
import com.install4j.runtime.beans.applications.Application;
import com.install4j.runtime.beans.applications.CustomApplication;
import com.install4j.runtime.beans.applications.InstallerApplication;
import com.install4j.runtime.beans.applications.UninstallerApplication;
import com.install4j.runtime.installer.config.InstallerConfig;
import com.install4j.runtime.installer.frontend.Invokable;
import com.install4j.runtime.installer.frontend.Messages;
import com.install4j.runtime.installer.frontend.VariableResourceBundleWrapper;
import com.install4j.runtime.installer.helper.ConsoleImpl;
import com.install4j.runtime.installer.helper.InstallerUtil;
import com.install4j.runtime.installer.helper.Logger;
import com.install4j.runtime.installer.helper.comm.HelperCommunication;
import com.install4j.runtime.installer.helper.launching.LaunchDescriptor;
import com.install4j.runtime.installer.helper.launching.LaunchHelper;
import com.install4j.runtime.installer.platform.win32.FolderInfo;
import com.install4j.runtime.util.RetinaIcon;
import com.install4j.runtime.util.VersionCheck;
import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.Window;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JSlider;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.basic.BasicSeparatorUI;

public class GUIHelper {
    public static final ImageIcon DEFAULT_ICON_FRAME_16 = GUIHelper.loadIcon("install4j_icon_16.png");
    public static final ImageIcon DEFAULT_ICON_FRAME_32 = GUIHelper.loadIcon("install4j_icon_32.png");
    public static final ImageIcon DEFAULT_ICON_FRAME_48 = GUIHelper.loadIcon("install4j_icon_48.png");
    private static final String ICONS_DIRECTORY = "icons/";
    public static final int BASELINE_LEADING = InstallerUtil.isAtLeastJava16() ? 512 : 17;
    private static boolean lafSet = false;
    public static final Icon ICON_FOLDER_OPEN = GUIHelper.loadIcon("folder_open.png");
    public static final Icon ICON_FOLDER_CLOSED = GUIHelper.loadIcon("folder_closed.png");
    private static String browserExecutable = "";
    private static Boolean retina;

    public static String getBrowserExecutable() {
        return browserExecutable;
    }

    public static void setBrowserExecutable(String browserExecutable) {
        GUIHelper.browserExecutable = browserExecutable;
    }

    public static void setLanguage(String languageId) {
        HelperCommunication.helperUnsupported();
        if (InstallerUtil.isInProcess()) {
            return;
        }
        if (languageId != null) {
            String country;
            int index = languageId.indexOf("_");
            if (index > -1) {
                country = languageId.substring(index + 1);
                languageId = languageId.substring(0, index);
            } else {
                country = "";
            }
            try {
                Locale.setDefault(new Locale(languageId, country));
            }
            catch (Exception exception) {}
        } else {
            languageId = Locale.getDefault().getLanguage();
        }
        GUIHelper.setLaF();
        if (languageId.equals("ja") || languageId.equals("ko") || languageId.startsWith("zh")) {
            Font font = UIManager.getFont("Label.font");
            UIManager.put("OptionPane.font", font);
            UIManager.put("OptionPane.messageFont", font);
            UIManager.put("OptionPane.buttonFont", font);
        }
        String fontOffset = System.getProperty("install4j.font.offset");
        String javaVersion = System.getProperty("java.version");
        if (fontOffset != null) {
            GUIHelper.adjustFontSize(Integer.parseInt(fontOffset));
        } else if (languageId.equals("zh_TW") && javaVersion.startsWith("1.4")) {
            GUIHelper.adjustFontSize(2);
        }
    }

    public static void setLaF() {
        if (!InstallerUtil.isInProcess()) {
            GUIHelper.setLafUnconditional();
        }
    }

    public static void setLafUnconditional() {
        HelperCommunication.helperUnsupported();
        if (!lafSet) {
            lafSet = true;
            if (!Boolean.getBoolean("install4j.nolaf") && !Boolean.getBoolean("java.awt.headless") && System.getProperty("swing.defaultlaf") == null) {
                try {
                    UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    public static boolean isWindowsLaF() {
        HelperCommunication.helperUnsupported();
        return UIManager.getLookAndFeel().getID().equals("Windows");
    }

    public static boolean isMetalLaF() {
        HelperCommunication.helperUnsupported();
        return UIManager.getLookAndFeel().getID().equals("Metal");
    }

    public static boolean isWindowsXpLaF() {
        HelperCommunication.helperUnsupported();
        return GUIHelper.isWindowsLaF() && Boolean.TRUE.equals(Toolkit.getDefaultToolkit().getDesktopProperty("win.xpstyle.themeActive")) && !Boolean.getBoolean("swing.noxp");
    }

    public static boolean isWindowsClassicLaF() {
        HelperCommunication.helperUnsupported();
        return GUIHelper.isWindowsLaF() && (!Boolean.TRUE.equals(Toolkit.getDefaultToolkit().getDesktopProperty("win.xpstyle.themeActive")) || Boolean.getBoolean("swing.noxp") || UIManager.getLookAndFeel().getClass().getName().endsWith("WindowsClassicLookAndFeel"));
    }

    public static boolean isGtkLaF() {
        HelperCommunication.helperUnsupported();
        return UIManager.getLookAndFeel().getID().equals("GTK");
    }

    private static void adjustFontSize(int adjustment) {
        HelperCommunication.helperUnsupported();
        UIDefaults defaults = UIManager.getDefaults();
        LinkedList<Object> newDefaults = new LinkedList<Object>();
        HashMap<Font, Font> newFonts = new HashMap<Font, Font>();
        for (Object key : defaults.keySet()) {
            Object value = defaults.get(key);
            if (!(value instanceof Font)) continue;
            Font oldFont = (Font)value;
            Font newFont = (Font)newFonts.get(oldFont);
            if (newFont == null) {
                newFont = new Font(oldFont.getName(), oldFont.getStyle(), oldFont.getSize() + adjustment);
                newFonts.put(oldFont, newFont);
            }
            newDefaults.add(key);
            newDefaults.add(newFont);
        }
        defaults.putDefaults(newDefaults.toArray());
    }

    public static ImageIcon loadIcon(String fileName) {
        URL iconUrl;
        String retinaFileName;
        HelperCommunication.helperUnsupported();
        if (GUIHelper.isRetina() && (retinaFileName = GUIHelper.toRetinaPath(fileName)) != null && (iconUrl = GUIHelper.getIconUrl(retinaFileName)) != null) {
            return new RetinaIcon(iconUrl);
        }
        return new ImageIcon(GUIHelper.getIconUrl(fileName));
    }

    public static ImageIcon loadIcon(File file) {
        File retinaFile;
        String retinaFileName;
        HelperCommunication.helperUnsupported();
        if (GUIHelper.isRetina() && (retinaFileName = GUIHelper.toRetinaPath(file.getPath())) != null && (retinaFile = new File(retinaFileName)).exists()) {
            return new RetinaIcon(retinaFile.getAbsolutePath());
        }
        return new ImageIcon(file.getAbsolutePath());
    }

    private static String toRetinaPath(String path) {
        int index = path.toLowerCase().lastIndexOf(46);
        if (index > -1) {
            return path.substring(0, index) + "@2x" + path.substring(index);
        }
        return null;
    }

    private static URL getIconUrl(String fileName) {
        return GUIHelper.class.getResource(ICONS_DIRECTORY + fileName);
    }

    public static boolean isRetina() {
        if (retina == null) {
            retina = GUIHelper.checkRetina();
        }
        return retina;
    }

    private static boolean checkRetina() {
        if (Boolean.getBoolean("java.awt.headless")) {
            return false;
        }
        if (VersionCheck.checkCompatible("1.7.0_40", System.getProperty("java.version"))) {
            GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
            GraphicsDevice device = graphicsEnvironment.getDefaultScreenDevice();
            try {
                Field field = device.getClass().getDeclaredField("scale");
                if (field != null) {
                    field.setAccessible(true);
                    Object scale = field.get(device);
                    if (scale instanceof Integer && (Integer)scale == 2) {
                        return true;
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    public static int showOptionDialog(Component parent, final String message, final String[] options, final int messageType) throws UserCanceledException {
        String[] keys = new String[options.length];
        for (int i = 0; i < options.length; ++i) {
            String option = options[i];
            int index = option.indexOf(38);
            if (index > -1 && index < option.length() - 1) {
                keys[i] = option.substring(index + 1, index + 2).toLowerCase();
            } else {
                String key = option.substring(0, 1).toLowerCase();
                boolean found = false;
                for (int j = 0; j < i; ++j) {
                    if (!keys[j].equals(key)) continue;
                    found = true;
                    break;
                }
                keys[i] = !found ? key : String.valueOf(i);
            }
            options[i] = option.replaceAll("&", "");
        }
        if (InstallerUtil.isUnattended()) {
            return -1;
        }
        if (InstallerUtil.isConsole()) {
            return ConsoleImpl.getInstance().askOption(message, options, keys, 0);
        }
        GUIHelper.setLaF();
        final Component nonNullParent = parent == null ? GUIHelper.getParentWindow() : parent;
        final int[] result = new int[1];
        if (SwingUtilities.isEventDispatchThread()) {
            GUIHelper.showOptionDialogInternal(parent, message, messageType, options, result);
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        GUIHelper.showOptionDialogInternal(nonNullParent, message, messageType, options, result);
                    }
                });
            }
            catch (Exception e) {
                InstallerUtil.reportException(e);
            }
        }
        return result[0];
    }

    private static void showOptionDialogInternal(Component parent, String message, int messageType, String[] options, int[] result) {
        HelperCommunication.helperUnsupported();
        parent = GUIHelper.getOptionPaneParent(parent);
        result[0] = JOptionPane.showOptionDialog(parent, message, Messages.getMessages().getString("SetupAppTitle"), 0, messageType, null, options, options[0]);
        GUIHelper.disposeTempFrame(parent);
    }

    public static Window getParentWindow() {
        if (InstallerUtil.isUnattended() || InstallerUtil.isConsole()) {
            return null;
        }
        HelperCommunication.helperUnsupported();
        Frame[] frames = JFrame.getFrames();
        if (frames != null) {
            Frame showingFrame = null;
            Frame nonTempFrame = null;
            for (Frame frame : frames) {
                if (frame.isShowing()) {
                    showingFrame = frame;
                    if (frame.isActive()) {
                        return frame;
                    }
                }
                if (frame instanceof TempFrame) continue;
                nonTempFrame = frame;
            }
            if (showingFrame != null) {
                return showingFrame;
            }
            if (nonTempFrame != null) {
                return nonTempFrame;
            }
        }
        return null;
    }

    public static void showMessage(Component parent, final String message, final int messageType) {
        if (InstallerUtil.isUnattended() || InstallerUtil.isConsole()) {
            ConsoleImpl.getInstance().println(message);
        } else {
            Component nonNullParent;
            GUIHelper.setLaF();
            Component component = nonNullParent = parent == null ? GUIHelper.getParentWindow() : parent;
            if (SwingUtilities.isEventDispatchThread()) {
                GUIHelper.showMessageInternal(nonNullParent, message, messageType);
            } else {
                try {
                    SwingUtilities.invokeAndWait(new Runnable(){

                        @Override
                        public void run() {
                            GUIHelper.showMessageInternal(nonNullParent, message, messageType);
                        }
                    });
                }
                catch (Exception e) {
                    InstallerUtil.reportException(e);
                }
            }
        }
    }

    private static void showMessageInternal(Component parent, String message, int messageType) {
        HelperCommunication.helperUnsupported();
        parent = GUIHelper.getOptionPaneParent(parent);
        JOptionPane.showOptionDialog(parent, message, Messages.getMessages().getString("SetupAppTitle"), -1, messageType, null, new Object[]{Messages.getMessages().getString("ButtonOK")}, null);
        GUIHelper.disposeTempFrame(parent);
    }

    private static Component getOptionPaneParent(Component parent) {
        HelperCommunication.helperUnsupported();
        if (Util.isWindows() && parent == null) {
            return new TempFrame();
        }
        return parent;
    }

    private static void disposeTempFrame(Component parent) {
        HelperCommunication.helperUnsupported();
        if (parent instanceof TempFrame) {
            ((TempFrame)parent).dispose();
        }
    }

    public static void showURL(String urlSpec) {
        if (InstallerUtil.isUnattended() || InstallerUtil.isConsole()) {
            return;
        }
        Window window = GUIHelper.getParentWindow();
        try {
            if (!GUIHelper.showUrlWithDesktop(urlSpec)) {
                GUIHelper.showBrowserError(window);
            }
        }
        catch (IOException e) {
            GUIHelper.showBrowserError(window);
        }
    }

    private static boolean showUrlWithDesktop(String urlSpec) throws IOException {
        if (!Desktop.isDesktopSupported()) {
            return false;
        }
        Desktop desktop = Desktop.getDesktop();
        if (!desktop.isSupported(Desktop.Action.BROWSE)) {
            return false;
        }
        try {
            desktop.browse(new URI(GUIHelper.encodeSpaces(urlSpec)));
            return true;
        }
        catch (IOException e) {
            Logger.getInstance().error(null, "The URI " + urlSpec + " cannot be shown.");
            Logger.getInstance().log(e);
            throw e;
        }
        catch (Throwable t) {
            Logger.getInstance().error(null, "The URI " + urlSpec + " cannot be shown.");
            Logger.getInstance().log(t);
            throw new IOException(t);
        }
    }

    public static Color getSeparatorColor() {
        HelperCommunication.helperUnsupported();
        return UIManager.getColor("Separator.foreground");
    }

    public static boolean confirmCancel(Component parent) {
        HelperCommunication.helperUnsupported();
        VariableResourceBundleWrapper messages = Messages.getMessages();
        int result = 0;
        try {
            String message = null;
            Application application = InstallerConfig.getCurrentApplication();
            if (application instanceof InstallerApplication) {
                message = messages.getString("ExitSetupMessage");
            } else if (application instanceof UninstallerApplication) {
                message = messages.getString("ExitUninstallerMessage");
            } else if (application instanceof CustomApplication) {
                CustomApplication customApplication = (CustomApplication)application;
                if (customApplication.isShowCancelMessage()) {
                    message = customApplication.getCancelMessage();
                }
            } else {
                message = messages.getString("ExitApplication");
            }
            if (message != null) {
                result = GUIHelper.showOptionDialog(parent, message, new String[]{messages.getString("ButtonExit"), messages.getString("ButtonContinue")}, 3);
            }
        }
        catch (UserCanceledException userCanceledException) {
            // empty catch block
        }
        return result == 0;
    }

    public static String encodeSpaces(String url) {
        StringBuilder buffer = new StringBuilder();
        int urlLen = url.length();
        for (int i = 0; i < urlLen; ++i) {
            if (url.charAt(i) == ' ') {
                buffer.append("%20");
                continue;
            }
            buffer.append(url.charAt(i));
        }
        return buffer.toString();
    }

    private static void showBrowserError(Window window) {
        if (!Boolean.getBoolean("install4j.noBrowserError")) {
            GUIHelper.showMessage(window, Messages.getMessages().getString("ErrorStartingBrowser"), 0);
        }
    }

    public static List<Image> getFrameIconImages() {
        HelperCommunication.helperUnsupported();
        ArrayList<Image> icons = new ArrayList<Image>();
        Application currentApplication = InstallerConfig.getCurrentApplication();
        if (currentApplication != null && currentApplication.isUseCustomIcon()) {
            try {
                for (ExternalFile iconFile : currentApplication.getCustomIconImageFiles()) {
                    ImageIcon icon = GUIHelper.loadIcon(InstallerUtil.getInstallerFile(iconFile.getPath()));
                    if (icon.getIconWidth() <= 0) continue;
                    icons.add(icon.getImage());
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        if (icons.size() == 0) {
            icons.add(DEFAULT_ICON_FRAME_16.getImage());
            icons.add(DEFAULT_ICON_FRAME_32.getImage());
            icons.add(DEFAULT_ICON_FRAME_48.getImage());
        }
        return icons;
    }

    public static void makeTransparent(JComponent component) {
        HelperCommunication.helperUnsupported();
        if (!GUIHelper.isWindowsLaF() && !GUIHelper.isMetalLaF()) {
            return;
        }
        if (component.getBackground() instanceof ColorUIResource && (component instanceof JPanel || component instanceof JRadioButton || component instanceof JCheckBox || component instanceof JSlider || component instanceof JSplitPane || !GUIHelper.isWindowsClassicLaF() && component instanceof JButton)) {
            component.setOpaque(false);
        }
        int componentCount = component.getComponentCount();
        for (int i = 0; i < componentCount; ++i) {
            Component child = component.getComponent(i);
            if (!(child instanceof JComponent)) continue;
            GUIHelper.makeTransparent((JComponent)child);
        }
    }

    public static void setIconImages(Window window) {
        HelperCommunication.helperUnsupported();
        window.setIconImages(GUIHelper.getFrameIconImages());
    }

    public static void invokeLater(Runnable runnable) {
        HelperCommunication.helperUnsupported();
        if (EventQueue.isDispatchThread()) {
            runnable.run();
        } else {
            EventQueue.invokeLater(runnable);
        }
    }

    public static void showPath(String path, boolean openDmg) {
        if (InstallerUtil.isUnattended() || InstallerUtil.isConsole()) {
            return;
        }
        File file = new File(path);
        boolean directory = file.isDirectory();
        if (InstallerUtil.isMacOS()) {
            File openArgument = directory || openDmg && path.toLowerCase().endsWith(".dmg") ? file : file.getParentFile();
            LaunchHelper.launchApplication(new LaunchDescriptor(new File("/usr/bin/open")).arguments(new String[]{openArgument.getAbsolutePath()}));
        } else {
            String[] commandArray;
            File workingDirectory = null;
            if (InstallerUtil.isWindows()) {
                if (path.indexOf(32) > -1) {
                    path = FolderInfo.getShortPathName(path);
                }
                commandArray = new String[]{"explorer.exe", (directory ? "" : "/select,") + path};
            } else {
                commandArray = new String[]{"/bin/sh", "-c", "xdg-open .;  if [ $? -ne 0 ]; then xterm; fi"};
                workingDirectory = directory ? file : file.getParentFile();
            }
            try {
                new ProcessBuilder(commandArray).directory(workingDirectory).start();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static JSeparator createHorizontalSeparator() {
        JSeparator separator = new JSeparator(0);
        if (Util.isMacOS()) {
            separator.setUI(new BasicSeparatorUI());
        }
        return separator;
    }

    public static void invokeOnEDT(Runnable runnable) {
        HelperCommunication.helperUnsupported();
        if (EventQueue.isDispatchThread()) {
            runnable.run();
        } else {
            try {
                EventQueue.invokeAndWait(runnable);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static Object invokeOnEDT(final Invokable invokable) {
        HelperCommunication.helperUnsupported();
        if (EventQueue.isDispatchThread()) {
            try {
                return invokable.invoke();
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        }
        final Throwable[] throwable = new Throwable[1];
        final Object[] result = new Object[1];
        try {
            EventQueue.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    try {
                        result[0] = invokable.invoke();
                    }
                    catch (Throwable t) {
                        throwable[0] = t;
                    }
                }
            });
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (throwable[0] != null) {
            throw new RuntimeException(throwable[0]);
        }
        return result[0];
    }

    private static class TempFrame
    extends JFrame {
        private TempFrame() {
            super(Messages.getMessages().getString("SetupAppTitle"));
            this.setUndecorated(true);
            this.setVisible(true);
            this.setLocationRelativeTo(null);
            GUIHelper.setIconImages(this);
        }
    }
}

